/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rentsoft.server;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.rentsoft.common.RentsoftService;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftPayment;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.RentsoftProduct;
import ru.bitel.bgbilling.modules.rentsoft.common.bean.SubscribtionStatus;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftPaymentManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.RentsoftProductManager;
import ru.bitel.bgbilling.modules.rentsoft.server.bean.SubscribtionStatusManager;
import ru.bitel.common.model.Pair;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.rentsoft.common.RentsoftService")
public class RentsoftServiceImpl
extends AbstractService
implements RentsoftService {
    public List<RentsoftProduct> getProductList() throws BGException {
        RentsoftProductManager rentsoftProductManager = new RentsoftProductManager(this.getConnection(), this.moduleId);
        List<RentsoftProduct> rentsoftProducts = rentsoftProductManager.getList();
        rentsoftProductManager.close();
        return rentsoftProducts;
    }

    public List<RentsoftPayment> getPaymentsByProduct(int productId, int cid) throws BGException {
        RentsoftPaymentManager rentsoftPaymentManager = new RentsoftPaymentManager(this.getConnection(), this.moduleId);
        List<RentsoftPayment> rentsoftPayments = rentsoftPaymentManager.getPaymentList(productId, cid);
        rentsoftPaymentManager.close();
        return rentsoftPayments;
    }

    public List<Pair<RentsoftProduct, SubscribtionStatus>> getSubscribtionStatuses(int contractId) throws BGException {
        ArrayList<Pair<RentsoftProduct, SubscribtionStatus>> result = new ArrayList<Pair<RentsoftProduct, SubscribtionStatus>>();
        SubscribtionStatusManager subscribtionStatusManager = new SubscribtionStatusManager(this.getConnection(), this.moduleId);
        RentsoftProductManager rentsoftProductManager = new RentsoftProductManager(this.getConnection(), this.moduleId);
        for (SubscribtionStatus ss : subscribtionStatusManager.getList(contractId)) {
            result.add((Pair<RentsoftProduct, SubscribtionStatus>)new Pair((Object)((RentsoftProduct)rentsoftProductManager.get(ss.getProductId())), (Object)ss));
        }
        rentsoftProductManager.close();
        return result;
    }

    public void recalculate(int cid, Date date) throws BGException {
        RentsoftPaymentManager rentsoftPaymentManager = new RentsoftPaymentManager(this.getConnection(), this.moduleId);
        rentsoftPaymentManager.recalculateUser(cid, date);
        rentsoftPaymentManager.close();
    }

    public static String md5(String s) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(s.getBytes());
            byte[] digest = m.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            Object hash = bigInt.toString(16);
            while (((String)hash).length() < 32) {
                hash = "0" + (String)hash;
            }
            return hash;
        }
        catch (Exception ex) {
            return "md5_error";
        }
    }

    public String source(int contractId, String rsUri) throws BGException {
        try (RentsoftPaymentManager rpm = new RentsoftPaymentManager(this.getConnection(), this.moduleId);){
            String apikey = this.getModuleSetup().get("rentsoft.secret", "undefined");
            String agName = this.getModuleSetup().get("rentsoft.ag_name", "undefined-in-properties");
            String rsSrc = RentsoftServiceImpl.getIframeSource(rsUri, agName, rpm.cidToUuid(contractId), apikey);
            String string = RentsoftServiceImpl.json(rsSrc);
            return string;
        }
    }

    private static String json(String s) {
        StringBuffer sb = new StringBuffer("\"");
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch == '&' || ch == '<' || ch == '>' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static String getIframeSource(String rsUri, String agName, String agUuid, String agSecret) {
        if (rsUri == null) {
            rsUri = "";
        }
        if (rsUri.length() > 0 && rsUri.charAt(0) == '/') {
            rsUri = rsUri.substring(1);
        }
        String rsSignedParams = "ag_uuid=" + agUuid + "&ag_timestamp=" + String.valueOf(System.currentTimeMillis() / 1000L) + "&ag_rnd=" + String.valueOf((int)(Math.random() * 1000000.0));
        rsSignedParams = rsSignedParams + "&ag_sign=" + RentsoftServiceImpl.md5(agSecret + rsSignedParams);
        String rsResponseUri = "/2.01/iframe/" + rsUri + (rsUri.indexOf("?") >= 0 ? "&" : "?") + rsSignedParams;
        String rsSrc = "https://" + agName + ".ag.rentsoft.ru" + rsResponseUri;
        return rsSrc;
    }
}

