/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rbkmoney.server.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.rbkmoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.rbkmoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.rbkmoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.bean.TransactionUtils;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="RbkMoneyExecuter", urlPatterns={"/rbkmoney/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean error;
        response.setStatus(500);
        String orderId = request.getParameter("orderId");
        int paymentStatus = Utils.parseInt((String)request.getParameter("paymentStatus"));
        boolean bl = error = !this.logAndCheck(response, orderId, paymentStatus);
        if (error) {
            return;
        }
        int moduleId = 0;
        try {
            moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
        }
        catch (BGMessageException e) {
            logger.error((Object)e);
            return;
        }
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();
             TransactionManager transactionManager = new TransactionManager(con, moduleId);){
            Transaction transaction = (Transaction)transactionManager.get(Utils.parseInt((String)orderId));
            if (transaction == null) {
                logger.error("Not found transaction for ID = " + orderId);
                response.sendError(500, "Not found transaction for ID = " + orderId);
                return;
            }
            if (paymentStatus == 3 && transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                transaction.setStatus(TransactionStatus.ACCEPT.getCode());
            } else if (paymentStatus == 4) {
                transaction.setStatus(TransactionStatus.CANCEL.getCode());
            } else if (!(paymentStatus != 5 || transaction.getStatus().equals(TransactionStatus.APPROVED.getCode()) && transaction.getStatus().equals(TransactionStatus.APPROVED.getCode()))) {
                transaction.setCard(request.getParameter("cardNumber"));
                transaction.setStatus(TransactionStatus.APPROVED.getCode());
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                TransactionUtils.addPaymentWithCommissionInContract((Connection)con, (BGAbstractTransaction)transaction, (int)moduleSetup.getInt("rbkmoney.payment.type.id", moduleSetup.getInt("rbkmoney.payment.type", 0)), (String)moduleSetup.get("rbkmoney.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 RBK.Money [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())), (int)moduleSetup.getInt("rbkmoney.commission.type", 0), (int)moduleSetup.getInt("rbkmoney.commission.charge.type.id", 0), (BigDecimal)moduleSetup.getBigDecimal("rbkmoney.commission.percent", BigDecimal.ZERO), (String)moduleSetup.get("rbkmoney.commission.comment", moduleSetup.get("commission.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 RBK.Money ( \u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f ) [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]")).replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
            }
            transactionManager.update(transaction);
            response.setStatus(200);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            response.sendError(500, ex.getMessage());
        }
    }

    private boolean logAndCheck(HttpServletResponse response, String orderId, int paymentStatus) throws IOException {
        boolean error = true;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("doPost : orderId=" + orderId);
            sb.append(" | paymentStatus=" + paymentStatus);
            logger.debug(sb.toString());
        }
        if (orderId == null) {
            logger.error("orderId = null");
            response.sendError(500, "orderId = null");
            error = false;
        } else if (paymentStatus == 0) {
            logger.error("paymentStatus = 0");
            response.sendError(500, "paymentStatus = 0");
            error = false;
        }
        return error;
    }
}

