/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.pscb.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.pscb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.pscb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.pscb.server.bean.Constants;
import ru.bitel.bgbilling.modules.pscb.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u041f\u0421\u041a\u0411")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger log = LogManager.getLogger();
    private final String moduleName = "pscb";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm("pscb", Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"transactionDate:1"});
            transactionManager.searchTransactions((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("pscb.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("pscb.sum.max", new BigDecimal(5000));
        ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            String errorMessage = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!";
            this.setResultParam("errorMessage", errorMessage);
            this.execute();
            throw new BGMessageException(errorMessage);
        }
        try {
            Transaction pscbTransaction = new Transaction();
            pscbTransaction.setContractId(this.contractId);
            pscbTransaction.setStatus(TransactionStatus.NEW.getCode());
            pscbTransaction.setSum(sum);
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            transactionManager.update(pscbTransaction);
            transactionManager.close();
            if (log.isDebugEnabled()) {
                log.debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436 pscb \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. \u041a\u043e\u0434 " + pscbTransaction.getId());
            }
            Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
            if (log.isDebugEnabled()) {
                log.debug("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            }
            DecimalFormat orderIdFormat = new DecimalFormat(this.moduleSetup.get("pscb.order.id.format", "BG00000000"));
            HashMap<String, Object> messageParamMap = new HashMap<String, Object>();
            messageParamMap.put("nonce", Utils.randomAlphanumeric((int)10));
            messageParamMap.put("customerAccount", "cid_" + this.contractId);
            messageParamMap.put("custometRating", "5");
            messageParamMap.put("orderId", orderIdFormat.format(pscbTransaction.getId()));
            messageParamMap.put("showOrderId", orderIdFormat.format(pscbTransaction.getId()));
            messageParamMap.put("details", this.moduleSetup.get("pscb.details", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
            messageParamMap.put("amount", Utils.formatBigDecimalSumm((BigDecimal)sum));
            messageParamMap.put("successUrl", this.moduleSetup.get("pscb.success.url", ""));
            messageParamMap.put("failUrl", this.moduleSetup.get("pscb.fail.url", ""));
            ObjectMapper mapper = new ObjectMapper();
            String jsonParams = mapper.writeValueAsString(messageParamMap);
            if (log.isDebugEnabled()) {
                log.debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432 \u0432\u0438\u0434\u0435 json: \n" + jsonParams);
            }
            String sign = Utils.getDigest((String)(jsonParams + this.moduleSetup.get("pscb.secret.key", "")), (String)"UTF-8", (String)"SHA-256");
            String base64Message = Base64.encode((String)jsonParams, (String)"UTF-8");
            if (log.isDebugEnabled()) {
                log.debug("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0432 \u0432\u0438\u0434\u0435 base64: \n" + base64Message);
            }
            String serverUrl = this.moduleSetup.get("pscb.server.url", null);
            String merchantId = this.moduleSetup.get("pscb.merchant.id", null);
            if (log.isDebugEnabled()) {
                log.debug("Url \u0434\u043b\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441 pscb: " + serverUrl + "?marketPlace=" + merchantId + "&message=" + jsonParams + "&signature=" + sign);
            }
            this.setResultParam("message", base64Message);
            this.setResultParam("marketPlace", merchantId);
            this.setResultParam("signature", sign);
            this.setResultParam("url", serverUrl);
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }
}

