/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.psb.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.psb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.psb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.psb.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.psb.server.bean.Constants;
import ru.bitel.bgbilling.modules.psb.server.bean.TransactionManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u041f\u0421\u0411")
public class ActionDoTransaction
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private String moduleName = "psb";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("psb.gate.url", "https://3ds.payment.ru/cgi-bin/cgi_link"));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"transactionDatetime:1"});
            transactionManager.searchTransaction(searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws BGException {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO);
        if ((sum = sum.setScale(2, RoundingMode.HALF_EVEN)).compareTo(BigDecimal.ZERO) == 1) {
            String[][] KEYS;
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            Transaction transaction = transactionManager.newTransaction(this.contractId, sum, false, false);
            transactionManager.close();
            this.setDataMapValues(transaction, this.moduleSetup.get("psb.email"), false, null);
            for (String[] paramName : KEYS = new String[][]{{"MERCH_NAME", "psb.merchant.name"}, {"MERCHANT", "psb.merchant"}, {"TERMINAL", "psb.terminal"}, {"EMAIL", "psb.email"}, {"BACKREF", "psb.back.url"}}) {
                if (this.getResultParam(paramName[0]) != null) continue;
                logger.error("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"" + paramName[1] + "\"");
            }
            String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS);
            this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            if (logger.isDebugEnabled()) {
                StringBuilder params = new StringBuilder();
                for (String name : Constants.PARAMS) {
                    params.append(name).append(" = ").append(this.getResultParam(name)).append("\n");
                }
                logger.debug("TRANSACTION DATA:\n" + params.toString());
            }
        } else {
            this.execute();
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("psb.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
            }
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                int autopaymentWeekDay = this.moduleSetup.getInt("psb.autopayment.mode.week.day.default", 1);
                modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
                BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal("psb.autopayment.mode.week.sum.default", new BigDecimal(50));
                autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
                modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
                autopayment.setSum(autopaymentWeekSum);
                autopayment.setMode(AutopaymentMode.WEEK);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopaymentWeekSum, false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, "7");
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                int autopaymentMonthDay = this.moduleSetup.getInt("psb.autopayment.mode.month.day.default", 1);
                modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
                BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal("psb.autopayment.mode.month.sum.default", new BigDecimal(50));
                autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
                modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
                autopayment.setSum(autopaymentMonthSum);
                autopayment.setMode(AutopaymentMode.MONTH);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopaymentMonthSum, false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, "28");
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal("psb.autopayment.mode.auto.day.sum.default", new BigDecimal(500));
                autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
                modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
                BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal("psb.autopayment.mode.auto.week.sum.default", new BigDecimal(1000));
                autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
                modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
                BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal("psb.autopayment.mode.auto.month.sum.default", new BigDecimal(3000));
                autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
                modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
                autopayment.setSum(autopaymentAutoMaxDaySum);
                autopayment.setMode(AutopaymentMode.AUTO);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopaymentAutoMaxDaySum, false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, this.moduleSetup.get("psb.recur.freq", "1"));
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
            transactionManager.close();
        }
    }

    private void setDataMapValues(Transaction transaction, String email, boolean addChainParameter, String recurFreq) {
        this.setResultParam("AMOUNT", TransactionManager.getFormatSum(transaction.getSum()));
        this.setResultParam("CURRENCY", "RUB");
        this.setResultParam("ORDER", new DecimalFormat("000000").format(transaction.getId()));
        this.setResultParam("MERCH_NAME", this.moduleSetup.get("psb.merchant.name"));
        this.setResultParam("MERCHANT", this.moduleSetup.get("psb.merchant"));
        this.setResultParam("TERMINAL", this.moduleSetup.get("psb.terminal"));
        this.setResultParam("EMAIL", email);
        this.setResultParam("TRTYPE", "1");
        this.setResultParam("TIMESTAMP", TransactionManager.getFormatTime(transaction.getCreateDate()));
        this.setResultParam("NONCE", TransactionManager.getNonce());
        this.setResultParam("BACKREF", this.moduleSetup.get("psb.back.url"));
        String psbNotifyUrl = this.moduleSetup.get("psb.notify.url");
        if (Utils.notBlankString((String)psbNotifyUrl)) {
            this.setResultParam("NOTIFY_URL", psbNotifyUrl);
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        this.setResultParam("DESC", this.moduleSetup.get("psb.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
        if (addChainParameter) {
            this.setResultParam("RECUR_FREQ", recurFreq);
            String value = this.moduleSetup.get("psb.recur.exp", null);
            if (value == null || value.startsWith("d")) {
                int offcet = 500;
                if (value != null) {
                    offcet = Utils.parseInt((String)value.substring(1), (int)500);
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(5, offcet);
                SimpleDateFormat dateFormat = new SimpleDateFormat("YYYYMMdd");
                value = dateFormat.format(cal);
            }
            this.setResultParam("RECUR_EXP", value);
        }
    }
}

