/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.omega.server.bean;

import java.sql.Connection;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.omega.common.bean.Device;
import ru.bitel.bgbilling.modules.omega.server.bean.OmegaDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class OmegaManager {
    private static final Logger log = LogManager.getLogger();
    private Connection con = null;
    private int moduleId = 0;

    public OmegaManager(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
    }

    public String getHash(Contract contract, String key) throws BGException {
        Device device = null;
        try (OmegaDao omegaDao = new OmegaDao(this.con, this.moduleId);){
            device = omegaDao.getDevice(contract.getId(), key);
            if (!TimeUtils.dateInPeriod((Date)new Date(), (Period)device.getPeriod())) {
                device = null;
            }
        }
        omegaDao = new OmegaDao(this.con, this.moduleId);
        try {
            if (device == null) {
                device = new Device();
                device.setContractId(contract.getId());
                device.setKey(key);
                device.setPeriod(new Period(new Date(), null));
                try {
                    while (true) {
                        device.setHash(Utils.getDigest((String)Utils.randomAlphanumeric((int)32), (String)"UTF-8").toLowerCase());
                        omegaDao.update(device);
                    }
                }
                catch (BGException e) {
                    // empty catch block
                }
            }
        }
        finally {
            omegaDao.close();
        }
        return device.getHash();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Contract getContract(String hash) {
        try (OmegaDao omegaDao = new OmegaDao(this.con, this.moduleId);){
            Contract contract;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                int contractId = omegaDao.getContractId(hash);
                contract = contractId > 0 ? (Contract)contractDao.get(contractId) : null;
            }
            return contract;
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    public int getStatusCredit(Contract contract) {
        return 1;
    }

    public String setCredit(Contract contract, int days) {
        return null;
    }

    public String changeTarif(Contract contract, String proceeddate, String newTarif) {
        return null;
    }

    public JSONArray getActiveTariff(Contract contract) {
        return new JSONArray();
    }

    public JSONObject getInetStatus(Contract contract) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", 0);
        return jsonObject;
    }

    public JSONArray getActiveServices(Contract contract) {
        return new JSONArray();
    }

    public int deactivateService(Contract contract, String serviceId) {
        return 0;
    }

    public JSONArray getServicesAvailableToActivate(Contract contract) {
        return new JSONArray();
    }

    public int createNewService(Contract contract, String serviceTypeId) {
        return 0;
    }
}

