/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.npay.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSetManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionClearAccount
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Period period = this.getPeriod();
        Date date = this.getDateParameter("date");
        if (date != null) {
            period.setDateFrom(date);
            period.setDateTo(date);
        }
        List contractIds = Utils.toIntegerList((String)this.getParameter("cids"));
        List contractLabelIds = Utils.toIntegerList((String)this.getParameter("contractGroups"));
        int serviceSet = this.getIntParameter("service_set", 0);
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Calendar cal = period.getDateFrom() != null ? period.getDateFromCalendar() : new GregorianCalendar();
        cal.set(5, 1);
        period.setDateFrom(cal.getTime());
        cal = period.getDateFrom() != null ? period.getDateToCalendar() : new GregorianCalendar();
        cal.set(5, cal.getActualMaximum(5));
        period.setDateTo(cal.getTime());
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionClearAccount", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            try {
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)period.getDateFrom());
            }
            catch (BGMessageException ex) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043e\u0447\u0438\u0449\u0430\u0442\u044c \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0443 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435");
            }
        }
        String sidList = new ServiceSetManager(this.con, this.mid, (Preferences)this.moduleSetup).getServiceSetMap().get(serviceSet).getSidList();
        String selectQuery = "SELECT DISTINCT account.cid FROM contract_account AS account WHERE account.sid IN ( " + sidList + " ) AND account.yy=? AND account.mm=?";
        if (!contractIds.isEmpty()) {
            selectQuery = selectQuery + " AND account.cid IN (" + Utils.toString((Iterable)contractIds) + ")";
        }
        if (!contractLabelIds.isEmpty()) {
            selectQuery = selectQuery + " AND account.cid IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString((Iterable)contractLabelIds) + " ))";
        }
        String deleteQuery = "DELETE contract_account FROM contract_account WHERE sid IN ( " + sidList + " ) AND yy=? AND mm=?";
        if (!contractIds.isEmpty()) {
            deleteQuery = deleteQuery + " AND cid IN ( " + Utils.toString((Iterable)contractIds) + " )";
        }
        if (!contractLabelIds.isEmpty()) {
            deleteQuery = deleteQuery + " AND cid IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString((Iterable)contractLabelIds) + " ))";
        }
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);
             PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);
             BalanceUtils bu = new BalanceUtils(this.con);){
            cal = period.getDateFromCalendar();
            while (cal.getTime().before(period.getDateTo())) {
                int yy = cal.get(1);
                int mm = cal.get(2) + 1;
                HashSet<Integer> contracts = new HashSet<Integer>();
                psSelect.setInt(1, yy);
                psSelect.setInt(2, mm);
                ResultSet rs = psSelect.executeQuery();
                while (rs.next()) {
                    contracts.add(rs.getInt(1));
                }
                rs.close();
                psDelete.setInt(1, yy);
                psDelete.setInt(2, mm);
                psDelete.executeUpdate();
                for (Integer cid : contracts) {
                    bu.setBalanceFromAccount(cid.intValue(), cal);
                }
                cal.add(2, 1);
            }
        }
    }
}

