/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice;

import java.io.File;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import ru.bitel.bgbilling.kernel.util.net.ssl.PEMCertificate;
import ru.bitel.bgbilling.server.util.ModuleSetup;

public class MobiMoneySSLSocketFactory {
    public static SSLSocketFactory getSocketFactory(ModuleSetup moduleSetup) {
        SSLSocketFactory sslSocketFactory = null;
        try {
            File fileCaCrt = new File(moduleSetup.get("mobimoney.path.ca.crt", "cert/mobimoney/ca.crt"));
            File fileCertCrt = new File(moduleSetup.get("mobimoney.path.cert.crt", "cert/mobimoney/cert.crt"));
            File fileCertKey = new File(moduleSetup.get("mobimoney.path.cert.key", "cert/mobimoney/cert.key"));
            if (fileCaCrt.exists() && fileCertCrt.exists() && fileCertKey.exists()) {
                Certificate[] chain = new X509Certificate[]{PEMCertificate.getPemCertificate((File)fileCertCrt), PEMCertificate.getPemCertificate((File)fileCaCrt)};
                String keyPassword = moduleSetup.get("mobimoney.key.password", "");
                String keyStorePassword = moduleSetup.get("mobimoney.key.store.password", "");
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(null, keyStorePassword.toCharArray());
                keyStore.setKeyEntry("key", PEMCertificate.getPemPrivateKey((File)fileCertKey), keyPassword.toCharArray(), chain);
                String trustStorePassword = moduleSetup.get("mobimoney.trust.store.password", "");
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(null, trustStorePassword.toCharArray());
                trustStore.setCertificateEntry("ca", chain[1]);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                tmf.init(trustStore);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagerFactory.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
                sslSocketFactory = sslContext.getSocketFactory();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sslSocketFactory;
    }
}

