/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.action.apps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.modules.mobile.server.bean.AbstractAction;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.MapHolder;

public class ActionStatus
extends AbstractAction {
    private ContractStatusService statusService = (ContractStatusService)ServiceFactory.newService(ContractStatusService.class, (int)0);

    public void execute() throws BGException {
        ContractStatusService.ContractStatusChangeParameters changeParameters = this.statusService.contractStatusChangeParametersGet(this.contractId);
        List statusList = this.statusService.contractStatusList(this.contractId, null);
        this.sortListById(statusList, false);
        Date now = new Date();
        ArrayList<ContractStatus> statusListOngoing = new ArrayList<ContractStatus>();
        ArrayList<ContractStatus> statusListHistory = new ArrayList<ContractStatus>();
        for (int i = 0; i < statusList.size(); ++i) {
            ContractStatus status = (ContractStatus)statusList.get(i);
            if (TimeUtils.dateBeforeOrEq((Date)now, (Date)status.getDateFrom()) || status.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)now, (Date)status.getDateTo())) {
                statusListOngoing.add(status);
                continue;
            }
            statusListHistory.add(status);
        }
        this.actionMap.put("changeParameters", changeParameters);
        this.actionMap.put("comingStatuses", statusListOngoing);
        this.actionMap.put("passedStatuses", statusListHistory);
        this.actionMap.put("contractStatus", this.contract.getStatus());
    }

    public void changeStatus() throws BGException {
        ContractStatus contractStatus = this.statusFromRequest();
        boolean changeStatusNeedConfirm = false;
        MapHolder answer = this.statusService.contractStatusChange(this.contractId, contractStatus, true, changeStatusNeedConfirm);
        String changeStatusMessage = (String)answer.getMap().get("message");
        String result = (String)answer.getMap().get("result");
        if (result != null && result.equals("confirm")) {
            changeStatusNeedConfirm = true;
        }
        if (Utils.notBlankString((String)changeStatusMessage)) {
            this.actionMap.put("message", changeStatusMessage);
        }
        this.actionMap.put("changeStatusNeedConfirm", changeStatusNeedConfirm);
    }

    public void confirmChangeStatus() throws BGException {
        ContractStatus contractStatus = this.statusFromRequest();
        MapHolder answer = this.statusService.contractStatusChange(this.contractId, contractStatus, true, true);
        String changeStatusMessage = (String)answer.getMap().get("message");
        if (Utils.notBlankString((String)changeStatusMessage)) {
            this.actionMap.put("message", changeStatusMessage);
        }
    }

    private ContractStatus statusFromRequest() throws BGException {
        boolean cancel = this.req.getBoolean("cancel", false);
        int status = this.req.getInt("status", -1);
        Date date = cancel ? new Date() : this.getDate("date", null);
        String comment = this.req.get("comment", "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u043c");
        if (status < 0) {
            throw new BGMessageException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
        }
        if (date == null) {
            throw new BGMessageException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0434\u0430\u0442\u0430");
        }
        ContractStatus contractStatus = new ContractStatus();
        contractStatus.setContractId(this.contractId);
        contractStatus.setStatus(status);
        contractStatus.setDateFrom(date);
        contractStatus.setDateTo(null);
        contractStatus.setComment(comment);
        return contractStatus;
    }

    private void sortListById(List<? extends Id> list, final boolean byAsc) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Comparator<Id> comparator = new Comparator<Id>(){

            @Override
            public int compare(Id o1, Id o2) {
                return byAsc ? o1.getId() - o2.getId() : o2.getId() - o1.getId();
            }
        };
        Collections.sort(list, comparator);
    }
}

