/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="LicenseExecutor", urlPatterns={"/license"})
public class LicenseExecutor
extends CommonExecutor {
    private int moduleId;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.moduleId = LicenseExecutor.getModuleId((HttpServletRequest)request);
            String action = request.getParameter("action");
            if (action != null) {
                String password;
                String name = request.getHeader("name");
                if (name == null) {
                    name = request.getParameter("name");
                }
                if ((password = request.getHeader("password")) == null) {
                    password = request.getParameter("password");
                }
                Connection con = this.setup.getDBConnection();
                ContractDao contractDao = new ContractDao(con, 0);
                Contract contract = contractDao.getByTitle(name);
                contractDao.close();
                if (contract != null && contract.getPassword().equals(password)) {
                    List<License> testLicenses;
                    List<Copy> testCopies;
                    int testContractId;
                    int copyId = Utils.parseInt((String)request.getHeader("copyId"), (int)0);
                    LicenseManager licenseManager = new LicenseManager(con, this.moduleId);
                    List<Copy> copies = licenseManager.getCopyList(contract.getId());
                    Copy copy = null;
                    if (copyId == 0 && copies.size() == 1) {
                        copyId = copies.get(0).getId();
                        copy = copies.get(0);
                    } else if (copyId > 0) {
                        boolean fl = false;
                        for (Copy copy2 : copies) {
                            if (copy2.getId() != copyId) continue;
                            fl = true;
                            copy = copy2;
                            break;
                        }
                        if (!fl) {
                            copyId = 0;
                        }
                    }
                    License testLicense = null;
                    if (copy != null && (testContractId = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getInt("license.test.contract." + copy.getProductId() + ".id", 0)) > 0 && (testCopies = licenseManager.getCopyList(testContractId)).size() == 1 && !(testLicenses = licenseManager.getLicenses(testCopies.get(0).getId())).isEmpty()) {
                        testLicense = testLicenses.get(0);
                    }
                    response.setContentType("text/plain; charset=utf-8");
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), "utf-8");
                    if ("list".equals(action)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                        List<License> licenses = licenseManager.getLicenses(copyId);
                        if (licenses.size() > 0) {
                            for (License license : licenses) {
                                writer.write(String.format("%d\t%s\t%s\t%d\n", license.getId(), dateFormat.format(license.getCreateDate()), Utils.getDigest((String)license.getData(), (String)"UTF-8", (String)"SHA-256"), license.getOriginalData().split("\n").length - 2));
                            }
                        }
                        if (testLicense != null) {
                            writer.write(String.format("%d\t%s\t%s\t%d\n", testLicense.getId(), dateFormat.format(testLicense.getCreateDate()), Utils.getDigest((String)testLicense.getData(), (String)"UTF-8", (String)"SHA-256"), testLicense.getOriginalData().split("\n").length - 2));
                        }
                        ((Writer)writer).close();
                    } else if ("licenseText".equals(action)) {
                        int licenseId = Utils.parseInt((String)request.getHeader("licenseId"), (int)0);
                        License license = licenseManager.getLicenseById(licenseId);
                        if (license.getCopyId() == copyId) {
                            JSONObject licenseJson = new JSONObject();
                            JSONArray licenseItemsJson = new JSONArray();
                            for (String text : license.getOriginalData().split("\n")) {
                                String[] tokens;
                                if (text.startsWith("licence.")) {
                                    tokens = text.split("_");
                                    JSONObject licenseItemJson = new JSONObject();
                                    licenseItemJson.put("pos", (Object)tokens[2]);
                                    licenseItemJson.put("name", (Object)tokens[4]);
                                    licenseItemJson.put("count", (Object)tokens[5]);
                                    licenseItemJson.put("date", (Object)tokens[6]);
                                    licenseItemsJson.put((Object)licenseItemJson);
                                    continue;
                                }
                                if (!text.startsWith("lic.kernel=bgbilling_kernel_")) continue;
                                tokens = text.split("_");
                                licenseJson.put("id", (Object)tokens[2]);
                                licenseJson.put("ver", (Object)tokens[3]);
                                licenseJson.put("name", (Object)(tokens.length > 4 ? tokens[4] : ""));
                            }
                            licenseJson.put("date", license.getCreateDate().getTime());
                            licenseJson.put("encrypt", (Object)Base64.getEncoder().encodeToString(license.getData().getBytes("UTF-8")));
                            licenseJson.put("license", (Object)licenseItemsJson);
                            writer.write(licenseJson.toString());
                        }
                        ((Writer)writer).close();
                    }
                } else {
                    String message = "Contract not found or password error";
                    response.setHeader("ErrorMessage", message);
                    response.sendError(400, message);
                }
            } else {
                String message = "Parameter \"action\" not found";
                response.setHeader("ErrorMessage", message);
                response.sendError(400, message);
            }
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }
}

