/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.ws.Holder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.license.common.LicenseUtils;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.Component;
import ru.bitel.bgbilling.modules.license.common.bean.ComponentCategory;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.common.bean.Product;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

public class LicenseManager {
    protected static final String SQL_SELECT = "SELECT ";
    protected static final String SQL_INSERT = "INSERT INTO ";
    protected static final String SQL_UPDATE = "UPDATE ";
    protected static final String SQL_DELETE = "DELETE ";
    protected static final String SQL_FROM = " FROM ";
    protected static final String SQL_ALL = " * ";
    protected static final String SQL_WHERE = " WHERE ";
    protected static final String SQL_ORDER_BY = " ORDER BY ";
    protected static final String SQL_LEFT_JOIN = " LEFT JOIN ";
    protected static final String SQL_JOIN = " JOIN ";
    protected static final String SQL_GROUP_BY = " GROUP BY ";
    protected static final String SQL_SET = " SET ";
    protected static final String SQL_AND = " AND ";
    protected static final String SQL_IN = " IN ";
    protected static final String SQL_NOT_IN = " NOT IN ";
    protected static final String SQL_DISTINCT = "DISTINCT ";
    protected static final String SQL_ON = " ON ";
    protected Logger log = null;
    protected Connection con = null;
    protected String mid;
    protected int moduleId;

    public LicenseManager(Connection con, int moduleId) {
        this.con = con;
        this.mid = String.valueOf(moduleId) + " ";
        this.moduleId = moduleId;
        this.log = LogManager.getLogger();
    }

    public void updateProduct(Product product) {
        if (product != null) {
            try {
                int index = 1;
                StringBuilder query = new StringBuilder();
                PreparedStatement ps = null;
                if (product.getId() > 0) {
                    query.append(SQL_UPDATE);
                    query.append(" lic_product_" + this.mid);
                    query.append(" SET title=?, version=?");
                    query.append(" WHERE id=? ");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setString(index++, product.getTitle());
                    ps.setString(index++, product.getVersion());
                    ps.setInt(index++, product.getId());
                    ps.executeUpdate();
                } else {
                    query.append(SQL_INSERT);
                    query.append(" lic_product_" + this.mid);
                    query.append(" SET title=?, version=?");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    ps.setString(index++, product.getTitle());
                    ps.setString(index++, product.getVersion());
                    ps.executeUpdate();
                    product.setId(this.lastInsertId(ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                this.log.error("updateProduct( " + product + " )", (Throwable)ex);
            }
        }
    }

    public void deleteProduct(int pid) {
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append(" lic_product_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(1, pid);
            int affectedRows = ps.executeUpdate();
            ps.close();
            if (affectedRows > 0) {
                query = new StringBuilder();
                query.append(SQL_DELETE);
                query.append(SQL_FROM);
                query.append(" lic_product_component_" + this.mid);
                query.append(SQL_WHERE);
                query.append(" product_id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, pid);
                ps.executeUpdate();
            }
        }
        catch (SQLException ex) {
            this.log.error("deleteProduct( " + pid + " )", (Throwable)ex);
        }
    }

    public Product getProduct(int pid) {
        Product product = null;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(SQL_ALL);
            query.append(SQL_FROM);
            query.append(" lic_product_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                product = this.getProductFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getProduct( " + pid + " )", (Throwable)ex);
        }
        return product;
    }

    public int getOrdersCountOnProduct(int productId) {
        int copiesCount = 0;
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" COUNT(*)");
            query.append(SQL_FROM);
            query.append(" lic_copy_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" product_id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                copiesCount = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error(" getOrdersCountOnProduct( " + productId + " ) ", (Throwable)e);
        }
        return copiesCount;
    }

    public List<Product> getProductsWithComponent(int componentId) throws BGException {
        ArrayList<Product> products = new ArrayList<Product>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" id, title, version, lu ");
            query.append(SQL_FROM);
            query.append(" lic_product_" + this.mid + " t1 ");
            query.append(SQL_JOIN);
            query.append(" lic_product_component_" + this.mid + " t2 ");
            query.append(" ON t1.id=t2.product_id ");
            query.append(SQL_WHERE);
            query.append("t2.component_id=?");
            query.append(SQL_ORDER_BY);
            query.append(" title ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, componentId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                products.add(this.getProductFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return products;
    }

    public void updateComponent(Component component) throws BGException {
        if (component != null) {
            boolean update = component.getId() > 0;
            String query = (update ? SQL_UPDATE : SQL_INSERT) + " lic_component_" + this.mid + " SET name=?, title=?, category_id=?, comment=?, type=?, unlimited=?, available_on_web=?" + (update ? " WHERE id=?" : "");
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 1;
                ps.setString(index++, component.getName());
                ps.setString(index++, component.getTitle());
                ps.setInt(index++, component.getCategory().getCode());
                ps.setString(index++, component.getComment());
                ps.setInt(index++, component.getType());
                ps.setInt(index++, component.getUnlimited());
                ps.setBoolean(index++, component.isAvailableOnWeb());
                if (update) {
                    ps.setInt(index++, component.getId());
                }
                ps.executeUpdate();
                if (!update) {
                    component.setId(this.lastInsertId(ps));
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void deleteComponent(int id) {
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_DELETE).append(SQL_FROM).append(" lic_component_" + this.mid).append(SQL_WHERE).append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            int affectedRows = ps.executeUpdate();
            ps.close();
            if (affectedRows > 0) {
                query = new StringBuilder();
                query.append(SQL_DELETE);
                query.append(SQL_FROM);
                query.append(" lic_product_component_" + this.mid);
                query.append(SQL_WHERE);
                query.append(" component_id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, id);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            this.log.error("deleteProductItem( " + id + " )", (Throwable)ex);
        }
    }

    public void deleteComponents(int productId) {
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append(" lic_component_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" product_id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("deleteProductItems( " + productId + " )", (Throwable)ex);
        }
    }

    public Component getComponent(int id) {
        Component productItem = null;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(SQL_ALL);
            query.append(SQL_FROM);
            query.append(" lic_component_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                productItem = this.getProductItemFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getProductItem( " + id + " )", (Throwable)ex);
        }
        return productItem;
    }

    public Component getComponent(String name) {
        Component productItem = null;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(SQL_ALL);
            query.append(SQL_FROM);
            query.append(" lic_component_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" name=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                productItem = this.getProductItemFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getProductItem( " + name + " )", (Throwable)ex);
        }
        return productItem;
    }

    public List<Component> getComponentList() {
        ArrayList<Component> productItems = new ArrayList<Component>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT).append("*");
            query.append(SQL_FROM).append(" lic_component_" + this.mid);
            query.append(SQL_ORDER_BY).append(" title ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Component item = this.getProductItemFromRs(rs);
                productItems.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("getProductItemList()", (Throwable)e);
        }
        return productItems;
    }

    public List<Component> getComponentList(int copyId, boolean showHidden, Boolean availableOnWeb) {
        ArrayList<Component> productItems = new ArrayList<Component>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("pi.* ");
            query.append(SQL_FROM);
            query.append(" lic_component_" + this.mid + " as pi ");
            query.append(SQL_JOIN);
            query.append(" lic_product_component_" + this.mid + " as pip ");
            query.append(" ON pip.component_id=pi.id ");
            query.append(SQL_JOIN);
            query.append(" lic_copy_" + this.mid + " as tc ");
            query.append(" ON tc.product_id=pip.product_id ");
            query.append(SQL_WHERE);
            query.append(" tc.id=? ");
            if (!showHidden) {
                query.append(" AND pi.type=0 ");
            }
            if (availableOnWeb != null) {
                query.append(" AND pi.available_on_web=").append(availableOnWeb);
            }
            query.append(SQL_ORDER_BY);
            query.append(" pi.title ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Component item = this.getProductItemFromRs(rs);
                productItems.add(item);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("getProductItemList( " + copyId + " )", (Throwable)e);
        }
        return productItems;
    }

    public int getOrdersCountOnComponent(int componentId) {
        int ordersCount = 0;
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" COUNT(*)");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" component_id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, componentId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ordersCount = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error(" getOrdersCountOnProductItem( " + componentId + " ) ", (Throwable)e);
        }
        return ordersCount;
    }

    public List<Component> getComponentsForProduct(int productId) {
        ArrayList<Component> productItems = new ArrayList<Component>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" item.* ");
            query.append(SQL_FROM);
            query.append(" lic_component_" + this.mid + " as item ");
            query.append(SQL_JOIN);
            query.append(" lic_product_component_" + this.mid + " link ");
            query.append(" ON item.id=link.component_id ");
            query.append(SQL_WHERE);
            query.append("link.product_id=?");
            query.append(SQL_ORDER_BY);
            query.append(" title ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                productItems.add(this.getProductItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("getProductItemsForProduct( " + productId + " )", (Throwable)e);
        }
        return productItems;
    }

    public void linkComponentToProduct(int productId, int componentId) {
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_INSERT);
            query.append(" lic_product_component_" + this.mid);
            query.append(" SET product_id=?, component_id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.setInt(2, componentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("linkProductItemToProduct( " + productId + ", " + componentId + " )", (Throwable)e);
        }
    }

    public void unlinkComponentFromProduct(int productId, int componentId) {
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append(" lic_product_component_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" product_id=? AND component_id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.setInt(2, componentId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("unlinkProductItemFromProduct( " + productId + ", " + componentId + " )", (Throwable)e);
        }
    }

    public void updateCopy(Copy copy) {
        if (copy != null) {
            try {
                int index = 1;
                StringBuilder query = new StringBuilder();
                PreparedStatement ps = null;
                if (copy.getId() > 0) {
                    query.append(SQL_UPDATE);
                    query.append(" lic_copy_" + this.mid);
                    query.append(" SET contract_id=?, product_id=?, licensee_name=?, comment=?");
                    query.append(" WHERE id=? AND (contract_id<>? OR product_id<>? OR licensee_name<>? OR comment<>?)");
                    ps = this.con.prepareStatement(query.toString());
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseeName());
                    ps.setString(index++, copy.getComment());
                    ps.setInt(index++, copy.getId());
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseeName());
                    ps.setString(index++, copy.getComment());
                    ps.executeUpdate();
                    ps.close();
                } else {
                    query.append(SQL_INSERT);
                    query.append(" lic_copy_" + this.mid);
                    query.append(" SET contract_id=?, product_id=?, licensee_name=?, comment=?, dt=now()");
                    ps = this.con.prepareStatement(query.toString(), 1);
                    ps.setInt(index++, copy.getContractId());
                    ps.setInt(index++, copy.getProductId());
                    ps.setString(index++, copy.getLicenseeName());
                    ps.setString(index++, copy.getComment());
                    ps.executeUpdate();
                    copy.setId(this.lastInsertId(ps));
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.log.error("updateCopy( " + copy + ")", (Throwable)e);
            }
        }
    }

    public Copy getCopy(int copyId) {
        Copy copy = null;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" tc.id, tc.contract_id, tc.product_id, tc.dt, tc.licensee_name, tc.comment, tc.lu, tp.title, tp.version ");
            query.append(SQL_FROM);
            query.append(" lic_copy_" + this.mid + " as tc ");
            query.append(SQL_JOIN);
            query.append(" lic_product_" + this.mid + " as tp ");
            query.append(" ON tc.product_id=tp.id ");
            query.append(SQL_WHERE);
            query.append(" tc.id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                copy = this.getCopyFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getCopy( " + copyId + " )", (Throwable)ex);
        }
        return copy;
    }

    public void updateCopyItem(ConfirmedOrder copyItem) {
        if (copyItem == null) {
            return;
        }
        try {
            int index = 1;
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            if (copyItem.getId() > 0) {
                query.append(SQL_UPDATE);
                query.append(" lic_confirmed_order_" + this.mid);
                query.append(" SET to_date=?");
                query.append(" WHERE id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setTimestamp(index++, new Timestamp(copyItem.getDateTo().getTime()));
                ps.setInt(index++, copyItem.getId());
                ps.executeUpdate();
            } else {
                query.append(SQL_INSERT);
                query.append(" lic_confirmed_order_" + this.mid);
                query.append(" SET order_id=?, to_date=? ");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, copyItem.getOrderId());
                ps.setTimestamp(index++, new Timestamp(copyItem.getDateTo().getTime()));
                ps.executeUpdate();
                copyItem.setId(this.lastInsertId(ps));
            }
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("updateCopyItem( " + copyItem + " )", (Throwable)ex);
        }
    }

    public void updateCopyItemOrder(Order order) throws BGMessageException {
        this.updateCopyItemOrder(order, true);
    }

    public void updateCopyItemOrder(Order order, boolean updateConfirmed) throws BGMessageException {
        if (order != null) {
            try {
                this.updateOrder(order);
                if (updateConfirmed) {
                    int confirmedId = this.getConfirmedId(order.getId());
                    if (order.getStatus() == 3 || order.getStatus() == 2) {
                        ConfirmedOrder confirmed = new ConfirmedOrder();
                        confirmed.setId(confirmedId);
                        confirmed.setOrderId(order.getId());
                        confirmed.setDateTo(this.convertToLicenseDate(null, order));
                        this.updateCopyItem(confirmed);
                    }
                }
            }
            catch (SQLException ex) {
                this.log.error("updateCopyItemOrder( " + order + " )", (Throwable)ex);
            }
        }
    }

    public void updateCopyItemOrder(Order order, Date copyItemToDate) throws BGMessageException {
        if (order == null) {
            return;
        }
        try {
            this.updateOrder(order);
            int confirmedId = this.getConfirmedId(order.getId());
            if (order.getStatus() == 3 || order.getStatus() == 2) {
                ConfirmedOrder confirmed = new ConfirmedOrder();
                confirmed.setId(confirmedId);
                confirmed.setOrderId(order.getId());
                confirmed.setDateTo(this.convertToLicenseDate(copyItemToDate, order));
                this.updateCopyItem(confirmed);
            } else {
                this.setOrderUnconfirmed(order);
            }
        }
        catch (SQLException ex) {
            this.log.error("updateCopyItemOrder( " + order + " )", (Throwable)ex);
        }
    }

    private void updateOrder(Order order) throws SQLException, BGMessageException {
        StringBuilder query = new StringBuilder();
        PreparedStatement ps = null;
        int index = 1;
        try {
            if (order.getType() == OrderType.BUY && order.getCount() != 0) {
                List<Order> list = this.getOrders(order.getCopyId(), order.getType(), 0, order.getComponentId());
                list.addAll(this.getOrders(order.getCopyId(), order.getType(), 2, order.getComponentId()));
                int allCount = order.getCount();
                for (Order ord : list) {
                    if (order.getId() != 0 && (order.getId() <= 0 || ord.getId() == order.getId())) continue;
                    allCount += ord.getCount();
                }
                String ver = this.getCopy(order.getCopyId()).getProductVersion();
                String compName = this.getComponent(order.getComponentId()).getName();
                String costUrl = LicenseUtils.buildLicenseCostUrlRequest((String)compName, (Integer)1, (String)ver, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(Utils.parseInt((String)this.mid.trim()))));
                Holder holderUnlimCount = new Holder((Object)-1);
                LicenseUtils.getCost((String)costUrl, (Holder)holderUnlimCount);
                if ((Integer)holderUnlimCount.value > 0 && allCount > (Integer)holderUnlimCount.value) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430!!! \u041e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439 \u0434\u043b\u044f " + compName + " \u0440\u0430\u0432\u043d\u043e " + allCount + ", \u0447\u0442\u043e \u0431\u043e\u043b\u044c\u0448\u0435 " + holderUnlimCount.value + ", \u043d\u0443\u0436\u043d\u043e \u0437\u0430\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e!");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BGMessageException) {
                throw e;
            }
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (order.getId() > 0) {
            query.append(SQL_UPDATE);
            query.append(" lic_order_" + this.mid);
            query.append(" SET copy_id=?, component_id=?, user_id=?, type=?, term=?, count=?, status=?, lu=now() ");
            query.append(" WHERE id=? AND ( copy_id<>? OR component_id<>? OR user_id<>? OR type<>? OR term<>? OR count<>? OR status<>? )");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.setInt(index++, order.getId());
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.executeUpdate();
        } else {
            query.append(SQL_INSERT);
            query.append(" lic_order_" + this.mid);
            query.append(" SET copy_id=?, component_id=?, user_id=?, type=?, term=?, count=?, status=?, create_date=now() ");
            ps = this.con.prepareStatement(query.toString(), 1);
            ps.setInt(index++, order.getCopyId());
            ps.setInt(index++, order.getComponentId());
            ps.setInt(index++, order.getUserId());
            ps.setInt(index++, order.getType().getCode());
            ps.setInt(index++, order.getTerm());
            ps.setInt(index++, order.getCount());
            ps.setInt(index++, order.getStatus());
            ps.executeUpdate();
            order.setId(this.lastInsertId(ps));
        }
    }

    private Date convertToLicenseDate(Date date, Order order) {
        if (date != null) {
            return date;
        }
        if (date == null) {
            if (order.getType() == OrderType.TEST) {
                Date today = new Date();
                long time = today.getTime();
                date = new Date(time += 86400000L * (long)order.getTerm());
            } else if (order.getType() == OrderType.BUY) {
                date = new GregorianCalendar(2050, 11, 30).getTime();
            }
        }
        return date;
    }

    private void setOrderUnconfirmed(Order order) {
        if (order == null) {
            return;
        }
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append(" lic_confirmed_order_");
            query.append(SQL_WHERE);
            query.append(" order_id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, order.getId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("deleteCopyItemForOrder( " + order + " )", (Throwable)e);
        }
    }

    private int getConfirmedId(int orderId) {
        if (orderId < 0) {
            return -1;
        }
        int res = -1;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" id, order_id ");
            query.append(SQL_FROM);
            query.append(" lic_confirmed_order_" + this.mid + " as orders ");
            query.append(SQL_WHERE);
            query.append(" order_id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, orderId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                res = rs.getInt("id");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("isOrderConfirmed( " + orderId + " )", (Throwable)ex);
        }
        return res;
    }

    public int getOrderStatus(int id) {
        int status = 0;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" status ");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                status = rs.getInt("status");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getOrderStatus( " + id + " )", (Throwable)ex);
        }
        return status;
    }

    public int getOrderType(int id) {
        int type = 0;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" type ");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                type = rs.getInt("type");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getOrderType( " + id + " )", (Throwable)ex);
        }
        return type;
    }

    public List<Order> getOrders(int copyId, OrderType filterType, int filterStatus, int filterComponentItemId) {
        ArrayList<Order> orders = new ArrayList<Order>();
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, productItems.title as product_item_title, productItems.name as product_item_name, users.name as user_name");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid + " as orders ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as productItems ");
            query.append(" ON orders.component_id=productItems.id");
            query.append(SQL_LEFT_JOIN);
            query.append(" user as users ");
            query.append(" ON orders.user_id=users.id");
            query.append(SQL_WHERE);
            query.append(" orders.copy_id=? ");
            if (filterType.getCode() >= 0) {
                query.append(" AND orders.type=" + filterType.getCode());
            }
            if (filterStatus == 0 || filterStatus == 1) {
                query.append(" AND orders.status=" + filterStatus);
            } else if (filterStatus == 2) {
                query.append(" AND (orders.status=2 OR orders.status=3) ");
            }
            if (filterComponentItemId >= 0) {
                query.append(" AND orders.component_id=" + filterComponentItemId);
            }
            query.append(" ORDER BY orders.create_date DESC, product_item_title");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                orders.add(this.getOrderFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getCopyItemOrders( " + copyId + " )", (Throwable)ex);
        }
        return orders;
    }

    public List<Order> getOrders(int copyId, String filterPermanentStatus, String filterTestStatus, int filterComponentItemId) {
        ArrayList<Order> orders = new ArrayList<Order>();
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, productItems.title as product_item_title, productItems.name as product_item_name, users.name as user_name");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid + " as orders ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as productItems ");
            query.append(" ON orders.component_id=productItems.id");
            query.append(SQL_LEFT_JOIN);
            query.append(" user as users ");
            query.append(" ON orders.user_id=users.id");
            query.append(SQL_WHERE);
            query.append(" orders.copy_id=? ");
            if (!Utils.isBlankString((String)filterTestStatus) || !Utils.isBlankString((String)filterPermanentStatus)) {
                query.append(" AND (");
                if (!Utils.isBlankString((String)filterTestStatus)) {
                    query.append(" (orders.type=0 AND orders.status in (" + filterTestStatus + ")) ");
                }
                if (!Utils.isBlankString((String)filterPermanentStatus) && !Utils.isBlankString((String)filterTestStatus)) {
                    query.append(" OR ");
                }
                if (!Utils.isBlankString((String)filterPermanentStatus)) {
                    query.append("(orders.type=1 AND orders.status in (" + filterPermanentStatus + ")) ");
                }
                query.append(")");
            }
            if (filterComponentItemId >= 0) {
                query.append(" AND orders.component_id=" + filterComponentItemId);
            }
            query.append(" ORDER BY orders.create_date DESC, product_item_title");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                orders.add(this.getOrderFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getCopyItemOrders( " + copyId + " )", (Throwable)ex);
        }
        return orders;
    }

    public List<Order> getOrders(int copyId) {
        return this.getOrders(copyId, OrderType.UNKNOWN, -1, -1);
    }

    public Order getOrder(int orderId) {
        Order order = null;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" orders.id, orders.copy_id, orders.component_id, orders.type, orders.term, orders.count, orders.status, orders.create_date, orders.user_id, orders.lu, pi.title as product_item_title, pi.name as product_item_name, users.name as user_name");
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid + " as orders ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as pi ");
            query.append(" ON orders.component_id=pi.id");
            query.append(SQL_LEFT_JOIN);
            query.append(" user as users ");
            query.append(" ON orders.user_id=users.id");
            query.append(SQL_WHERE);
            query.append(" orders.id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, orderId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                order = this.getOrderFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getCopyItemOrder( " + orderId + " )", (Throwable)ex);
        }
        return order;
    }

    public void createTestCopiesForOrder(Order order, int term, int count) throws BGMessageException {
        order.setId(0);
        order.setTerm(term);
        order.setCount(count);
        order.setType(OrderType.TEST);
        this.updateCopyItemOrder(order);
    }

    public void deleteOrder(int orderId) {
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append(" lic_order_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, orderId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("deleteOrder( " + orderId + " )", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkCopyItemStatus(int copyItemId) {
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append(" status ");
        query.append(SQL_FROM);
        query.append(" lic_order_" + this.mid + " as orders ");
        query.append(SQL_JOIN);
        query.append(" lic_confirmed_order_" + this.mid + " as ci ");
        query.append(" ON ci.order_id=orders.id ");
        query.append(SQL_WHERE);
        query.append(" ci.id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyItemId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return false;
            int status = rs.getInt("status");
            if (status != 3) {
                if (status != 2) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.log.error("checkCopyItemStatus( " + copyItemId + " ) ", (Throwable)e);
        }
        return false;
    }

    public boolean checkHaveNonSignAdditionalAgreement(int copyId) throws BGException {
        Copy copy = this.getCopy(copyId);
        if (copy == null) {
            throw new BGIllegalArgumentException();
        }
        List<AdditionalAgreement> list = this.getListAdditionalAgreement(copy.getContractId(), copyId);
        for (AdditionalAgreement aa : list) {
            if (aa.isSign()) continue;
            return true;
        }
        return false;
    }

    public int createLicense(License lic) {
        int packageId = 0;
        if (lic != null) {
            try {
                int index = 1;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append(SQL_INSERT);
                query.append(" lic_license_" + this.mid);
                query.append(" SET copy_id=?, user_id=?, data=?, create_date=now()");
                ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, lic.getCopyId());
                ps.setInt(index++, lic.getUserId());
                ps.setString(index++, lic.getData());
                ps.executeUpdate();
                packageId = this.lastInsertId(ps);
                lic.setId(packageId);
                ps.close();
                query = new StringBuilder();
                query.append(SQL_INSERT);
                query.append(" lic_license_component_" + this.mid);
                query.append(" SET license_id=?, component_id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, packageId);
                int[] copyItemIds = lic.getCopyItemIds();
                for (int i = 0; i < copyItemIds.length; ++i) {
                    ps.setInt(2, copyItemIds[i]);
                    ps.executeUpdate();
                }
                ps.close();
            }
            catch (Exception ex) {
                this.log.error("createPackage( " + lic + " )", (Throwable)ex);
            }
        }
        return packageId;
    }

    public void updateLicenseData(License lic) {
        if (lic != null) {
            try {
                int index = 1;
                PreparedStatement ps = null;
                StringBuilder query = new StringBuilder();
                query.append(SQL_UPDATE);
                query.append(" lic_license_" + this.mid);
                query.append(" SET data=?, original_data=? ");
                query.append(" WHERE id=? ");
                ps = this.con.prepareStatement(query.toString());
                ps.setString(index++, lic.getData());
                ps.setString(index++, lic.getOriginalData());
                ps.setInt(index++, lic.getId());
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                this.log.error("updatePackageData( " + lic + " )", (Throwable)ex);
            }
        }
    }

    public ConfirmedOrder groupCopyItems(int productItemId, int copyId, int[] orderStatuses) {
        ConfirmedOrder grouppedCopyItem = null;
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append("product.id, product.name, GROUP_CONCAT(ord.count) as counts ");
        query.append(SQL_FROM);
        query.append(" lic_order_" + this.mid + " as ord ");
        query.append(SQL_JOIN);
        query.append(" lic_component_" + this.mid + " as product ");
        query.append(" ON ord.component_id=product.id ");
        query.append(SQL_JOIN);
        query.append(" lic_copy_" + this.mid + " as copy ");
        query.append(" ON ord.copy_id=copy.id ");
        query.append(SQL_WHERE);
        query.append(" ord.component_id=? AND ord.copy_id=? AND ord.type=1 ");
        for (int i = 0; i < orderStatuses.length; ++i) {
            if (i == 0) {
                query.append(" AND ( ");
            } else {
                query.append(" OR ");
            }
            query.append(" ord.status=" + orderStatuses[i] + " ");
            if (i != orderStatuses.length - 1) continue;
            query.append(" ) ");
        }
        query.append(SQL_GROUP_BY);
        query.append(" ord.component_id ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, productItemId);
            ps.setInt(2, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    grouppedCopyItem = new ConfirmedOrder();
                    grouppedCopyItem.setComponentId(rs.getInt(1));
                    grouppedCopyItem.setComponentName(rs.getString(2));
                    grouppedCopyItem.setCount(this.getCountFromBlob(rs.getString(3)));
                }
            }
        }
        catch (Exception e) {
            this.log.error("groupCopyItems", (Throwable)e);
        }
        return grouppedCopyItem;
    }

    public List<License> getLicenses(int copyId) {
        ArrayList<License> licenses = new ArrayList<License>();
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append(" pack.*, users.name ");
        query.append(SQL_FROM);
        query.append(" lic_license_" + this.mid + " as pack ");
        query.append(SQL_LEFT_JOIN);
        query.append(" user as users ");
        query.append(" ON pack.user_id=users.id");
        query.append(SQL_WHERE);
        query.append(" copy_id=? ");
        query.append(SQL_ORDER_BY);
        query.append(" create_date DESC ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, copyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    licenses.add(this.getLicenseFromRs(rs));
                }
            }
        }
        catch (SQLException e) {
            this.log.error("getPackages( " + copyId + " )", (Throwable)e);
        }
        return licenses;
    }

    public License getCurrentLicense(int copyId) {
        License lic = new License();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" pack.*, users.name ");
            query.append(SQL_FROM);
            query.append(" lic_license_" + this.mid + " as pack ");
            query.append(SQL_LEFT_JOIN);
            query.append(" user as users ");
            query.append(" ON pack.user_id=users.id");
            query.append(SQL_WHERE);
            query.append(" copy_id=? ");
            query.append(SQL_ORDER_BY);
            query.append(" create_date DESC ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, copyId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                lic = this.getLicenseFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("getCurrentLicense( " + copyId + " )", (Throwable)e);
        }
        return lic;
    }

    public License getLicenseById(int licenseId) {
        License lic = new License();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" pack.*, users.name ");
            query.append(SQL_FROM);
            query.append(" lic_license_" + this.mid + " as pack ");
            query.append(SQL_LEFT_JOIN);
            query.append(" user as users ");
            query.append(" ON pack.user_id=users.id");
            query.append(SQL_WHERE);
            query.append(" pack.id=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                lic = this.getLicenseFromRs(rs);
            }
        }
        catch (SQLException e) {
            this.log.error("getLicenseById( " + licenseId + " )", (Throwable)e);
        }
        return lic;
    }

    public List<ConfirmedOrder> getLicenseItems(int licenseId, boolean testDateForNow) {
        ArrayList<ConfirmedOrder> copyItems = new ArrayList<ConfirmedOrder>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("GROUP_CONCAT(ci.id) as ids, ord.type, GROUP_CONCAT(ord.count) as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ");
            query.append(SQL_FROM);
            query.append(" lic_license_component_" + this.mid + " as packi ");
            query.append(SQL_JOIN);
            query.append(" lic_confirmed_order_" + this.mid + " as ci ");
            query.append(" ON packi.component_id=ci.id ");
            query.append(SQL_JOIN);
            query.append(" lic_order_" + this.mid + " as ord ");
            query.append(" ON ci.order_id=ord.id ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as pi ");
            query.append(" ON ord.component_id=pi.id ");
            query.append(SQL_WHERE);
            query.append(" packi.license_id=? AND ord.type=? ");
            query.append(SQL_GROUP_BY);
            query.append("component_id");
            query.append(SQL_ORDER_BY);
            query.append("to_date DESC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ps.setInt(2, OrderType.BUY.getCode());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
            query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("ci.id as ids, ord.type, ord.count as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ");
            query.append(SQL_FROM);
            query.append(" lic_license_component_" + this.mid + " as packi ");
            query.append(SQL_JOIN);
            query.append(" lic_confirmed_order_" + this.mid + " as ci ");
            query.append(" ON packi.component_id=ci.id ");
            query.append(SQL_JOIN);
            query.append(" lic_order_" + this.mid + " as ord ");
            query.append(" ON ci.order_id=ord.id ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as pi ");
            query.append(" ON ord.component_id=pi.id ");
            query.append(SQL_WHERE);
            query.append(" packi.license_id=? AND ord.type=? " + (testDateForNow ? "and ci.to_date>=now() " : ""));
            query.append(SQL_ORDER_BY);
            query.append("to_date DESC");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, licenseId);
            ps.setInt(2, OrderType.TEST.getCode());
            rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.log.error("getLicenseItems( " + licenseId + ")", (Throwable)e);
        }
        return copyItems;
    }

    public List<Copy> getCopyList(int contractId) {
        ArrayList<Copy> copyList = new ArrayList<Copy>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" tc.id, tc.contract_id, tc.product_id, tc.dt, tc.licensee_name, tc.comment, tc.lu, tp.title, tp.version ");
            query.append(SQL_FROM);
            query.append(" lic_copy_" + this.mid + " as tc ");
            query.append(SQL_JOIN);
            query.append(" lic_product_" + this.mid + " as tp ");
            query.append(" ON tc.product_id=tp.id ");
            query.append(SQL_WHERE);
            query.append(" tc.contract_id=? ");
            query.append(SQL_ORDER_BY);
            query.append(" product_id ");
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                int index = 1;
                ps.setInt(index++, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        copyList.add(this.getCopyFromRs(rs));
                    }
                }
            }
        }
        catch (SQLException e) {
            this.log.error("getCopyList( " + contractId + ")", (Throwable)e);
        }
        return copyList;
    }

    public List<ConfirmedOrder> getCopyItems(int copyId, int filter) throws BGException {
        ConfirmedOrder item;
        ResultSet resultSet;
        int index;
        PreparedStatement ps;
        ArrayList<ConfirmedOrder> copyItems = new ArrayList<ConfirmedOrder>();
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append("GROUP_CONCAT(ci.id) as ids, ord.type, GROUP_CONCAT(ord.count) as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name, ord.component_id ");
        query.append(SQL_FROM);
        query.append(" lic_confirmed_order_" + this.mid + " as ci ");
        query.append(SQL_JOIN);
        query.append(" lic_order_" + this.mid + " as ord ");
        query.append(" ON ci.order_id=ord.id ");
        query.append(SQL_JOIN);
        query.append(" lic_component_" + this.mid + " as pi ");
        query.append(" ON ord.component_id=pi.id ");
        query.append(SQL_WHERE);
        query.append(" ord.type=1 AND ord.status=2 AND ord.copy_id=? AND ci.to_date>=now() ");
        query.append(SQL_GROUP_BY);
        query.append("component_id");
        query.append(SQL_ORDER_BY);
        query.append(" product_item_title");
        HashMap<Integer, ConfirmedOrder> copyItemsMap = new HashMap<Integer, ConfirmedOrder>();
        try {
            ps = this.con.prepareStatement(query.toString());
            try {
                index = 1;
                ps.setInt(index++, copyId);
                resultSet = ps.executeQuery();
                try {
                    while (resultSet.next()) {
                        item = this.getCopyItemFromRs(resultSet);
                        copyItems.add(item);
                        copyItemsMap.put(item.getComponentId(), item);
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if (filter != 1) {
            query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("ci.id as ids, ord.type, ord.count as counts, ci.to_date, pi.title as product_item_title, pi.name as product_item_name,  ord.component_id ");
            query.append(SQL_FROM);
            query.append(" lic_confirmed_order_" + this.mid + " as ci ");
            query.append(SQL_JOIN);
            query.append(" lic_order_" + this.mid + " as ord ");
            query.append(" ON ci.order_id=ord.id ");
            query.append(SQL_JOIN);
            query.append(" lic_component_" + this.mid + " as pi ");
            query.append(" ON ord.component_id=pi.id ");
            query.append(SQL_WHERE);
            query.append(" ord.type=0 AND ord.status=3 AND ord.copy_id=? AND ci.to_date>=now() ");
            query.append(SQL_ORDER_BY);
            query.append(" product_item_title");
            try {
                ps = this.con.prepareStatement(query.toString());
                try {
                    index = 1;
                    ps.setInt(index++, copyId);
                    resultSet = ps.executeQuery();
                    try {
                        while (resultSet.next()) {
                            item = this.getCopyItemFromRs(resultSet);
                            if (filter == 0) {
                                ConfirmedOrder boughtItem = (ConfirmedOrder)copyItemsMap.get(item.getComponentId());
                                if (boughtItem != null && (boughtItem.getCount() <= 0 || item.getCount() <= boughtItem.getCount() && item.getCount() != 0)) continue;
                                copyItems.remove(boughtItem);
                                copyItems.add(item);
                                continue;
                            }
                            copyItems.add(item);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        return copyItems;
    }

    public int[] getCopyItemIds(int copyId) throws BGException {
        List<ConfirmedOrder> copyItems = this.getCopyItems(copyId, 2);
        StringBuilder itemIds = new StringBuilder();
        for (int i = 0; i < copyItems.size(); ++i) {
            itemIds.append(copyItems.get(i).getIds());
            if (i >= copyItems.size() - 1) continue;
            itemIds.append(',');
        }
        List idList = Utils.toList((String)itemIds.toString());
        int[] ids = new int[idList.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Integer.valueOf((String)idList.get(i));
        }
        return ids;
    }

    public List<Product> getProducts() throws BGException {
        ArrayList<Product> products = new ArrayList<Product>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("id, title, version, lu");
            query.append(SQL_FROM);
            query.append(" lic_product_" + this.mid);
            query.append(SQL_ORDER_BY);
            query.append("id");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                products.add(this.getProductFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return products;
    }

    public List<bitel.billing.server.contract.bean.Contract> getContractByTitlePart(String titlePart) throws BGException {
        ArrayList<bitel.billing.server.contract.bean.Contract> contracts = new ArrayList<bitel.billing.server.contract.bean.Contract>();
        try {
            String query = "SELECT * FROM contract WHERE title LIKE ?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, titlePart + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contracts.add(this.getContractFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex.getMessage(), (Throwable)ex);
        }
        return contracts;
    }

    public void updateTestComponentDateTo(int orderId, Date dateTo) {
        try {
            String query = "UPDATE  lic_confirmed_order_" + this.mid + " SET to_date=? WHERE id=? AND to_date<?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateTo.getTime()));
            ps.setInt(2, orderId);
            ps.setTimestamp(3, new Timestamp(dateTo.getTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("LicenseManager.updateTestComponentDateTo", (Throwable)e);
        }
    }

    private Order getOrderFromRs(ResultSet rs) throws SQLException {
        Order order = new Order();
        order.setId(rs.getInt("id"));
        order.setCopyId(rs.getInt("copy_id"));
        order.setComponentId(rs.getInt("component_id"));
        order.setCount(rs.getInt("count"));
        order.setStatus(rs.getInt("status"));
        order.setType(OrderType.getOrderTypeByCode((int)rs.getInt("type")));
        order.setTerm(rs.getInt("term"));
        order.setUserId(rs.getInt("user_id"));
        order.setCreateDate((Date)rs.getTimestamp("create_date"));
        order.setLastUpdate((Date)rs.getTimestamp("lu"));
        order.setComponentTitle(rs.getString("product_item_title"));
        order.setComponentName(rs.getString("product_item_name"));
        order.setUserName(rs.getString("user_name"));
        return order;
    }

    public List<ConfirmedOrder> getCopyItemsFromPackage(int packageId) {
        ArrayList<ConfirmedOrder> copyItems = new ArrayList<ConfirmedOrder>();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append("id, component_id, type, count, from_date, to_date, lu");
            query.append(SQL_FROM);
            query.append(" lic_confirmed_order_" + this.mid + " as ci ");
            query.append(SQL_LEFT_JOIN);
            query.append(" lic_license_component_" + this.mid + " as packi ");
            query.append(" ON ci.id=packi.component_id ");
            query.append(SQL_WHERE);
            query.append(" packi.license_id=?");
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, packageId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                copyItems.add(this.getCopyItemFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.log.error("getCopyItemsFromPackage( " + packageId + ")", (Throwable)e);
        }
        return copyItems;
    }

    private Product getProductFromRs(ResultSet rs) throws SQLException {
        Product product = new Product();
        product.setId(rs.getInt("id"));
        product.setTitle(rs.getString("title"));
        product.setVersion(rs.getString("version"));
        product.setLastUpdate((Date)rs.getDate("lu"));
        return product;
    }

    private Component getProductItemFromRs(ResultSet rs) throws SQLException {
        Component productItem = new Component();
        productItem.setId(rs.getInt("id"));
        productItem.setTitle(rs.getString("title"));
        productItem.setName(rs.getString("name"));
        productItem.setComment(rs.getString("comment"));
        productItem.setType(rs.getInt("type"));
        productItem.setUnlimited(rs.getInt("unlimited"));
        productItem.setAvailableOnWeb(rs.getBoolean("available_on_web"));
        productItem.setLastUpdate((Date)rs.getDate("lu"));
        productItem.setCategory(ComponentCategory.getComponentCategoryByCode((int)rs.getInt("category_id")));
        return productItem;
    }

    private ConfirmedOrder getCopyItemFromRs(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        ConfirmedOrder copyItem = new ConfirmedOrder();
        copyItem.setIds(rs.getString("ids"));
        copyItem.setComponentTitle(rs.getString("product_item_title"));
        copyItem.setComponentName(rs.getString("product_item_name"));
        copyItem.setComponentId(rs.getInt("component_id"));
        copyItem.setType(rs.getInt("type"));
        copyItem.setCount(this.getCountFromBlob(rs.getString("counts")));
        copyItem.setDateTo((Date)rs.getDate("to_date"));
        return copyItem;
    }

    private int getCountFromBlob(String countList) throws UnsupportedEncodingException, SQLException {
        String[] countArray = countList.split(",");
        int count = 0;
        for (int i = 0; i < countArray.length; ++i) {
            if (Utils.parseInt((String)countArray[i]) == 0) {
                count = 0;
                break;
            }
            count += Integer.valueOf(countArray[i]).intValue();
        }
        return count;
    }

    private Copy getCopyFromRs(ResultSet rs) throws SQLException {
        Copy copy = new Copy();
        copy.setId(rs.getInt("id"));
        copy.setProductId(rs.getInt("product_id"));
        copy.setProductTitle(rs.getString("title"));
        copy.setProductVersion(rs.getString("version"));
        copy.setContractId(rs.getInt("contract_id"));
        copy.setLicenseeName(rs.getString("licensee_name"));
        copy.setComment(rs.getString("comment"));
        copy.setDate((Date)rs.getTimestamp("dt"));
        copy.setLastUpdate((Date)rs.getDate("lu"));
        return copy;
    }

    private License getLicenseFromRs(ResultSet rs) throws SQLException {
        License license = new License();
        license.setId(rs.getInt("id"));
        license.setCopyId(rs.getInt("copy_id"));
        license.setCreateDate((Date)rs.getTimestamp("create_date"));
        license.setUserId(rs.getInt("user_id"));
        license.setUserName(rs.getString("name"));
        license.setData(rs.getString("data"));
        license.setOriginalData(rs.getString("original_data"));
        return license;
    }

    public String getOrganizationTitle(int contractId, int fullOrganizationNameParamId) {
        String title = new String();
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_SELECT);
            query.append(" val ");
            query.append(SQL_FROM);
            query.append(" contract_parameter_type_1 ");
            query.append(SQL_WHERE);
            query.append(" cid=? AND pid=? ");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ps.setInt(2, fullOrganizationNameParamId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                title = rs.getString("val");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            this.log.error("getOrganizationTitle( " + contractId + " ) ", (Throwable)e);
        }
        return title;
    }

    public String getContractComment(int contractId) {
        String comment = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            comment = ((Contract)contractDao.get(contractId)).getComment();
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        return comment;
    }

    public String getLicenseText(int licenseId) {
        String licText = new String();
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append("data");
        query.append(SQL_FROM);
        query.append(" lic_license_" + this.mid);
        query.append(SQL_WHERE);
        query.append("id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, licenseId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    licText = rs.getString("data");
                }
            }
        }
        catch (SQLException e) {
            this.log.error("getLicenseText( " + licenseId + " )", (Throwable)e);
        }
        return licText;
    }

    public String getOriginalLicenseText(int licenseId) {
        String licText = new String();
        StringBuilder query = new StringBuilder();
        query.append(SQL_SELECT);
        query.append(" original_data ");
        query.append(SQL_FROM);
        query.append(" lic_license_" + this.mid);
        query.append(SQL_WHERE);
        query.append(" id=? ");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, licenseId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    licText = rs.getString("original_data");
                }
            }
        }
        catch (SQLException e) {
            this.log.error("getOriginalLicenseText( " + licenseId + " )", (Throwable)e);
        }
        return licText;
    }

    protected int lastInsertId(PreparedStatement ps) throws SQLException {
        int id = -1;
        ResultSet rs = ps.getGeneratedKeys();
        while (rs.next()) {
            id = rs.getInt(1);
        }
        return id;
    }

    protected void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                this.log.error("closeConnection( " + con + ")", (Throwable)ex);
            }
        }
    }

    private bitel.billing.server.contract.bean.Contract getContractFromRS(ResultSet rs) throws SQLException {
        bitel.billing.server.contract.bean.Contract contract = new bitel.billing.server.contract.bean.Contract();
        contract.setId(rs.getInt("id"));
        contract.setTitle(rs.getString("title"));
        contract.setPswd(rs.getString("pswd"));
        contract.setComment(rs.getString("comment"));
        contract.setBalanceMode(rs.getInt("mode"));
        contract.setBalanceLimit(rs.getBigDecimal("closesumma"));
        contract.setGroups(rs.getLong("gr"));
        contract.setFc(rs.getInt("fc"));
        contract.setParamGroup(rs.getInt("pgid"));
        contract.setDateFrom((Date)rs.getDate("date1"));
        contract.setDateTo((Date)rs.getDate("date2"));
        contract.setDel(rs.getInt("del"));
        contract.setSuperId(rs.getInt("scid"));
        contract.setSubMode(rs.getInt("sub_mode"));
        contract.setStatus(rs.getInt("status"));
        contract.setTitlePatternId(rs.getInt("title_pattern_id"));
        contract.setStatusDate(TimeUtils.convertDateToCalendar((Date)rs.getDate("status_date")));
        return contract;
    }

    public List<AdditionalAgreement> getListAdditionalAgreement(int contractId, int copyId) throws BGException {
        ArrayList<AdditionalAgreement> result = new ArrayList<AdditionalAgreement>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT  *  FROM lic_additional_agreement_" + this.mid + " WHERE contractId=" + contractId + " AND copy_id=" + copyId + " ORDER BY  number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AdditionalAgreement row = new AdditionalAgreement();
                row.setId(rs.getInt("id"));
                row.setCopyId(rs.getInt("copy_id"));
                row.setAgreementNumber(rs.getInt("number"));
                row.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
                row.setStatus(rs.getInt("status"));
                row.setSum(rs.getBigDecimal("sum"));
                row.setDocumentId(rs.getInt("document_id"));
                row.setBillId(rs.getInt("bill_id"));
                row.setChargeId(rs.getInt("charge_id"));
                row.setInvoiceId(rs.getInt("invoice_id"));
                if (rs.getBytes("specification") != null) {
                    ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    Result r = (Result)unmarshaller.unmarshal((InputStream)stream);
                    row.setSpecification(r.getList());
                }
                row.setChargeId(rs.getInt("charge_id"));
                result.add(row);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public AdditionalAgreement getAdditionalAgreement(int id) throws BGException {
        AdditionalAgreement row = new AdditionalAgreement();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM lic_additional_agreement_" + this.mid + "WHERE id=" + id);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                row.setId(rs.getInt("id"));
                row.setCopyId(rs.getInt("copy_id"));
                row.setAgreementNumber(rs.getInt("number"));
                row.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")));
                row.setStatus(rs.getInt("status"));
                row.setSum(rs.getBigDecimal("sum"));
                row.setDocumentId(rs.getInt("document_id"));
                row.setBillId(rs.getInt("bill_id"));
                row.setChargeId(rs.getInt("charge_id"));
                row.setInvoiceId(rs.getInt("invoice_id"));
                if (rs.getBytes("specification") == null) continue;
                ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                Result r = (Result)unmarshaller.unmarshal((InputStream)stream);
                row.setSpecification(r.getList());
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
        return row;
    }

    public void setAdditionalAgreement(AdditionalAgreement title, int contractId) throws BGException {
        try {
            Result r = new Result(title.getSpecification());
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal((Object)r, (OutputStream)stream);
            StringBuilder query = new StringBuilder();
            query.append(SQL_INSERT);
            query.append("lic_additional_agreement_");
            query.append(this.mid);
            query.append("SET contractId=?, copy_Id=?, number=?, date=?, status=?, sum=?, document_id=?, bill_id=?, specification=?, charge_id=?");
            int index = 1;
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(index++, contractId);
            ps.setInt(index++, title.getCopyId());
            ps.setInt(index++, title.getAgreementNumber());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)title.getDate()));
            ps.setInt(index++, title.getStatus());
            ps.setBigDecimal(index++, title.getSum());
            ps.setInt(index++, title.getDocumentId());
            ps.setInt(index++, title.getBillId());
            ps.setBytes(index++, stream.toByteArray());
            ps.setInt(index++, title.getChargeId());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        catch (JAXBException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteAdditionalAgreement(int idAdditionalAgreement) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_DELETE);
            query.append(SQL_FROM);
            query.append("lic_additional_agreement_");
            query.append(this.mid);
            query.append(SQL_WHERE);
            query.append("id = ?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, idAdditionalAgreement);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void resetCopyDiscount(int contractId, int productCopyId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append(SQL_UPDATE);
            query.append(" lic_copy_");
            query.append(this.mid);
            query.append(" SET discount=0");
            query.append(SQL_WHERE);
            query.append("contract_id=? AND id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ps.setInt(2, productCopyId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<SpecificationTitle> getSpecificationOfAdditionalAgreement(int id) throws BGException {
        List list = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT specification FROM lic_additional_agreement_" + this.mid + " WHERE id=" + id);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getBytes("specification") != null) {
                ByteArrayInputStream stream = new ByteArrayInputStream(rs.getBytes("specification"));
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Result.class, SpecificationTitle.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                list = ((Result)unmarshaller.unmarshal((InputStream)stream)).getList();
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public int getLastNumber(int contractId) throws BGException {
        int result = -1;
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT MAX(number) FROM lic_additional_agreement_" + this.mid + " WHERE contractId=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
                if (rs.wasNull()) {
                    result = -1;
                }
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public BigDecimal getDiscount(int contractId, int copyId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT discount FROM lic_copy_" + this.mid + " WHERE contract_id=" + contractId + " AND id=" + copyId);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                BigDecimal result = rs.getBigDecimal("discount");
                rs.close();
                ps.close();
                return result;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return null;
    }

    public void setDiscount(BigDecimal discount, int contractId, int copyId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE lic_copy_" + this.mid + " SET discount =" + discount + " WHERE id=" + copyId + " AND contract_id=" + contractId);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setStatusSigned(int id) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE lic_additional_agreement_" + this.mid + " SET status=1 WHERE id=" + id);
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setCharge(int id, int chargeId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE lic_additional_agreement_" + this.mid + " SET charge_id=? WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, chargeId);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void setInvoice(int id, int invoiceId) throws BGException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE lic_additional_agreement_" + this.mid + " SET invoice_id=? WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, invoiceId);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public int getOrderIdFromConfirmedId(int condirmedOrderId) {
        if (condirmedOrderId < 0) {
            return -1;
        }
        int res = -1;
        try {
            StringBuilder query = new StringBuilder();
            PreparedStatement ps = null;
            query.append(SQL_SELECT);
            query.append(" order_id ");
            query.append(SQL_FROM);
            query.append(" lic_confirmed_order_" + this.mid);
            query.append(SQL_WHERE);
            query.append(" id=? ");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, condirmedOrderId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                res = rs.getInt("order_id");
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            this.log.error("getOrderIdFromConfirmedId( " + condirmedOrderId + " )", (Throwable)ex);
        }
        return res;
    }

    public Map<Integer, int[]> getCopyCountForComponentByProductMap(int productId) {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        try {
            int[] counters;
            StringBuilder subQuery = new StringBuilder().append(SQL_SELECT).append("id").append(SQL_FROM).append(" lic_copy_").append(this.moduleId).append(SQL_WHERE).append("product_id=?");
            StringBuilder sub1Query = new StringBuilder().append(SQL_SELECT).append("concat(copy_id,' ',component_id)").append(SQL_FROM).append(" lic_order_").append(this.moduleId).append(SQL_WHERE).append("count=0 AND type=1 AND status=2 AND ").append("copy_id").append(SQL_IN).append("( ").append((CharSequence)subQuery).append(" )");
            StringBuilder query = new StringBuilder().append(SQL_SELECT).append("component_id, COUNT(DISTINCT copy_id)").append(SQL_FROM).append(" lic_order_").append(this.moduleId).append(SQL_WHERE).append("type=1").append(SQL_AND).append("status=2").append(SQL_AND).append("copy_id").append(SQL_IN).append("( ").append((CharSequence)subQuery).append(" )").append(SQL_GROUP_BY).append("component_id");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                counters = new int[3];
                counters[0] = rs.getInt(2);
                map.put(rs.getInt(1), counters);
            }
            rs.close();
            ps.close();
            query = new StringBuilder().append(SQL_SELECT).append("component_id, COUNT(DISTINCT copy_id)").append(SQL_FROM).append(" lic_order_").append(this.moduleId).append(SQL_WHERE).append("type=1").append(SQL_AND).append("status=2").append(SQL_AND).append("count=0").append(SQL_AND).append("copy_id").append(SQL_IN).append("( ").append((CharSequence)subQuery).append(" )").append(SQL_GROUP_BY).append("component_id");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            rs = ps.executeQuery();
            while (rs.next()) {
                counters = (int[])map.get(rs.getInt(1));
                if (counters == null) {
                    counters = new int[3];
                    map.put(rs.getInt(1), counters);
                }
                counters[1] = rs.getInt(2);
            }
            rs.close();
            ps.close();
            query = new StringBuilder().append(SQL_SELECT).append("component_id, SUM(count)").append(SQL_FROM).append(" lic_order_").append(this.moduleId).append(SQL_WHERE).append("type=1").append(SQL_AND).append("status=2").append(SQL_AND).append("copy_id").append(SQL_IN).append("( ").append((CharSequence)subQuery).append(" )").append(SQL_AND).append("concat(copy_id,' ',component_id)").append(SQL_NOT_IN).append("( ").append((CharSequence)sub1Query).append(" )").append(SQL_GROUP_BY).append("component_id");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, productId);
            ps.setInt(2, productId);
            rs = ps.executeQuery();
            while (rs.next()) {
                counters = (int[])map.get(rs.getInt(1));
                if (counters == null) {
                    counters = new int[3];
                    map.put(rs.getInt(1), counters);
                }
                counters[2] = rs.getInt(2);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            e.printStackTrace();
        }
        return map;
    }

    public List<ContractData> doContractData(int productId, int componentId) {
        ArrayList<ContractData> list = new ArrayList<ContractData>();
        try {
            StringBuilder query = new StringBuilder().append(SQL_SELECT).append(SQL_DISTINCT).append("c.id, title, c.comment").append(SQL_FROM).append(" lic_order_").append(this.moduleId).append(" AS a").append(SQL_LEFT_JOIN).append(" lic_copy_").append(this.moduleId).append(" AS b").append(SQL_ON).append("a.copy_id=b.id").append(SQL_LEFT_JOIN).append("contract").append(" AS c").append(SQL_ON).append("c.id=b.contract_id").append(SQL_WHERE).append("component_id=?").append(SQL_AND).append("product_id=?").append(SQL_AND).append("type=1").append(SQL_AND).append("a.status=2");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, componentId);
            ps.setInt(2, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractData contractData = new ContractData();
                contractData.setContractId(rs.getInt(1));
                contractData.setContractTitle(rs.getString(2));
                contractData.setContractComment(rs.getString(3));
                list.add(contractData);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            e.printStackTrace();
        }
        return list;
    }
}

