/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.modules.license.client.DefaultOrder;
import ru.bitel.bgbilling.modules.license.client.DefaultOrdersPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class PatternModuleTabPanelItemFactory
implements PatternModuleTabPanel.PatternModuleTabPanelItemFactory {
    public Collection<PatternModuleTabPanel.PatternModuleTabPanelItem> getPatternModuleTabPanelItems(int moduleId, String moduleTitle) {
        return Collections.singleton(new AddLicenseDefaults(moduleId, moduleTitle));
    }

    private class AddLicenseDefaults
    extends PatternModuleTabPanel.PatternModuleTabPanelItem {
        private BGControlPanelListSelect products;
        private DefaultOrdersPanel components;
        private String title;

        private AddLicenseDefaults(int moduleId, String title) {
            super((LayoutManager)new GridBagLayout(), moduleId);
            this.products = new BGControlPanelListSelect();
            this.components = new DefaultOrdersPanel();
            this.title = null;
            this.setTitle("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
            this.components.setModuleId(moduleId);
            this.add(BGSwingUtilites.wrapBorder((JPanel)this.products, (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
            this.add(BGSwingUtilites.wrapBorder((JPanel)((Object)this.components), (String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        protected void init() {
            Request request = new Request();
            request.setModule("license");
            request.setModuleId(this.getModuleId());
            request.setAction("GetProducts");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildList((JList)this.products.getList(), (DefaultListModel)this.products.getListModel(), (Node)XMLUtils.selectNode((Node)doc, (String)"data/table/data"));
                ClientUtils.buildComboBox(this.components.getProducts(), (Node)XMLUtils.selectNode((Node)doc, (String)"data/table/data"), (String)"");
            }
        }

        protected boolean isItemEnabled() {
            return false;
        }

        protected void reset() {
        }

        protected void serialise(Element element) {
            Document doc = element.getOwnerDocument();
            Element module = doc.createElement("license");
            element.appendChild(module);
            module.setAttribute("mid", String.valueOf(this.getModuleId()));
            Element selectedProducts = doc.createElement("selectedProducts");
            module.appendChild(selectedProducts);
            for (String pid : Utils.toList((String)this.products.getListValues())) {
                Element item = XMLUtils.createElement((Element)selectedProducts, (String)"product");
                item.setAttribute("id", pid);
            }
            Element defaultOrdersEl = doc.createElement("defaultOrders");
            module.appendChild(defaultOrdersEl);
            for (String pid : Utils.toList((String)this.products.getListValues())) {
                Element product = XMLUtils.createElement((Element)defaultOrdersEl, (String)"product");
                product.setAttribute("id", pid);
                for (DefaultOrder order : this.components.getProductOrders(pid)) {
                    Element orderEl = XMLUtils.createElement((Element)product, (String)"order");
                    orderEl.setAttribute("componentId", order.getComponentId());
                    orderEl.setAttribute("count", String.valueOf(order.getCount()));
                    orderEl.setAttribute("term", String.valueOf(order.getTerm()));
                    orderEl.setAttribute("title", order.getTitle());
                }
            }
        }

        protected void setData(Element element) {
            Element selectedProducts = XMLUtils.selectElement((Node)element, (String)("data/modules/license[@mid=" + this.getModuleId() + "]/selectedProducts"));
            ArrayList<String> idList = new ArrayList<String>();
            if (selectedProducts != null) {
                for (Element item : XMLUtils.selectElements((Node)selectedProducts, (String)"product")) {
                    idList.add(item.getAttribute("id"));
                }
            }
            this.products.setListValues(Utils.toString(idList));
            Element productOrders = XMLUtils.selectElement((Node)element, (String)("data/modules/license[@mid=" + this.getModuleId() + "]/defaultOrders"));
            ArrayList<DefaultOrder> orderList = new ArrayList<DefaultOrder>();
            if (productOrders != null) {
                for (Element product : XMLUtils.selectElements((Node)productOrders, (String)"product")) {
                    String productId = product.getAttribute("id");
                    for (Element order : XMLUtils.selectElements((Node)product, (String)"order")) {
                        int count = Integer.valueOf(order.getAttribute("count"));
                        int term = Integer.valueOf(order.getAttribute("term"));
                        String componentId = order.getAttribute("componentId");
                        String title = order.getAttribute("title");
                        orderList.add(new DefaultOrder(productId, componentId, title, count, term));
                    }
                }
            }
            this.components.setProductOrders(orderList);
        }
    }
}

