/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.license.client.LicenceBGUTable;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.service.AdditionalAgreementService;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.bgbilling.modules.license.common.service.OrderService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.KeyValue;

public class AdditionalAgreementPanel
extends BGUPanel {
    static final String NUMBERTEXT = "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440.";
    private BGTableModel<AdditionalAgreement> additionalAgreementTableModel;
    private BGUTable additionalAgreementBgTable;
    private InformationModelTableModel informationModel;
    private int copyId;
    private String module;
    private int mid;
    private int cid;
    private BGTextField discountField = new BGTextField(20);
    private BGTextField numberField = new BGTextField(20);
    private JPopupMenu popupMenu = new JPopupMenu();
    AbstractBGUPanel.DefaultAction refresh;
    AbstractBGUPanel.DefaultAction getNewAdditionalAgreement;
    AbstractBGUPanel.DefaultAction deleteAdditionalAgreement;
    AbstractBGUPanel.DefaultAction setDiscount;
    AbstractBGUPanel.DefaultAction setStatus;
    AdditionalAgreementService service = (AdditionalAgreementService)((ClientContext)this.getContext()).getPort(AdditionalAgreementService.class);
    OrderService orderService = (OrderService)((ClientContext)this.getContext()).getPort(OrderService.class);
    private boolean altButtotPressed = false;

    public void setCopyId(int id) {
        this.copyId = id;
    }

    public void setModuleData(String module, int mid, int cid) {
        if (Utils.isEmptyString((String)this.module) || this.mid == -1 || this.cid == -1) {
            this.module = module;
            this.mid = mid;
            this.cid = cid;
        }
    }

    public AdditionalAgreementPanel() {
        this.additionalAgreementTableModel = new BGTableModel<AdditionalAgreement>("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b"){

            protected void initColumns() {
                int w = 100;
                this.addColumnId();
                this.addColumn("\u041a\u043e\u043f\u0438\u044f (ID)", w, w, w, "copyId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 (ID)", w, w, w, "documentId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u0421\u0447\u0435\u0442 (ID)", w, w, w, "billId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u0420\u0430\u0441\u0445\u043e\u0434 (ID)", w, w, w, "chargeId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u0410\u043a\u0442 (ID)", w, w, w, "invoiceId", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                this.addColumn("\u0414\u0430\u0442\u0430", 120, 120, 120, "date", true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
                this.addColumn("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", 50, 150, -1, "agreementNumber", true);
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "status", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
                this.addColumn("\u0421\u0443\u043c\u043c\u0430 \u043a \u043e\u043f\u043b\u0430\u0442\u0435", 150, 150, 150, "sum", true).setTableCellRenderer(DecimalTableCellRenderer.DEFAULT);
            }

            public Object getValue(AdditionalAgreement val, int column) throws BGException {
                String identifier = this.getIdentifier(column);
                if ("agreementNumber".equals(identifier)) {
                    if (val.getAgreementNumber() == 0) {
                        return "\u0414\u043e\u0433\u043e\u0432\u043e\u0440";
                    }
                    if (val.getAgreementNumber() > 0) {
                        return "\u0414\u043e\u043f. \u0441\u043e\u0433\u043b. \u2116" + val.getAgreementNumber();
                    }
                    return val.getAgreementNumber();
                }
                if ("status".equals(identifier)) {
                    return val.getStatus() == 0 ? "\u041d\u043e\u0432\u043e\u0435" : "\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043e";
                }
                return super.getValue((Object)val, column);
            }
        };
        this.additionalAgreementBgTable = new BGUTable(this.additionalAgreementTableModel);
    }

    public void jbInit() {
        this.additionalAgreementBgTable.setModel(this.additionalAgreementTableModel);
        this.additionalAgreementBgTable.setDefaultRenderer(BigDecimal.class, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT.get());
        this.setLayout(new GridBagLayout());
        this.add(this.getListPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getInformationPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.additionalAgreementBgTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow() != null) {
                    int indexPrevious = AdditionalAgreementPanel.this.additionalAgreementTableModel.getRows().indexOf(AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow()) - 1;
                    HashMap<String, Integer> mapPrevious = null;
                    if (indexPrevious > -1) {
                        List listSpecificationPrevious = ((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getRows().get(indexPrevious)).getSpecification();
                        mapPrevious = new HashMap<String, Integer>();
                        for (int i = 0; i < listSpecificationPrevious.size(); ++i) {
                            mapPrevious.put(((SpecificationTitle)listSpecificationPrevious.get(i)).getName(), ((SpecificationTitle)listSpecificationPrevious.get(i)).getCount());
                        }
                    }
                    ArrayList<KeyValue> model = new ArrayList<KeyValue>();
                    if (((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow()).getSpecification() != null) {
                        for (SpecificationTitle sp : ((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow()).getSpecification()) {
                            int difference;
                            KeyValue element = new KeyValue();
                            if (sp.getCount() == 0) {
                                element.setValue((Object)"\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e");
                                if (mapPrevious != null) {
                                    if (mapPrevious.get(sp.getName()) != null) {
                                        difference = sp.getCount() - (Integer)mapPrevious.get(sp.getName());
                                        if (difference != 0) {
                                            element.setValue((Object)("\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e(" + difference + ")"));
                                        }
                                    } else {
                                        element.setValue((Object)"\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e(new)");
                                    }
                                }
                            } else {
                                element.setValue((Object)String.valueOf(sp.getCount()));
                                if (mapPrevious != null) {
                                    if (mapPrevious.get(sp.getName()) != null) {
                                        difference = sp.getCount() - (Integer)mapPrevious.get(sp.getName());
                                        if (difference != 0) {
                                            element.setValue((Object)(String.valueOf(sp.getCount()) + "(" + difference + ")"));
                                        }
                                    } else {
                                        element.setValue((Object)(String.valueOf(sp.getCount()) + "(new)"));
                                    }
                                }
                            }
                            element.setKey((Comparable)((Object)sp.getName()));
                            model.add(element);
                        }
                        AdditionalAgreementPanel.this.informationModel.setData(model);
                    }
                }
            }
        });
        final JMenuItem sign = new JMenuItem("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c");
        this.popupMenu.add(sign);
        this.additionalAgreementBgTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3 && AdditionalAgreementPanel.this.additionalAgreementBgTable.getSelectedRow() != -1) {
                    if (((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow()).getStatus() == 1) {
                        sign.setText("\u0423\u0436\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d");
                        sign.setForeground(Color.GRAY);
                        sign.setFont(AdditionalAgreementPanel.this.getFont().deriveFont(2));
                    } else {
                        sign.setForeground(Color.BLACK);
                        sign.setFont(AdditionalAgreementPanel.this.getFont().deriveFont(0));
                        sign.setText("\u041f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c");
                    }
                    AdditionalAgreementPanel.this.popupMenu.show((Component)AdditionalAgreementPanel.this.additionalAgreementBgTable, e.getX(), e.getY());
                }
                super.mousePressed(e);
            }
        });
        sign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow()).getStatus() != 1 && ClientUtils.confirm((String)"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b ,\u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442?", (String)"")) {
                    AdditionalAgreementPanel.this.setStatus.perform();
                    AdditionalAgreementPanel.this.refresh.perform();
                }
            }
        });
    }

    private JPanel getListPanel() {
        JPanel listPanel = new JPanel(new GridBagLayout());
        BGButton createAgreementButton = new BGButton((Action)this.getNewAdditionalAgreement);
        BGButton deleteAgreementButton = new BGButton((Action)this.deleteAdditionalAgreement);
        listPanel.setBorder(new TitledBorder("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b"));
        listPanel.add((Component)createAgreementButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.add((Component)deleteAgreementButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.add((Component)new JScrollPane((Component)this.additionalAgreementBgTable), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        createAgreementButton.setBorderPainted(false);
        deleteAgreementButton.setBorderPainted(false);
        deleteAgreementButton.setToolTipText("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.");
        this.discountField.setToolTipText("\u0421\u043a\u0438\u0434\u043a\u0430");
        this.numberField.setToolTipText("\u041d\u043e\u043c\u0435\u0440");
        return listPanel;
    }

    private JPanel getInformationPanel() {
        this.informationModel = new InformationModelTableModel("InformationModelTableModel");
        LicenceBGUTable informationTable = new LicenceBGUTable((TableModel)((Object)this.informationModel), new String[]{"value"});
        JPanel informationPanel = new JPanel(new GridBagLayout());
        informationPanel.setBorder(new TitledBorder("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f"));
        informationPanel.add((Component)new JScrollPane((Component)((Object)informationTable)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return informationPanel;
    }

    private List<SpecificationTitle> getSpecificationList(int copyId, boolean onlyPerformed, boolean showErrorMessaege) throws BGException {
        List orderList = this.service.getPermanentOrder(copyId, onlyPerformed);
        if (orderList.size() == 0) {
            if (!onlyPerformed && showErrorMessaege) {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435\u043c \u0434\u043e\u043f. \u0441\u043e\u0433\u043b. \u0434\u043e\u0431\u0430\u0432\u044c\u0442\u0435 \u0437\u0430\u043a\u0430\u0437!");
            }
            return null;
        }
        return OrderUtils.getSpecificationList((List)orderList, (boolean)showErrorMessaege);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BigDecimal getSum(List<SpecificationTitle> specificationList, int copyId) throws BGException {
        List<SpecificationTitle> specificationListOnlyPerformed;
        BigDecimal onlyPerformedCost;
        BigDecimal resultCostOnlyPerformed;
        BigDecimal resultCost = null;
        if (specificationList == null) return resultCost;
        BigDecimal presentCost = this.service.getCostComponents(specificationList, copyId);
        if (this.additionalAgreementTableModel.getRowCount() > 0) {
            int idPreviousTitle = ((AdditionalAgreement)this.additionalAgreementTableModel.getRows().get(this.additionalAgreementTableModel.getRowCount() - 1)).getId();
            List spL = this.service.getSpecificationOfAdditionalAgreement(idPreviousTitle);
            BigDecimal previousCost = this.service.getCostComponents(spL, copyId);
            resultCost = presentCost.subtract(previousCost);
            if (this.altButtotPressed || resultCost.compareTo(BigDecimal.ZERO) < 1) {
                if (!this.altButtotPressed && !ClientUtils.confirm((String)("\u0412\u0430\u0448\u0430 \u0441\u0443\u043c\u043c\u0430 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430 (" + resultCost + "). \u0425\u043e\u0442\u0438\u0442\u0435 \u0432\u0432\u0435\u0441\u0442\u0438 \u0441\u0432\u043e\u044e \u0441\u0443\u043c\u043c\u0443?"), (String)"\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430")) return null;
                String enteredSum = JOptionPane.showInputDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0443\u043c\u043c\u0443");
                if (enteredSum == null) {
                    return null;
                }
                resultCost = Utils.parseBigDecimal((String)enteredSum, (BigDecimal)BigDecimal.ZERO);
                if (resultCost == BigDecimal.ZERO) {
                    throw new BGMessageException("\u0412\u044b \u0432\u0432\u0435\u043b\u0438 \u043d\u0435\u0447\u0438\u0442\u0430\u0435\u043c\u0443\u044e \u0444\u0438\u0433\u043d\u044e. \u0412 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0440\u0430\u0437 \u043f\u043e\u0432\u0435\u0437\u0435\u0442 \u0431\u043e\u043b\u044c\u0448\u0435.");
                }
                if (resultCost.compareTo(BigDecimal.ZERO) < 1) {
                    throw new BGMessageException("\u041d\u0443 \u043a\u0430\u043a \u0432\u044b \u043c\u043e\u0433\u043b\u0438 \u0432\u0432\u0435\u0441\u0442\u0438 \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0443\u044e/\u043d\u0443\u043b\u0435\u0432\u0443\u044e \u0441\u0443\u043c\u043c\u0443???");
                }
            }
        } else {
            BigDecimal discount = Utils.parseBigDecimal((String)this.discountField.getText(), (BigDecimal)BigDecimal.valueOf(-1L));
            if (discount.compareTo(BigDecimal.valueOf(-1L)) == 0) {
                throw new BGMessageException("\u0421\u043a\u0438\u0434\u043a\u0430 \u043d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u0430, \u043b\u0438\u0431\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.");
            }
            this.setDiscount.perform();
            BigDecimal realCost = this.service.getCostComponents(specificationList, copyId);
            resultCost = realCost.subtract(discount);
            if (resultCost.compareTo(BigDecimal.ZERO) == -1) {
                throw new BGMessageException("\u0423 \u0432\u0430\u0441 \u0441\u043a\u0438\u0434\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u0440\u0435\u0430\u043b\u044c\u043d\u0443\u044e \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c. \u0412\u044b \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u043c \u0441\u0430\u043c\u0438 \u0437\u0430\u043f\u043b\u0430\u0442\u0438\u0442\u044c?");
            }
        }
        if ((resultCostOnlyPerformed = presentCost.subtract(onlyPerformedCost = this.service.getCostComponents(specificationListOnlyPerformed = this.getSpecificationList(copyId, true, true), copyId))).compareTo(resultCost) == 0) return resultCost;
        int optionSelected = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0445 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \u041d\u043e\u0432\u044b\u0439 = " + resultCostOnlyPerformed.toString() + ",\n\u0430 \u0441\u0443\u043c\u043c\u0430 \u043f\u043e\u0441\u0447\u0438\u0442\u0430\u043d\u0430\u044f \u043a\u0430\u043a \u0440\u0430\u0437\u043d\u0438\u0446\u0430 \u0441\u0443\u043c\u043c\u044b \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e = " + resultCost.toString() + ".\n\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0443\u043c\u043c\u0443 ???", "\u0421\u0443\u043c\u043c\u044b \u043d\u0435 \u0440\u0430\u0432\u043d\u044b", 1);
        if (optionSelected == 0) {
            return resultCostOnlyPerformed;
        }
        if (optionSelected != 2) return resultCost;
        return null;
    }

    private int getNumber() throws BGException {
        int num = this.service.getLastNumber(this.cid);
        if (num > -1) {
            return num + 1;
        }
        if (!this.numberField.getText().equals(NUMBERTEXT) && Utils.parseInt((String)this.numberField.getText(), (int)-1) != -1) {
            if (Utils.parseInt((String)this.numberField.getText()) < 1) {
                throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 1. \u0412\u043f\u0438\u0448\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440.");
            }
            return Utils.parseInt((String)this.numberField.getText());
        }
        throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043d\u0430\u0447\u043d\u0443\u0442\u0441\u044f \u0434\u043e\u043f.\u0441\u043e\u0433. \u043d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d, \u043b\u0438\u0431\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e.");
    }

    protected void initActions() {
        this.refresh = new AbstractBGUPanel.DefaultAction("refresh", "X"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                AdditionalAgreementPanel.this.informationModel.setData(new ArrayList());
                List list = AdditionalAgreementPanel.this.service.getList(AdditionalAgreementPanel.this.cid, AdditionalAgreementPanel.this.copyId);
                AdditionalAgreementPanel.this.additionalAgreementTableModel.setData(list);
            }
        };
        this.setDiscount = new AbstractBGUPanel.DefaultAction("setDiscount", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BigDecimal discount = Utils.parseBigDecimal((String)AdditionalAgreementPanel.this.discountField.getText(), (BigDecimal)BigDecimal.ZERO);
                AdditionalAgreementPanel.this.service.setDiscount(discount, AdditionalAgreementPanel.this.cid, AdditionalAgreementPanel.this.copyId);
            }
        };
        this.getNewAdditionalAgreement = new AbstractBGUPanel.DefaultAction("getNewAdditionalAgreement", "", ClientUtils.getIcon((String)"item_add")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                boolean bl = AdditionalAgreementPanel.this.altButtotPressed = (e.getModifiers() & 8) != 0;
                if (AdditionalAgreementPanel.this.additionalAgreementTableModel.getRowCount() > 0) {
                    AdditionalAgreementPanel.this.createNewAdditionalAgreement(0);
                } else {
                    AdditionalAgreementPanel.this.showDocumentSelectionDialog();
                }
            }
        };
        this.deleteAdditionalAgreement = new AbstractBGUPanel.DefaultAction("getNewAdditionalAgreement", "", ClientUtils.getIcon((String)"item_delete")){

            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442?", "", 0) == 0) {
                    AdditionalAgreementPanel.this.service.deleteAdditionalAgreement((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow(), AdditionalAgreementPanel.this.cid);
                    AdditionalAgreementPanel.this.refresh.perform();
                }
            }
        };
        this.setStatus = new AbstractBGUPanel.DefaultAction("setSatus", ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                AdditionalAgreementPanel.this.service.setStatusSigned((AdditionalAgreement)AdditionalAgreementPanel.this.additionalAgreementTableModel.getSelectedRow(), AdditionalAgreementPanel.this.cid, AdditionalAgreementPanel.this.copyId);
                EventBus.publish((Object)new UpdateContractTreeEvent(0, AdditionalAgreementPanel.this.cid));
                AdditionalAgreementPanel.this.refresh.perform();
            }
        };
    }

    private void createNewAdditionalAgreement(int typeDocument) throws BGException {
        int number;
        if (this.additionalAgreementTableModel.getRowCount() > 0 && ((AdditionalAgreement)this.additionalAgreementTableModel.getRows().get(this.additionalAgreementTableModel.getRowCount() - 1)).getStatus() != 1) {
            throw new BGMessageException("\u0414\u043b\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043d\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0448\u0438\u0442\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439.");
        }
        List<SpecificationTitle> specificationList = this.getSpecificationList(this.copyId, false, true);
        BigDecimal sum = this.getSum(specificationList, this.copyId);
        int n = number = typeDocument == 0 ? this.getNumber() : 0;
        if (specificationList == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0421\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 == null");
            return;
        }
        if (sum != null && number != -1 && specificationList != null) {
            AdditionalAgreement agreement = new AdditionalAgreement(0, this.copyId, number, new Date(), 0, sum, specificationList);
            this.service.createAdditionalAgreement(agreement, this.cid, typeDocument);
            this.refresh.perform();
        }
    }

    private void showDocumentSelectionDialog() {
        final BGDialog dialog = new BGDialog((ClientContext)this.getContext());
        JPanel panel = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton radioContract = new JRadioButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
        final JRadioButton radioAdditionalAgreement = new JRadioButton("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        buttonGroup.add(radioContract);
        buttonGroup.add(radioAdditionalAgreement);
        panel.add((Component)radioContract, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        final JPanel panelContract = new JPanel(new GridBagLayout());
        final JRadioButton radioFirstContract = new JRadioButton("\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u043e\u0435");
        final JRadioButton radioProlongation = new JRadioButton("\u041f\u0440\u043e\u043b\u043e\u043d\u0433\u0430\u0446\u0438\u044f");
        ButtonGroup contractGroup = new ButtonGroup();
        contractGroup.add(radioFirstContract);
        contractGroup.add(radioProlongation);
        final BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect(false, true, true, this.cid);
        final BGUComboBox comboBoxCopy = new BGUComboBox();
        panelContract.add((Component)radioFirstContract, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelContract.add((Component)radioProlongation, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelContract.add((Component)contractSelect, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 0, 10), 0, 0));
        panelContract.add((Component)comboBoxCopy, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 20, 0, 32), 0, 0));
        panel.add((Component)panelContract, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)radioAdditionalAgreement, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panelAdditionalAgreement = new JPanel(new GridBagLayout());
        panelAdditionalAgreement.add((Component)this.numberField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 35, 10, 10), 0, 0));
        panel.add((Component)panelAdditionalAgreement, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.discountField, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 15, 10, 10), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        panel.add((Component)okCancel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 15, 45), 0, 0));
        BGSwingUtilites.setEnabled((Component)panelContract, (boolean)false);
        this.turnOfOrOnComponent(false, new JTextComponent[]{this.numberField});
        this.numberField.setPromptText("\u041d\u043e\u043c\u0435\u0440", true, true);
        this.discountField.setPromptText("\u0421\u043a\u0438\u0434\u043a\u0430", true, false);
        comboBoxCopy.setVisible(false);
        radioContract.setActionCommand("contract");
        radioAdditionalAgreement.setActionCommand("additionalAgreement");
        radioFirstContract.setActionCommand("first");
        radioProlongation.setActionCommand("prolongation");
        ActionListener listenerRadio = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (e.getActionCommand()) {
                    case "contract": {
                        BGSwingUtilites.setEnabled((Component)panelContract, (boolean)true);
                        AdditionalAgreementPanel.this.turnOfOrOnComponent(false, new JTextComponent[]{AdditionalAgreementPanel.this.numberField});
                        if (radioProlongation.isSelected()) break;
                        BGSwingUtilites.setEnabled((Component)contractSelect, (boolean)false);
                        comboBoxCopy.setEnabled(false);
                        break;
                    }
                    case "additionalAgreement": {
                        BGSwingUtilites.setEnabled((Component)panelContract, (boolean)false);
                        AdditionalAgreementPanel.this.turnOfOrOnComponent(true, new JTextComponent[]{AdditionalAgreementPanel.this.numberField});
                        break;
                    }
                    case "first": {
                        BGSwingUtilites.setEnabled((Component)contractSelect, (boolean)false);
                        comboBoxCopy.setEnabled(false);
                        break;
                    }
                    case "prolongation": {
                        BGSwingUtilites.setEnabled((Component)contractSelect, (boolean)true);
                        comboBoxCopy.setEnabled(true);
                    }
                }
            }
        };
        radioContract.addActionListener(listenerRadio);
        radioAdditionalAgreement.addActionListener(listenerRadio);
        radioFirstContract.addActionListener(listenerRadio);
        radioProlongation.addActionListener(listenerRadio);
        contractSelect.addWindowListenerForDialog((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                int oldCid = Utils.parseInt((String)contractSelect.getContracts(), (int)-1);
                if (oldCid > 0) {
                    try {
                        comboBoxCopy.setData(((LicenseService)((ClientContext)AdditionalAgreementPanel.this.getContext()).getPort(LicenseService.class)).copyList(oldCid));
                        comboBoxCopy.setVisible(true);
                        dialog.pack();
                    }
                    catch (Exception e1) {
                        ((ClientContext)AdditionalAgreementPanel.this.getContext()).processException((Throwable)e1);
                    }
                } else {
                    comboBoxCopy.setVisible(false);
                }
            }
        });
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(BGButtonPanelOkCancel.OK.command)) {
                    try {
                        if (radioContract.isSelected()) {
                            if (radioFirstContract.isSelected()) {
                                AdditionalAgreementPanel.this.createNewAdditionalAgreement(-1);
                            } else if (radioProlongation.isSelected()) {
                                int oldCopyId;
                                int oldCid = Utils.parseInt((String)contractSelect.getContracts(), (int)-1);
                                int n = oldCopyId = comboBoxCopy.getSelectedItem() != null ? ((Copy)comboBoxCopy.getSelectedItem()).getId() : -1;
                                if (oldCid < 0) {
                                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0431\u044b\u043b \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440!");
                                    return;
                                }
                                if (oldCopyId < 0) {
                                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.\n\u041d\u0435 \u0432\u0435\u0440\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430!");
                                    return;
                                }
                                AdditionalAgreementPanel.this.createNewAdditionalAgreement(-1);
                            }
                        } else if (radioAdditionalAgreement.isSelected()) {
                            AdditionalAgreementPanel.this.createNewAdditionalAgreement(0);
                        }
                    }
                    catch (Exception e1) {
                        ((ClientContext)AdditionalAgreementPanel.this.getContext()).processException((Throwable)e1);
                    }
                }
                dialog.dispose();
                BGSwingUtilites.setEnabled((Component)panelContract, (boolean)false);
                AdditionalAgreementPanel.this.turnOfOrOnComponent(false, new JTextComponent[]{AdditionalAgreementPanel.this.numberField});
                radioAdditionalAgreement.setSelected(false);
                radioContract.setSelected(false);
                radioFirstContract.setSelected(false);
                radioProlongation.setSelected(false);
            }
        });
        comboBoxCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int oldCid = Utils.parseInt((String)contractSelect.getContracts(), (int)-1);
                    int oldCopyId = comboBoxCopy.getSelectedItem() != null ? ((Copy)comboBoxCopy.getSelectedItem()).getId() : -1;
                    AdditionalAgreementPanel.this.discountField.setText("0");
                    if (oldCid > 0 && oldCopyId > 0) {
                        List<SpecificationTitle> specificationList = AdditionalAgreementPanel.this.getSpecificationList(oldCopyId, true, false);
                        if (specificationList.size() < 1) {
                            return;
                        }
                        BigDecimal sum = AdditionalAgreementPanel.this.service.getCostComponents(specificationList, oldCopyId);
                        AdditionalAgreementPanel.this.discountField.setText(Utils.formatCost((BigDecimal)(sum != null ? sum : BigDecimal.ZERO)));
                    }
                }
                catch (Exception e1) {
                    ((ClientContext)AdditionalAgreementPanel.this.getContext()).processException((Throwable)e1);
                }
            }
        });
        dialog.add((Component)panel);
        dialog.setModal(true);
        dialog.pack();
        dialog.moveWindowToCenterScreen();
        dialog.showDialog();
    }

    private void turnOfOrOnComponent(boolean state, JTextComponent ... component) {
        for (JTextComponent c : component) {
            c.setEnabled(state);
            c.setEditable(state);
        }
    }

    public static List<SpecificationTitle> mergeSpecificationLists(List<SpecificationTitle> list1, List<SpecificationTitle> list2) {
        List<SpecificationTitle> listR = list1;
        for (SpecificationTitle spec : list2) {
            if (listR.contains(spec)) {
                if (spec.getCount() == 0) {
                    listR.get(listR.indexOf(spec)).setCount(0);
                    continue;
                }
                if (listR.get(listR.indexOf(spec)).getCount() == 0) continue;
                listR.get(listR.indexOf(spec)).setCount(listR.get(listR.indexOf(spec)).getCount() + spec.getCount());
                continue;
            }
            listR.add(spec);
        }
        return listR;
    }

    class InformationModelTableModel
    extends BGTableModel<KeyValue<String, String>> {
        public InformationModelTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u2116", Integer.class, 80, 80, 80, "n", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "key", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e", 200, 200, 200, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
        }

        public Object getValue(KeyValue<String, String> val, int column) {
            String identifier = this.getIdentifier(column);
            if ("n".equals(identifier)) {
                return this.getRows().indexOf(val) + 1;
            }
            if ("key".equals(identifier)) {
                return val.getKey();
            }
            if ("value".equals(identifier)) {
                return val.getValue();
            }
            return null;
        }
    }
}

