/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderType;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;

public class OrderUtils {
    public static final String TYPE_TEST_TEXT = "\u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439";
    public static final String TYPE_BUY_TEXT = "\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439";
    public static final String STATUS_NEW_TEXT = "\u043d\u043e\u0432\u044b\u0439";
    public static final String STATUS_EXECUTED_TEXT = "\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d";
    public static final String STATUS_CONFIRMED_TEXT = "\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d";
    public static final String STATUS_DENIED_TEXT = "\u043e\u0442\u043a\u0430\u0437\u0430\u043d\u043e";
    public static final String NO_TERM_TEXT = "-";
    public static final String NO_COUNT_TEXT = "-";
    public static final String COUNT_UNLIMITED_TEXT = "\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e";

    public static String getType(OrderType orderType) {
        String type = new String();
        if (orderType == OrderType.TEST) {
            type = TYPE_TEST_TEXT;
        } else if (orderType == OrderType.BUY) {
            type = TYPE_BUY_TEXT;
        }
        return type;
    }

    public static String getTerm(int term) {
        return " (" + new DecimalFormat("###,###,###,###").format(term) + ")";
    }

    public static String getCount(Integer itemCount) {
        String count = itemCount == null ? "0" : (itemCount == 0 ? COUNT_UNLIMITED_TEXT : String.valueOf(itemCount));
        return count;
    }

    public static String getStatus(int statusIndex) {
        String status = new String();
        if (statusIndex == 0) {
            status = STATUS_NEW_TEXT;
        } else if (statusIndex == 2) {
            status = STATUS_EXECUTED_TEXT;
        } else if (statusIndex == 3) {
            status = STATUS_CONFIRMED_TEXT;
        } else if (statusIndex == 1) {
            status = STATUS_DENIED_TEXT;
        }
        return status;
    }

    public static List<SpecificationTitle> getSpecificationList(List<Order> orderList, boolean showErrorMessaege) {
        ArrayList<SpecificationTitle> specificationList = new ArrayList<SpecificationTitle>();
        List<Order> list = OrderUtils.getTotalOrderList(orderList, showErrorMessaege);
        if (list == null) {
            return null;
        }
        for (Order order : list) {
            specificationList.add(new SpecificationTitle(order.getCount(), order.getComponentName()));
        }
        return specificationList;
    }

    public static List<Order> getTotalOrderList(List<Order> list, boolean showMessage) {
        ArrayList<Order> listR = new ArrayList<Order>();
        Collections.reverse(list);
        for (Order order : list) {
            if (listR.contains(order)) {
                if (order.getCount() == 0) {
                    listR.get(listR.indexOf(order)).setCount(0);
                    continue;
                }
                if (listR.get(listR.indexOf(order)).getCount() == 0) {
                    if (showMessage) {
                        String text = "\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 " + order.getComponentName() + " \u0443\u0436\u0435 \u0431\u044b\u043b \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u043c,\n\u043e\u0434\u043d\u0430\u043a\u043e \u043f\u043e\u0441\u043b\u0435 \u0435\u0441\u0442\u044c \u0435\u0449\u0435 \u0437\u0430\u043a\u0430\u0437\u044b \u043d\u0430 \u044d\u0442\u043e\u0442 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442.\n\u0415\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u0439\u0442\u0438 \u0441 \u0431\u0435\u0437\u043b\u0438\u043c\u0438\u0442\u043a\u0438,\n\u0432\u044b\u0441\u0442\u0430\u0432\u044c\u0442\u0435 \u0443 \u043d\u0435\u0435 \u0441\u0442\u0430\u0442\u0443\u0441 \"\u041e\u0442\u043a\u0430\u0437\u0430\u043d\u043e\".";
                        ClientUtils.showErrorMessageDialog((String)text);
                    }
                    return null;
                }
                listR.get(listR.indexOf(order)).setCount(listR.get(listR.indexOf(order)).getCount() + order.getCount());
                continue;
            }
            listR.add(order);
        }
        return listR;
    }
}

