/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrListDao;

class EntityAttrListCustomDao
extends EntityAttrListDao {
    private String listValueTable;

    public EntityAttrListCustomDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String listTable, String listValueTable) {
        super(con, entityAttrDao, listTable, listValueTable);
        this.listValueTable = listValueTable;
    }

    @Override
    protected void createTable() {
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title, v.custom_value FROM " + this.table + " as v LEFT JOIN " + this.listValueTable + " as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        selectPS.setInt(1, entityId);
        selectPS.setInt(2, entitySpecAttrId);
        return selectPS;
    }

    @Override
    public EntityAttrList get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrList result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrList(entityId, attrSpecId, rs.getInt(1), rs.getString(2));
                result.setCustomValue(rs.getString(3));
            }
        }
        return result;
    }

    @Override
    protected PreparedStatement getInsertPS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.table + " (" + this.idName() + ", " + this.typeName() + ", " + this.valueName() + ", custom_value) VALUES (?, ?, ?, ?)");
        insertPS.setInt(1, entityId);
        insertPS.setInt(2, entitySpecAttrId);
        return insertPS;
    }

    @Override
    protected PreparedStatement getUpdatePS(int entityId, int entitySpecAttrId) throws SQLException {
        PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.table + " SET " + this.valueName() + "=?, custom_value=? WHERE " + this.idName() + "=? AND " + this.typeName() + "=? AND (@oldValue:=" + this.valueName() + ") IS NOT NULL");
        updatePS.setInt(3, entityId);
        updatePS.setInt(4, entitySpecAttrId);
        return updatePS;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        EntityAttrList attr = (EntityAttrList)a;
        if (attr.getValue() <= 0 && Utils.isBlankString((String)attr.getCustomValue())) {
            return;
        }
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setInt(3, attr.getValue());
            ps.setString(4, attr.getCustomValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrList attr) throws SQLException {
        if (attr.getValue() <= 0 && Utils.isBlankString((String)attr.getCustomValue())) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setInt(1, attr.getValue());
            ps.setString(2, Utils.maskNull((String)attr.getCustomValue()));
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setInt(3, attr.getValue());
                ps.setString(4, Utils.maskNull((String)attr.getCustomValue()));
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        int oldValue = 0;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getInt(1);
            }
        }
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrList attr) throws SQLException {
        String title = attr != null ? (attr.getValue() <= 0 ? attr.getCustomValue() : attr.getTitle()) : null;
        try (PreparedStatement insertHistoryPS = this.con.prepareStatement("INSERT INTO " + this.table + "_log SET  " + this.idName() + "=?, " + this.typeName() + "=?, val=?, title=?, dt_change=?, user_id=?");){
            insertHistoryPS.setInt(1, cid);
            insertHistoryPS.setInt(2, attr.getEntitySpecAttrId());
            insertHistoryPS.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
            insertHistoryPS.setString(4, title);
            insertHistoryPS.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            insertHistoryPS.setInt(6, this.entityAttrDao.userId);
            insertHistoryPS.executeUpdate();
        }
    }
}

