/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client;

import bitel.billing.module.common.BGFileFilter;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.json.JSONArray;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.tariff.client.TariffLabelTree;
import ru.bitel.bgbilling.kernel.tariff.client.TariffPanel;
import ru.bitel.bgbilling.kernel.tariff.client.TariffVarsPanel;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlanData;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffLabelService;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class TariffPanelEditor
extends BGUPanel {
    private static final String TARIFF_EDITOR = "editor";
    public static final String TAB_ID = "newTariffPlanEditor";
    private TariffTree tree;
    private TariffPanel tariffPanel;
    private boolean init = false;
    private int currentFace = 0;
    private int tariffPlanId = 0;
    private JTextField tariffPlanTitleInGUI = new JTextField();
    private JTextField tariffPlanTitleInWEB = new JTextField();
    private JCheckBox isUsedCheckBox = new JCheckBox("\u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
    private JCheckBox isWebCheckBox = new JCheckBox("\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430");
    private JButton physButton = new JButton("\u0424\u0438\u0437\u0438\u0447.");
    private JButton urButton = new JButton("\u042e\u0440\u0438\u0434\u0438\u0447.");
    private JButton allFaceButton = new JButton("\u041b\u044e\u0431\u043e\u0435");
    private BGTextField maskText = new BGTextField();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private JTextArea comment = new JTextArea();
    private CardLayout cardLayout1 = new CardLayout();
    private CardLayout cardLayout2 = new CardLayout();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel treePanel = new JPanel(new GridBagLayout());
    private JPanel cardPanel = new JPanel(this.cardLayout1);
    private JPanel treePanelContainer = new JPanel(this.cardLayout2);
    private TariffVarsPanel tariffVarsPanel = new TariffVarsPanel();
    private TariffLabelTree tariffLabelTree = new TariffLabelTree();
    private ContractLabelTree contractLabelTree = new ContractLabelTree();
    private TariffService tariffService = null;
    AbstractBGUPanel.DefaultAction ok = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){
        {
            this.putValue("ShortDescription", "<html>\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f, <b>\u043d\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435</b> \u0441 \u0434\u0435\u0440\u0435\u0432\u043e\u043c \u0442\u0430\u0440\u0438\u0444\u0430</html>");
        }

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.updateTariff();
        }
    };
    AbstractBGUPanel.DefaultAction flush = new AbstractBGUPanel.DefaultAction("ok.flush", "\u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445"){
        {
            this.putValue("ShortDescription", "<html>\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0434\u0435\u0440\u0435\u0432\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u044f\u044e\u0442\u0441\u044f <b>\u043d\u0435\u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e</b>, \u043e\u0434\u043d\u0430\u043a\u043e \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438<br/>\u043f\u043e\u0441\u043b\u0435 \u043f\u0440\u0430\u0432\u043a\u0438 \u0434\u0435\u0440\u0435\u0432\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \"\u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445\"</html>");
        }

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.tree.flush();
        }
    };
    AbstractBGUPanel.DefaultAction close = new AbstractBGUPanel.DefaultAction("close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TariffPanelEditor.this.tree != null && TariffPanelEditor.this.tree.isNeedFlush()) {
                int result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0422\u0430\u0440\u0438\u0444\u043d\u043e\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e. \u041e\u043f\u043e\u0432\u0435\u0441\u0442\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f\u0445?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                switch (result) {
                    case 0: {
                        TariffPanelEditor.this.flush.perform();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            TariffPanelEditor.this.tariffPanel.setData();
            this.getParentAction().actionPerformed(e);
        }
    };
    AbstractBGUPanel.DefaultAction export = new AbstractBGUPanel.DefaultAction("left.export", "\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPanelEditor.this.exportTariff();
        }
    };
    AbstractBGUPanel.DefaultAction newItem = new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            TariffPlan tariffPlan = new TariffPlan();
            tariffPlan.setTitle("New tariff plan");
            tariffPlan.setUsed(true);
            TariffPanelEditor.this.tariffPlanId = TariffPanelEditor.this.getTariffService().tariffPlanUpdate(tariffPlan);
            TariffPanelEditor.this.tariffPanel.setData();
            TariffPanelEditor.this.tariffPanel.tariffModel.setSelectedRows(new HashSet<Integer>(){
                {
                    this.add(TariffPanelEditor.this.tariffPlanId);
                }
            });
            TariffPanelEditor.this.showTariffEditor();
            TariffPanelEditor.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction copyItem = new AbstractBGUPanel.DefaultAction("copy", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TariffPanelEditor.this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            int ans = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0, 3);
            if (ans == 1) {
                return;
            }
            int sourceTariffPlanId = ((TariffPlanData)((Object)TariffPanelEditor.this.tariffPanel.tariffModel.getSelectedRow())).getId();
            Request request = new Request();
            request.setModule(((ClientContext)TariffPanelEditor.this.getContext()).getModule());
            request.setAction("CopyTariffPlan");
            request.setAttribute("tpid", sourceTariffPlanId);
            ClientSetup.getInstance().putObject("data", (Object)request);
            org.w3c.dom.Document doc = ((ClientContext)TariffPanelEditor.this.getContext()).getDocument(request);
            Element tariffPlan = XMLUtils.selectElement((Node)doc, (String)"//tariffPlan");
            TariffPanelEditor.this.tariffPlanId = Utils.parseInt((String)XMLUtils.getAttribute((Element)tariffPlan, (String)"id", (String)"-1"));
            try {
                TariffLabelService tariffLabelService = (TariffLabelService)((ClientContext)TariffPanelEditor.this.getContext()).getPort(TariffLabelService.class);
                List<TariffLabelItem> items = tariffLabelService.getTariffLabelTreeItemList(sourceTariffPlanId);
                ArrayList<TariffLabelItem> selectedItems = new ArrayList<TariffLabelItem>();
                for (TariffLabelItem tariffLabelItem : items) {
                    if (!tariffLabelItem.isSelected()) continue;
                    selectedItems.add(tariffLabelItem);
                }
                tariffLabelService.setTariffLabelTreeItemList(TariffPanelEditor.this.tariffPlanId, selectedItems);
                TariffPanelEditor.this.tariffPanel.labelPanel.updateFilterLabelTreeData(tariffLabelService.getTariffLabelTreeItemList(-1));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            TariffPanelEditor.this.tariffPanel.setData();
            TariffPanelEditor.this.tariffPanel.tariffModel.setSelectedRows(new HashSet<Integer>(){
                {
                    this.add(TariffPanelEditor.this.tariffPlanId);
                }
            });
            TariffPanelEditor.this.showTariffEditor();
            TariffPanelEditor.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction editItem = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TariffPanelEditor.this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            TariffPanelEditor.this.tariffPlanId = ((TariffPlanData)((Object)TariffPanelEditor.this.tariffPanel.tariffModel.getSelectedRow())).getId();
            TariffPanelEditor.this.showTariffEditor();
            TariffPanelEditor.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction deleteItem = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TariffPanelEditor.this.isShowing()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            if (TariffPanelEditor.this.tariffPanel.tariffTable.getSelectedRow() < 0) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043b\u0430\u043d \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                return;
            }
            if (!ClientUtils.confirmDelete((Object)((TariffPlanData)((Object)TariffPanelEditor.this.tariffPanel.tariffModel.getSelectedRow())).getTitle())) {
                return;
            }
            int sourceTariffPlanId = ((TariffPlanData)((Object)TariffPanelEditor.this.tariffPanel.tariffModel.getSelectedRow())).getId();
            Request request = new Request();
            request.setModule(((ClientContext)TariffPanelEditor.this.getContext()).getModule());
            request.setAction("DeleteTariffPlan");
            request.setAttribute("tpid", sourceTariffPlanId);
            ClientUtils.checkStatus((org.w3c.dom.Document)((ClientContext)TariffPanelEditor.this.getContext()).getDocument(request));
            try {
                TariffLabelService tariffLabelService = (TariffLabelService)((ClientContext)TariffPanelEditor.this.getContext()).getPort(TariffLabelService.class);
                tariffLabelService.setTariffLabelTreeItemList(sourceTariffPlanId, null);
                TariffPanelEditor.this.tariffPanel.labelPanel.updateFilterLabelTreeData(tariffLabelService.getTariffLabelTreeItemList(-1));
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            TariffPanelEditor.this.tariffPanel.setData();
        }
    };

    public TariffPanelEditor(TariffPanel tariffPanel) {
        super(tariffPanel.getContext());
        this.tariffPanel = tariffPanel;
        this.build();
        this.tariffLabelTree.setPopupMenu(tariffPanel.labelPanel.popupFilterMenu);
    }

    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0430\u0440\u0438\u0444\u0430");
        this.init = false;
        this.isWebCheckBox.addChangeListener(e -> this.tariffPlanTitleInWEB.setEnabled(!this.isWebCheckBox.getModel().isSelected()));
        JPanel titlePanelGUI = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)titlePanelGUI, (String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
        this.tariffPlanTitleInWEB.setToolTipText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430");
        titlePanelGUI.add((Component)this.tariffPlanTitleInGUI, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        titlePanelGUI.add((Component)this.isUsedCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.isUsedCheckBox.setToolTipText("\u0424\u043b\u0430\u0433 \u0442\u043e\u0433\u043e, \u0447\u0442\u043e \u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        JPanel titlePanelWEB = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)titlePanelWEB, (String)"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435");
        this.tariffPlanTitleInWEB.setToolTipText("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0432 \u043b\u0438\u0447\u043d\u043e\u043c \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0435");
        titlePanelWEB.add((Component)this.tariffPlanTitleInWEB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        titlePanelWEB.add((Component)this.isWebCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.isWebCheckBox.setToolTipText("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0434\u043b\u044f \u043b\u0438\u0447\u043d\u043e\u0433\u043e \u043a\u0430\u0431\u0438\u043d\u0435\u0442\u0430");
        this.tariffPlanTitleInGUI.getDocument().addDocumentListener(new RepeatDocumentListener());
        this.physButton = new JButton("\u0424\u0438\u0437\u0438\u0447.");
        this.physButton.addActionListener(e -> {
            this.currentFace = 1;
            this.physButton.setBackground(Color.GRAY);
            this.urButton.setBackground(Color.lightGray);
            this.allFaceButton.setBackground(Color.lightGray);
        });
        this.urButton = new JButton("\u042e\u0440\u0438\u0434\u0438\u0447.");
        this.urButton.addActionListener(e -> {
            this.currentFace = 2;
            this.physButton.setBackground(Color.lightGray);
            this.urButton.setBackground(Color.GRAY);
            this.allFaceButton.setBackground(Color.lightGray);
        });
        this.allFaceButton = new JButton("\u041b\u044e\u0431\u043e\u0435");
        this.allFaceButton.addActionListener(e -> {
            this.currentFace = 0;
            this.physButton.setBackground(Color.lightGray);
            this.urButton.setBackground(Color.lightGray);
            this.allFaceButton.setBackground(Color.GRAY);
        });
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)new JScrollPane(this.tariffLabelTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)new JScrollPane((Component)this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add((Component)this.getContractFilterPanel(), "\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");
        tabPane.add((Component)labelPanel, "\u041c\u0435\u0442\u043a\u0438");
        tabPane.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        JPanel preferencesPanel = new JPanel(new GridBagLayout());
        preferencesPanel.add((Component)titlePanelGUI, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)titlePanelWEB, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)this.getCommentPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 3, 3), 0, 0));
        preferencesPanel.add((Component)tabPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 3, 3), 0, 0));
        this.treePanelContainer.add((Component)this.treePanel, "tree");
        this.treePanelContainer.add((Component)new JPanel(), "nothing");
        this.tabbedPane.add("\u0414\u0435\u0440\u0435\u0432\u043e", this.treePanelContainer);
        this.tabbedPane.add("\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435", (Component)((Object)this.tariffVarsPanel));
        BGSplitPaneNoBorder mainTab = new BGSplitPaneNoBorder(1, (Component)preferencesPanel, (Component)this.tabbedPane, 400L);
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.add((Component)mainTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.cardPanel.add((Component)editorPanel, TARIFF_EDITOR);
        this.setLayout(new GridBagLayout());
        this.add(this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getCommentPanel() {
        this.comment.setLineWrap(true);
        Dimension dimension = new Dimension(200, 100);
        JScrollPane commentScrollPane = new JScrollPane(this.comment);
        commentScrollPane.setMinimumSize(dimension);
        commentScrollPane.setPreferredSize(dimension);
        commentScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapBorder((JPanel)panel, (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        panel.add((Component)commentScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractFilterPanel() {
        JPanel fizYurPanel = new JPanel();
        fizYurPanel.setLayout(new GridBagLayout());
        fizYurPanel.setBorder((Border)new BGTitleBorder(" \u041b\u0438\u0446\u043e "));
        fizYurPanel.add((Component)this.allFaceButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
        fizYurPanel.add((Component)this.physButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
        fizYurPanel.add((Component)this.urButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 3, 3), 0, 0));
        JScrollPane scrollPane = new JScrollPane(this.contractLabelTree);
        scrollPane.setBorder((Border)new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        this.fillTable();
        this.maskText.setEditable(true);
        this.maskText.setOpaque(true);
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBorder((Border)new BGTitleBorder(" \u041c\u0430\u0441\u043a\u0430 "));
        textPanel.add((Component)this.maskText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)fizYurPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)textPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public boolean isNeedFlush() {
        return this.tree != null ? this.tree.isNeedFlush() : false;
    }

    public void setTariffPlanData() {
        if (this.tariffPlanId < 1) {
            return;
        }
        Request request = new Request();
        request.setModule(((ClientContext)this.getContext()).getModule());
        request.setAction("TariffPlanInfo");
        request.setAttribute("tpid", this.tariffPlanId);
        org.w3c.dom.Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (!ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
            return;
        }
        Element plan = XMLUtils.selectElement((Node)doc, (String)"//tariffPlan");
        if (plan == null) {
            return;
        }
        this.tariffPlanId = Utils.parseInt((String)XMLUtils.getAttribute((Element)plan, (String)"id", (String)"-1"));
        this.isUsedCheckBox.setSelected(Utils.parseBoolean((String)plan.getAttribute("used"), (boolean)false));
        this.isWebCheckBox.setSelected(Utils.parseBoolean((String)plan.getAttribute("useTitleInWeb"), (boolean)true));
        this.currentFace = Utils.parseInt((String)plan.getAttribute("face"));
        if (this.currentFace == 0) {
            this.physButton.setBackground(Color.lightGray);
            this.urButton.setBackground(Color.lightGray);
            this.allFaceButton.setBackground(Color.GRAY);
        } else if (this.currentFace == 1) {
            this.physButton.setBackground(Color.GRAY);
            this.urButton.setBackground(Color.lightGray);
            this.allFaceButton.setBackground(Color.lightGray);
        } else {
            this.physButton.setBackground(Color.lightGray);
            this.urButton.setBackground(Color.GRAY);
            this.allFaceButton.setBackground(Color.lightGray);
        }
        this.comment.setText(plan.getAttribute("comment"));
        this.maskText.setText(plan.getAttribute("mask"));
        this.config.setText(ClientUtils.linesToString((Element)XMLUtils.selectElement((Node)plan, (String)"//config")));
        this.tariffPlanTitleInGUI.setText(XMLUtils.getAttribute((Element)plan, (String)"title", (String)"\u0411\u0435\u0437 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f ;-(("));
        this.tariffPlanTitleInWEB.setText(XMLUtils.getAttribute((Element)plan, (String)"titleWeb", (String)this.tariffPlanTitleInGUI.getText()));
        int treeId = Utils.parseInt((String)plan.getAttribute("tree_id"), (int)-1);
        if (treeId > 0) {
            TariffTree tree = new TariffTree();
            tree.init((Component)((Object)this), treeId);
            this.tree = tree;
            this.treePanel.removeAll();
            this.treePanel.add(tree.getViewable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 0, 0), 0, 0));
            this.cardLayout2.show(this.treePanelContainer, "tree");
            tree.addPropertyChangeListener(evt -> {
                if ("needFlush".equals(evt.getPropertyName())) {
                    this.flush.setEnabled(Boolean.TRUE.equals(evt.getNewValue()));
                }
            });
        } else {
            this.cardLayout2.show(this.treePanelContainer, "nothing");
        }
        this.fillTable();
        this.setLabelTreeData(this.tariffLabelTree, this.tariffPlanId);
        JSONArray vars = new JSONArray("[{ varName: var1, varType: decimal },{ varName: var2, varType: string },{ varName: var3, varType: integer },{ varName: var4, varType: boolean }]");
        this.tariffVarsPanel.setData(vars);
        this.tabbedPane.setSelectedIndex(0);
    }

    private TariffService getTariffService() {
        if (this.tariffService == null) {
            this.tariffService = (TariffService)((ClientContext)this.getContext()).getPort(TariffService.class);
        }
        return this.tariffService;
    }

    private void updateTariff() {
        Request request = new Request();
        request.setModule(((ClientContext)this.getContext()).getModule());
        request.setAction("UpdateTariffPlan");
        request.setAttribute("tpid", this.tariffPlanId);
        request.setAttribute("tpused", this.isUsedCheckBox.getModel().isSelected() ? 1 : 0);
        request.setAttribute("title", this.tariffPlanTitleInGUI.getText().trim());
        request.setAttribute("title_web", this.tariffPlanTitleInWEB.getText().trim());
        request.setAttribute("use_title_in_web", this.isWebCheckBox.getModel().isSelected() ? 1 : 0);
        request.setAttribute("values", Utils.toString(this.contractLabelTree.getSelectedIds()));
        request.setAttribute("face", this.currentFace);
        request.setAttribute("mask", this.maskText.getText());
        request.setAttribute("config", this.config.getText());
        request.setAttribute("comment", this.comment.getText());
        ClientUtils.checkStatus((org.w3c.dom.Document)((ClientContext)this.getContext()).getDocument(request));
        try {
            TariffLabelService tariffLabelService = (TariffLabelService)((ClientContext)this.getContext()).getPort(TariffLabelService.class);
            tariffLabelService.setTariffLabelTreeItemList(this.tariffPlanId, this.tariffLabelTree.getSelectedItems());
            this.tariffPanel.labelPanel.updateFilterLabelTreeData(tariffLabelService.getTariffLabelTreeItemList(-1));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void exportTariff() {
        BGFileChooser fc = new BGFileChooser((Component)((Object)this));
        fc.setFileFilter((FileFilter)new BGFileFilter("xml", "XML \u0444\u0430\u0439\u043b\u044b"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            Object path = fc.getSelectedFile().getAbsolutePath();
            if (!((String)path).endsWith(".xml") && !((String)path).endsWith(".XML")) {
                path = (String)path + ".xml";
            }
            Request request = new Request();
            request.setModule(((ClientContext)this.getContext()).getModule());
            request.setAction("ExportTariffPlan");
            request.setAttribute("tpid", this.tariffPlanId);
            try {
                FileOutputStream fos = new FileOutputStream((String)path);
                InputStream is = ((ClientContext)this.getContext()).getInputStream(request);
                this.flush(is, fos);
                is.close();
                fos.flush();
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showTariffEditor() {
        this.cardLayout1.show(this.cardPanel, TARIFF_EDITOR);
        this.setTariffPlanData();
        this.flush.setEnabled(false);
    }

    private void fillTable() {
        if (!this.init) {
            try {
                this.contractLabelTree.setData(((ContractLabelService)((ClientContext)this.getContext()).getPort(ContractLabelService.class)).getContractLabelTreeItemList(-1, false));
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
        Request request = new Request();
        request.setModule(((ClientContext)this.getContext()).getModule());
        request.setAction("GetTariffContractGroups");
        request.setAttribute("tpid", this.tariffPlanId);
        org.w3c.dom.Document doc = ((ClientContext)this.getContext()).getDocument(request);
        if (ClientUtils.checkStatus((org.w3c.dom.Document)doc)) {
            this.contractLabelTree.setSelectedIds(Utils.toIntegerList((String)XMLUtils.selectText((Node)doc, (String)"//active/@values", (String)"")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flush(InputStream is, OutputStream os) {
        boolean wasFlush = false;
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf, 0, 1024)) != -1) {
                os.write(buf, 0, len);
                wasFlush = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return wasFlush;
    }

    private void setLabelTreeData(TariffLabelTree labelTree, int tariffPlanId) {
        try {
            labelTree.setData(((TariffLabelService)((ClientContext)this.getContext()).getPort(TariffLabelService.class)).getTariffLabelTreeItemList(tariffPlanId));
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private class RepeatDocumentListener
    implements DocumentListener {
        private RepeatDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processText(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processText(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processText(e);
        }

        private void processText(final DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TariffPanelEditor.this.isWebCheckBox.isSelected()) {
                        Document doc = e.getDocument();
                        try {
                            String text = doc.getText(0, doc.getLength());
                            TariffPanelEditor.this.tariffPlanTitleInWEB.setText(text);
                        }
                        catch (BadLocationException e1) {
                            ((ClientContext)TariffPanelEditor.this.getContext()).processException((Throwable)e1);
                        }
                    }
                }
            });
        }
    }
}

