/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.service;

import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptBackupManager;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptLibraryManager;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.script.common.service.ScriptService")
public class ScriptServiceImpl
extends AbstractService
implements ScriptService {
    @Override
    public List<ScriptLibrary> list() throws BGException {
        return new ScriptLibraryManager(this.getConnection()).list();
    }

    @Override
    public List<ScriptLibrary> pureList() throws BGException {
        return new ScriptLibraryManager(this.getConnection()).pureList();
    }

    @Override
    public ScriptLibrary getLibrary(int scriptId) throws BGException {
        return (ScriptLibrary)new ScriptLibraryManager(this.getConnection()).get(scriptId);
    }

    @Override
    public Revision getRevision(int scriptId) throws BGException {
        return new ScriptLibraryManager(this.getConnection()).getRevisionProperties(scriptId);
    }

    @Override
    public void deleteLibrary(int scriptId) throws BGException {
        new ScriptLibraryManager(this.getConnection()).deleteFull(scriptId);
    }

    @Override
    public int test(int value) {
        return value + 1;
    }

    @Override
    public Revision update(ScriptLibrary lib) throws BGException {
        if (Utils.isBlankString((String)lib.getName())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u0418\u043c\u044f' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        if (Utils.isBlankString((String)lib.getTitle())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        new ScriptLibraryManager(this.getConnection()).update((Object)lib);
        this.context.publishAfterCommit(new ScriptFunctionModifiedEvent(0));
        return lib.getRevision();
    }

    @Override
    public void backup(ScriptBackup backup) throws BGException {
        backup.setId(-1);
        backup.setUserId(this.userId);
        new ScriptBackupManager(this.getConnection()).update((Object)backup);
    }

    @Override
    public List<ScriptBackup> listBackup(int scriptId, int type) throws BGException {
        return new ScriptBackupManager(this.getConnection()).list(scriptId, type);
    }

    @Override
    public void deleteBackup(int backupId) throws BGException {
        new ScriptBackupManager(this.getConnection()).delete(backupId);
    }

    @Override
    public ScriptBackup getBackup(int backupId) throws BGException {
        return (ScriptBackup)new ScriptBackupManager(this.getConnection()).get(backupId);
    }
}

