/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.plugin.server;

import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginManagerBase;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.event.PluginConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGPluginManagerServer
extends BGPluginManagerBase {
    private static Logger log = LogManager.getLogger();
    private Map<String, BGPluginServer> pluginsMap = new LinkedHashMap<String, BGPluginServer>();
    private Map<Integer, BGPluginServer> pluginsUIDMap = new HashMap<Integer, BGPluginServer>();

    public void init(Connection con, String applicationName) throws BGException {
        log.info("Plugins init...");
        for (OnDestroyServer p : BGPluginManagerServer.getManager().getInvokeables(OnDestroyServer.class, false)) {
            p.onDestroyServer(applicationName);
        }
        this.pluginsMap.clear();
        this.pluginsUIDMap.clear();
        this.cacheInvokeablePoints.clear();
        this.cacheExtensionPoints.clear();
        HashMap<String, String[]> pluginsDataMap = new HashMap<String, String[]>();
        try {
            String query = "SELECT name, id, pack_server, plugin_config.config FROM installed_modules LEFT JOIN plugin_config ON plugin_config.pid=installed_modules.id WHERE type='plugin' AND enabled=1";
            PreparedStatement ps = con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String[] data = new String[]{rs.getString(2), rs.getString(3), rs.getString(4)};
                pluginsDataMap.put(rs.getString(1), data);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException("error plugin load", (Throwable)e);
        }
        HashMap<String, BGPluginServer> pluginsMapTemp = new HashMap<String, BGPluginServer>();
        for (URL pluginUrl : BGPluginManagerServer.getPlugins()) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("pluginUrl = " + pluginUrl);
                }
                BGPluginServer plugin = new BGPluginServer();
                InputStream inputStream = pluginUrl.openStream();
                if (inputStream != null) {
                    plugin.setDocument(XMLUtils.parseDocument((InputSource)new InputSource(inputStream)));
                    if (log.isDebugEnabled()) {
                        log.debug("plugin.getId() = " + plugin.getId());
                    }
                }
                plugin.setResourceBundle(ResourceBundle.getBundle(plugin.getId() + ".plugin"));
                if (!pluginsDataMap.containsKey(plugin.getId())) continue;
                String[] data = (String[])pluginsDataMap.get(plugin.getId());
                if (log.isDebugEnabled()) {
                    log.debug("data = " + data);
                }
                plugin.setPluginUID(Integer.parseInt(data[0]));
                plugin.setPackServer(data[1]);
                if (data[2] != null) {
                    plugin.setSetup(new Preferences(data[2], "\r\n"));
                }
                pluginsMapTemp.put(plugin.getId(), plugin);
                this.pluginsUIDMap.put(plugin.getPluginUID(), plugin);
                if (!log.isDebugEnabled()) continue;
                log.debug("plugin " + plugin.getId() + " load");
            }
            catch (Exception ex) {
                throw new BGException("error plugin " + pluginUrl.toString() + " load", (Throwable)ex);
            }
        }
        try {
            String pluginsOrderConf = Setup.getSetup().get("plugins.order");
            if (Utils.notBlankString((String)pluginsOrderConf)) {
                String[] plugins;
                for (String plugin : plugins = pluginsOrderConf.split(",")) {
                    String pluginId = "ru.bitel.bgbilling.plugins." + plugin.trim();
                    BGPluginServer pluginServer = (BGPluginServer)pluginsMapTemp.get(pluginId);
                    if (pluginServer == null) continue;
                    pluginsMapTemp.remove(pluginId);
                    this.pluginsMap.put(pluginId, pluginServer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pluginsMap.putAll(pluginsMapTemp);
        pluginsMapTemp.clear();
        for (OnInitServer p : BGPluginManagerServer.getManager().getInvokeables(OnInitServer.class, false)) {
            p.onInitServer(applicationName);
        }
    }

    public static final BGPluginManagerServer getManager() {
        if (ourInstance == null) {
            ourInstance = new BGPluginManagerServer();
        }
        return (BGPluginManagerServer)ourInstance;
    }

    @Override
    public BGPluginServer getPlugin(String id) {
        return this.pluginsMap.get(id);
    }

    public BGPluginServer getPluginByUID(int uid) {
        return this.pluginsUIDMap.get(uid);
    }

    public Map<String, BGPluginServer> getPluginsMap() {
        return this.pluginsMap;
    }

    public <T> Collection<BGPluginServer> getPluginsForInvokeablePoints(Class<T> point) {
        return this.pluginsMap.values();
    }

    static {
        try {
            EventProcessor.getInstance().addListener(new EventListener<PluginConfigModifiedEvent>(){

                @Override
                public void notify(PluginConfigModifiedEvent e, EventListenerContext ctx) throws BGException {
                    BGPluginManagerServer.getManager().init(ctx.getConnection(), ctx.getApplicationName());
                }
            }, PluginConfigModifiedEvent.class);
        }
        catch (BGException e) {
            log.error("error add PluginConfigModifiedEvent listener", (Throwable)e);
        }
    }
}

