/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.config.client;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.config.common.service.DialogConfigService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;

public class DialogConfigPanel
extends BGUPanel {
    private JTextArea dialogEditor = null;
    private JList<KeyValue> dialogList = null;
    private BGButtonPanel buttonPanel = null;
    private DialogConfigService dialogConfigService = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.getListPanel(), (Component)this.getEditorPanel(), 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.performAction("initKeyList");
    }

    protected JPanel getListPanel() {
        this.dialogList = new JList();
        this.dialogList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KeyValue keyValue = DialogConfigPanel.this.dialogList.getSelectedValue();
                if (keyValue != null && e.getClickCount() == 2) {
                    try {
                        DialogConfigPanel.this.dialogEditor.setText(DialogConfigPanel.this.getDialogConfigService().dialogConfigGet(((ClientContext)DialogConfigPanel.this.getContext()).getModuleId(), keyValue.getKey(), false));
                        DialogConfigPanel.this.dialogList.setEnabled(false);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        this.dialogList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.dialogList.setSelectionMode(2);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u0438\u0430\u043b\u043e\u0433\u0438:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 2, 2), 0, 0));
        panel.add((Component)new JScrollPane(this.dialogList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 2), 0, 0));
        return panel;
    }

    protected JPanel getEditorPanel() {
        this.dialogEditor = new JTextArea();
        this.dialogEditor.setMargin(new Insets(3, 3, 3, 3));
        this.dialogEditor.setFont(new Font("Monospaced", 0, 13));
        this.buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.RESET, BGButtonPanel.CLOSE});
        this.buttonPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            KeyValue keyValue = this.dialogList.getSelectedValue();
            if (actionCommand.equals(BGButtonPanel.OK.getActionCommand())) {
                try {
                    new JSONObject(this.dialogEditor.getText());
                    this.getDialogConfigService().dialogConfigUpdate(((ClientContext)this.getContext()).getModuleId(), keyValue.getKey(), this.dialogEditor.getText());
                    this.dialogList.setEnabled(false);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else if (actionCommand.equals(BGButtonPanel.RESET.getActionCommand())) {
                try {
                    this.dialogEditor.setText(this.getDialogConfigService().dialogConfigGet(((ClientContext)this.getContext()).getModuleId(), keyValue.getKey(), true));
                    this.dialogList.setEnabled(false);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            } else if (actionCommand.equals(BGButtonPanel.CLOSE.getActionCommand())) {
                this.dialogEditor.setText("");
                this.dialogList.setEnabled(true);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.dialogEditor), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.buttonPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 5, 0), 0, 0));
        return panel;
    }

    protected DialogConfigService getDialogConfigService() {
        if (this.dialogConfigService == null) {
            this.dialogConfigService = (DialogConfigService)((ClientContext)this.getContext()).getPort(DialogConfigService.class);
        }
        return this.dialogConfigService;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("initKeyList", "R"){

            public void actionPerformedImpl(ActionEvent event) throws Exception {
                List<KeyValue> keys = DialogConfigPanel.this.getDialogConfigService().dialogConfigList(((ClientContext)DialogConfigPanel.this.getContext()).getModuleId());
                DefaultListModel<KeyValue> listModel = new DefaultListModel<KeyValue>();
                for (KeyValue keyValue : keys) {
                    listModel.addElement(keyValue);
                }
                DialogConfigPanel.this.dialogList.setModel(listModel);
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent event) throws Exception {
            }
        };
    }
}

