/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server;

import bitel.billing.server.contract.bean.Contract;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ConvergenceBalanceEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.TimeUtils;

public class ConvergenceBalanceRuntime
extends ReentrantLock
implements ConvergenceBalance {
    private static final long serialVersionUID = 1L;
    private static final int SCALE_NUM = 5;
    private static final BigDecimal SCALE = BigDecimal.valueOf(10L).pow(5);
    public final Integer contractId;
    public final Integer superContractId;
    private long incomingSaldo;
    private long payments;
    private long accounts;
    private long charges;
    private long reserve;
    private long limit;
    final long created;
    final int year;
    final int month;
    final long monthStartTime;
    final long monthEndTime;
    long lastAccess;
    private Boolean balanceExceedsLimitEvent = null;
    private Boolean saldoExceedsZeroEvent = null;

    private static long unscale(BigDecimal summa) {
        return summa.multiply(SCALE).longValue();
    }

    void setBalance(ContractBalance contractBalance) {
        this.incomingSaldo = ConvergenceBalanceRuntime.unscale(contractBalance.getIncomingSaldo());
        this.payments = ConvergenceBalanceRuntime.unscale(contractBalance.getPayments());
        this.accounts = ConvergenceBalanceRuntime.unscale(contractBalance.getAccounts());
        this.charges = ConvergenceBalanceRuntime.unscale(contractBalance.getCharges());
        this.reserve = ConvergenceBalanceRuntime.unscale(contractBalance.getReserve());
    }

    ConvergenceBalanceRuntime(int contractId, int superContractId, BigDecimal limit, ContractBalance contractBalance, Calendar now) {
        long millis;
        this.contractId = contractId;
        this.superContractId = superContractId;
        this.incomingSaldo = ConvergenceBalanceRuntime.unscale(contractBalance.getIncomingSaldo());
        this.payments = ConvergenceBalanceRuntime.unscale(contractBalance.getPayments());
        this.accounts = ConvergenceBalanceRuntime.unscale(contractBalance.getAccounts());
        this.charges = ConvergenceBalanceRuntime.unscale(contractBalance.getCharges());
        this.reserve = ConvergenceBalanceRuntime.unscale(contractBalance.getReserve());
        this.limit = ConvergenceBalanceRuntime.unscale(limit);
        this.created = millis = now.getTimeInMillis();
        this.lastAccess = millis;
        this.year = now.get(1);
        this.month = now.get(2) + 1;
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)now);
        now.set(5, 1);
        this.monthStartTime = now.getTimeInMillis();
        now.add(2, 1);
        this.monthEndTime = now.getTimeInMillis() - 1L;
    }

    private ConvergenceBalanceRuntime(int contractId, int superContractId, long limit, long incomingSaldo, Calendar now, long created) {
        this.contractId = contractId;
        this.superContractId = superContractId;
        this.incomingSaldo = incomingSaldo;
        this.limit = limit;
        long millis = now.getTimeInMillis();
        this.created = created;
        this.lastAccess = millis;
        this.year = now.get(1);
        this.month = now.get(2) + 1;
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)now);
        now.set(5, 1);
        this.monthStartTime = now.getTimeInMillis();
        now.add(2, 1);
        this.monthEndTime = now.getTimeInMillis() - 1L;
    }

    ConvergenceBalanceRuntime(Contract contract, ContractBalance contractBalance, Calendar now) {
        long millis;
        this.contractId = contract.getId();
        this.superContractId = contract.isDependSub() ? contract.getSuperId() : -1;
        this.incomingSaldo = ConvergenceBalanceRuntime.unscale(contractBalance.getIncomingSaldo());
        this.payments = ConvergenceBalanceRuntime.unscale(contractBalance.getPayments());
        this.accounts = ConvergenceBalanceRuntime.unscale(contractBalance.getAccounts());
        this.charges = ConvergenceBalanceRuntime.unscale(contractBalance.getCharges());
        this.reserve = ConvergenceBalanceRuntime.unscale(contractBalance.getReserve());
        BigDecimal limit = contract.getBalanceLimit();
        this.limit = ConvergenceBalanceRuntime.unscale(limit);
        this.created = millis = now.getTimeInMillis();
        this.lastAccess = millis;
        this.year = now.get(1);
        this.month = now.get(2) + 1;
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)now);
        now.set(5, 1);
        this.monthStartTime = now.getTimeInMillis();
        now.add(2, 1);
        this.monthEndTime = now.getTimeInMillis() - 1L;
    }

    ConvergenceBalanceRuntime(Contract contract, BigDecimal incomingSaldo, Calendar now) {
        long millis;
        this.contractId = contract.getId();
        this.superContractId = contract.isDependSub() ? contract.getSuperId() : -1;
        this.incomingSaldo = ConvergenceBalanceRuntime.unscale(incomingSaldo);
        this.payments = 0L;
        this.accounts = 0L;
        this.reserve = 0L;
        BigDecimal limit = contract.getBalanceLimit();
        this.limit = ConvergenceBalanceRuntime.unscale(limit);
        this.created = millis = now.getTimeInMillis();
        this.lastAccess = millis;
        this.year = now.get(1);
        this.month = now.get(2) + 1;
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)now);
        now.set(5, 1);
        this.monthStartTime = now.getTimeInMillis();
        now.add(2, 1);
        this.monthEndTime = now.getTimeInMillis() - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPayment(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.payments += ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCharge(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.charges += ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReserve(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.reserve += ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subtractReserve(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.reserve -= ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    void setLimit(BigDecimal value) {
        this.lock();
        try {
            this.limit = ConvergenceBalanceRuntime.unscale(value);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAccount(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.accounts += ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAccount(BigDecimal summa, long now) {
        this.lock();
        try {
            this.lastAccess = now;
            this.accounts = ConvergenceBalanceRuntime.unscale(summa);
        }
        finally {
            this.unlock();
        }
    }

    private BigDecimal getBalance0() {
        return BigDecimal.valueOf(this.getBalanceLong()).divide(SCALE, 2, RoundingMode.HALF_UP);
    }

    private BigDecimal getSaldo0() {
        return BigDecimal.valueOf(this.getSaldoLong()).divide(SCALE, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBalance() {
        this.lock();
        try {
            BigDecimal bigDecimal = this.getBalance0();
            return bigDecimal;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public BigDecimal getSaldo() {
        this.lock();
        try {
            BigDecimal bigDecimal = this.getSaldo0();
            return bigDecimal;
        }
        finally {
            this.unlock();
        }
    }

    private BigDecimal getLimit0() {
        if (this.limit == 0L) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(this.limit).divide(SCALE, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getLimit() {
        this.lock();
        try {
            BigDecimal bigDecimal = this.getLimit0();
            return bigDecimal;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isBalanceUnderLimit() {
        return this.isBalanceExceedsLimit();
    }

    @Override
    public boolean isBalanceExceedsLimit() {
        this.lock();
        try {
            boolean bl = this.getBalanceLong() >= this.limit;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isBalanceUnderLimit(BigDecimal addAccount) {
        return this.isBalanceExceedsLimit(addAccount);
    }

    @Override
    public boolean isBalanceExceedsLimit(BigDecimal addAccount) {
        if (addAccount == BigDecimal.ZERO || addAccount == null) {
            return this.isBalanceExceedsLimit();
        }
        this.lock();
        try {
            boolean bl = this.getBalance0().subtract(addAccount).compareTo(this.getLimit0()) >= 0;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock();
        try {
            String string = new StringBuilder(25).append(this.getBalance0().toPlainString()).append(" [").append(this.getLimit0().toPlainString()).append("]").toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryGenerateConvergenceBalanceEvent() throws BGException {
        BigDecimal limit;
        boolean needGenerate;
        Boolean saldoExceedsZero;
        Boolean balanceExceedsLimit;
        long balance;
        this.lock();
        try {
            balance = this.getBalanceLong();
            long saldo = this.getSaldoLong();
            balanceExceedsLimit = balance >= this.limit ? Boolean.TRUE : Boolean.FALSE;
            saldoExceedsZero = saldo >= 0L;
            if (balanceExceedsLimit != this.balanceExceedsLimitEvent) {
                needGenerate = true;
                limit = this.getLimit0();
                this.balanceExceedsLimitEvent = balanceExceedsLimit;
                this.saldoExceedsZeroEvent = saldoExceedsZero;
            } else if (saldoExceedsZero != this.saldoExceedsZeroEvent) {
                needGenerate = true;
                limit = this.getLimit0();
                this.saldoExceedsZeroEvent = saldoExceedsZero;
                this.balanceExceedsLimitEvent = balanceExceedsLimit;
            } else {
                needGenerate = false;
                limit = null;
            }
        }
        finally {
            this.unlock();
        }
        if (needGenerate) {
            EventProcessor.getInstance().request(new ConvergenceBalanceEvent(this.contractId, balanceExceedsLimit, saldoExceedsZero, BigDecimal.valueOf(balance).divide(SCALE, 2, RoundingMode.HALF_UP), limit));
        }
    }

    private long getBalanceLong() {
        return this.incomingSaldo + this.payments - this.charges - this.accounts - this.reserve;
    }

    private long getSaldoLong() {
        return this.incomingSaldo + this.payments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateConvergenceBalanceEvent() throws BGException {
        BigDecimal limit;
        Boolean saldoExceedsZero;
        Boolean balanceExceedsLimit;
        long balance;
        this.lock();
        try {
            balance = this.getBalanceLong();
            long saldo = this.getSaldoLong();
            balanceExceedsLimit = balance >= this.limit ? Boolean.TRUE : Boolean.FALSE;
            saldoExceedsZero = saldo >= 0L;
            limit = this.getLimit0();
            this.balanceExceedsLimitEvent = balanceExceedsLimit;
            this.saldoExceedsZeroEvent = saldoExceedsZero;
        }
        finally {
            this.unlock();
        }
        EventProcessor.getInstance().request(new ConvergenceBalanceEvent(this.contractId, balanceExceedsLimit, saldoExceedsZero, BigDecimal.valueOf(balance).divide(SCALE, 2, RoundingMode.HALF_UP), limit));
    }

    ConvergenceBalanceRuntime toNewer(Calendar now) {
        this.lock();
        try {
            ConvergenceBalanceRuntime convergenceBalanceRuntime = new ConvergenceBalanceRuntime(this.contractId, this.superContractId, this.limit, this.getBalanceLong(), now, this.created);
            return convergenceBalanceRuntime;
        }
        finally {
            this.unlock();
        }
    }

    public ConvergenceBalance subBalance(final ConvergenceBalanceRuntime subBalance) {
        return new ConvergenceBalance(){

            @Override
            public BigDecimal getSaldo() {
                return ConvergenceBalanceRuntime.this.getSaldo();
            }

            @Override
            public BigDecimal getLimit() {
                return subBalance.getLimit();
            }

            @Override
            public BigDecimal getBalance() {
                return ConvergenceBalanceRuntime.this.getBalance();
            }

            @Override
            public boolean isBalanceExceedsLimit() {
                ConvergenceBalanceRuntime.this.lock();
                try {
                    boolean bl;
                    subBalance.lock();
                    try {
                        bl = ConvergenceBalanceRuntime.this.getBalanceLong() >= subBalance.limit;
                    }
                    catch (Throwable throwable) {
                        subBalance.unlock();
                        throw throwable;
                    }
                    subBalance.unlock();
                    return bl;
                }
                finally {
                    ConvergenceBalanceRuntime.this.unlock();
                }
            }

            @Override
            public boolean isBalanceExceedsLimit(BigDecimal addAccount) {
                if (addAccount == BigDecimal.ZERO || addAccount == null) {
                    return this.isBalanceExceedsLimit();
                }
                ConvergenceBalanceRuntime.this.lock();
                try {
                    boolean bl = ConvergenceBalanceRuntime.this.getBalance0().subtract(addAccount).compareTo(subBalance.getLimit0()) >= 0;
                    return bl;
                }
                finally {
                    ConvergenceBalanceRuntime.this.unlock();
                }
            }

            @Override
            @Deprecated
            public boolean isBalanceUnderLimit(BigDecimal addAccount) {
                return this.isBalanceExceedsLimit(addAccount);
            }

            @Override
            @Deprecated
            public boolean isBalanceUnderLimit() {
                return this.isBalanceExceedsLimit();
            }

            public String toString() {
                return new StringBuilder(25).append(this.getBalance().toPlainString()).append(" [").append(this.getLimit().toPlainString()).append("]").toString();
            }
        };
    }
}

