/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius.auth.eap.tls;

import bitel.billing.server.radius.auth.eap.tls.AbstractTLSTunnel;
import bitel.billing.server.radius.auth.eap.tls.TLSLogHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.Preferences;

public final class TLSTunnel
extends AbstractTLSTunnel {
    protected static final Logger log = LogManager.getLogger((String)"radius");
    private ByteBuffer appInBuffer;
    private ByteBuffer appOutBuffer;
    private ByteBuffer packetInBuffer;
    private ByteBuffer packetOutBuffer;
    private ByteArrayOutputStream packetInput = new ByteArrayOutputStream();
    private ByteArrayOutputStream packetOutput = new ByteArrayOutputStream();
    private ByteArrayOutputStream appOutput = new ByteArrayOutputStream();
    private AbstractTLSTunnel.State state = AbstractTLSTunnel.State.none;
    public SSLEngine sslEngine;
    private byte[] serverRandom;
    private byte[] clientRandom;
    private static Method getMasterSecretMethod = null;
    private static Method getEncodedMethod = null;
    public int handshakeCount;
    private SSLEngineResult.HandshakeStatus initialHSStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    private boolean initialHSComplete = false;

    private TLSTunnel(SSLContext sslContext, boolean needAuth) {
        this.sslEngine = sslContext.createSSLEngine();
        this.sslEngine.setEnableSessionCreation(true);
        this.sslEngine.setUseClientMode(false);
        this.sslEngine.setWantClientAuth(true);
        this.sslEngine.setNeedClientAuth(needAuth);
        this.sslEngine.setEnabledProtocols(new String[]{"TLSv1"});
        SSLSession sslSession = this.sslEngine.getSession();
        this.appInBuffer = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.appOutBuffer = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.packetInBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.packetOutBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
    }

    protected byte[] getMasterSecret() {
        try {
            Object secret;
            if (getMasterSecretMethod == null) {
                for (Class<?> clazz = this.sslEngine.getSession().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        getMasterSecretMethod = clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
                        getMasterSecretMethod.setAccessible(true);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                }
            }
            if ((secret = getMasterSecretMethod.invoke((Object)this.sslEngine.getSession(), new Object[0])) instanceof byte[]) {
                return (byte[])secret;
            }
            if (secret instanceof Key) {
                return ((Key)secret).getEncoded();
            }
            if (getEncodedMethod == null) {
                for (Class<?> clazz = secret.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        getEncodedMethod = clazz.getDeclaredMethod("getEncoded", new Class[0]);
                        getEncodedMethod.setAccessible(true);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                }
            }
            secret = getEncodedMethod.invoke(secret, new Object[0]);
            return (byte[])secret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    @Override
    public AbstractTLSTunnel.State handshake() throws IOException {
        if (this.state == AbstractTLSTunnel.State.established) {
            return this.state;
        }
        SSLEngineResult result = null;
        SSLEngineResult.HandshakeStatus hsStatus = null;
        boolean didWrap = false;
        if (this.state == AbstractTLSTunnel.State.none) {
            this.state = AbstractTLSTunnel.State.handshaking;
            this.sslEngine.beginHandshake();
        }
        block2: while (true) {
            block17: {
                Runnable task;
                hsStatus = this.sslEngine.getHandshakeStatus();
                if (this.handshakeCount++ > 20) {
                    log.error("TLS handshake stack error!!!");
                    this.state = AbstractTLSTunnel.State.handshake_error;
                    return AbstractTLSTunnel.State.handshake_error;
                }
                if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED || hsStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                    log.debug("TLS handshake finished");
                    this.state = AbstractTLSTunnel.State.established;
                    if (didWrap) {
                        return AbstractTLSTunnel.State.handshaking;
                    }
                    return this.state;
                }
                if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    while (true) {
                        if ((task = this.sslEngine.getDelegatedTask()) == null) continue block2;
                        task.run();
                    }
                }
                if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    result = this.sslEngine.wrap(this.appOutBuffer, this.packetOutBuffer);
                    this.packetOutBuffer.flip();
                    if (this.packetOutBuffer.hasRemaining()) {
                        this.packetOutput.write(this.packetOutBuffer.array(), this.packetOutBuffer.arrayOffset(), this.packetOutBuffer.remaining());
                    }
                    this.packetOutBuffer.clear();
                    didWrap = true;
                    continue;
                }
                if (hsStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) break;
                if (didWrap) {
                    return this.state;
                }
                if (this.packetInBuffer.remaining() < 0) {
                    log.warn("TLS close inbound");
                    this.sslEngine.closeInbound();
                    return this.state;
                }
                this.packetInBuffer.flip();
                try {
                    while (this.packetInBuffer.hasRemaining()) {
                        result = this.sslEngine.unwrap(this.packetInBuffer, this.appInBuffer);
                        if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                        while ((task = this.sslEngine.getDelegatedTask()) != null) {
                            task.run();
                        }
                    }
                }
                catch (SSLHandshakeException ex) {
                    this.state = AbstractTLSTunnel.State.handshake_error;
                    if (!log.isDebugEnabled()) break block17;
                    Throwable e = ex;
                    while (e.getCause() != null) {
                        e = e.getCause();
                    }
                    log.debug("TLS handshake error: " + e.getMessage());
                }
            }
            this.packetInBuffer.clear();
        }
        return this.state;
    }

    public byte[] getAppBuffer() throws SSLException {
        byte[] b = this.appOutput.toByteArray();
        this.appOutput = new ByteArrayOutputStream();
        return b;
    }

    public byte[] unwrap(byte[] data) throws SSLException {
        this.putPacketBuffer(data);
        return this.getAppBuffer();
    }

    public void putAppBuffer(byte[] d) throws SSLException {
        SSLEngineResult result = null;
        int chunk = this.appOutBuffer.capacity();
        int left = d.length;
        int offset = 0;
        while (left > 0) {
            if (left < chunk) {
                chunk = left;
            }
            left -= chunk;
            this.appOutBuffer.clear();
            this.appOutBuffer.put(d, offset, chunk);
            this.appOutBuffer.flip();
            while (this.appOutBuffer.hasRemaining()) {
                result = this.sslEngine.wrap(this.appOutBuffer, this.packetOutBuffer);
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                }
                if (this.state != AbstractTLSTunnel.State.established) continue;
                this.packetOutBuffer.flip();
                if (this.packetOutBuffer.hasRemaining()) {
                    this.packetOutput.write(this.packetOutBuffer.array(), this.packetOutBuffer.arrayOffset(), this.packetOutBuffer.remaining());
                }
                this.packetOutBuffer.clear();
            }
            this.packetInBuffer.clear();
            offset += chunk;
        }
    }

    public byte[] getPacketInputBuffer() {
        byte[] b = this.packetInput.toByteArray();
        this.packetInput = new ByteArrayOutputStream();
        return b;
    }

    public byte[] getPacketOutputBuffer() {
        this.packetOutBuffer.flip();
        if (this.packetOutBuffer.hasRemaining()) {
            this.packetOutput.write(this.packetOutBuffer.array(), this.packetOutBuffer.arrayOffset(), this.packetOutBuffer.remaining());
        }
        this.packetOutBuffer.clear();
        byte[] b = this.packetOutput.toByteArray();
        this.packetOutput = new ByteArrayOutputStream();
        if (log.isDebugEnabled()) {
            log.debug(TLSLogHelper.trace(b));
        }
        this.parse(b);
        return b;
    }

    public void putPacketBuffer(byte[] d) throws SSLException {
        int chunk = this.packetInBuffer.capacity();
        int left = d.length;
        int offset = 0;
        while (left > 0) {
            if (left < chunk) {
                chunk = left;
            }
            left -= chunk;
            this.packetInBuffer.put(d, offset, chunk);
            if (this.state == AbstractTLSTunnel.State.established) {
                this.packetInBuffer.flip();
                SSLEngineResult result = null;
                while ((result == null || result.getStatus() == SSLEngineResult.Status.OK) && this.packetInBuffer.hasRemaining()) {
                    result = this.sslEngine.unwrap(this.packetInBuffer, this.appInBuffer);
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        Runnable task;
                        while ((task = this.sslEngine.getDelegatedTask()) != null) {
                            task.run();
                        }
                    }
                    this.appInBuffer.flip();
                    if (this.appInBuffer.hasRemaining()) {
                        this.appOutput.write(this.appInBuffer.array(), this.appInBuffer.arrayOffset(), this.appInBuffer.remaining());
                    }
                    this.appInBuffer.clear();
                }
                this.packetInBuffer.clear();
            }
            offset += chunk;
        }
    }

    @Override
    public void updatePacketBuffer(byte[] buf) {
        try {
            if (this.state == AbstractTLSTunnel.State.established) {
                this.packetInput.write(buf);
            } else {
                this.putPacketBuffer(buf);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void putInputPacket(byte[] packet) {
        if (log.isDebugEnabled()) {
            log.debug(TLSLogHelper.trace(packet));
        }
        this.parse(packet);
    }

    @Override
    public byte[] getKeyMaterial() {
        try {
            return TLSTunnel.getKeyMaterial(LABEL_KEYING_MATERIAL_TLS, this.getMasterSecret(), this.serverRandom, this.clientRandom);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getKeyMaterial(byte[] label) {
        try {
            return TLSTunnel.getKeyMaterial(label, this.getMasterSecret(), this.serverRandom, this.clientRandom);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void parse(byte[] data) {
        try {
            int i = 0;
            byte lastConType = 0;
            while (i < data.length) {
                byte m_contentType = data[i++];
                i += 2;
                int length = data[i++] << 8 & 0xFF00 | data[i++] & 0xFF;
                int nextI = i + length;
                switch (m_contentType) {
                    case 21: {
                        ++i;
                        break;
                    }
                    case 22: {
                        int hsLen;
                        block12: for (int j = i; j < nextI; j += hsLen) {
                            byte hsType = data[j++];
                            hsLen = data[j++] << 16 & 0xFF0000 | data[j++] << 8 & 0xFF00 | data[j++] & 0xFF;
                            if (lastConType == 20) continue;
                            switch (hsType) {
                                case 0: {
                                    continue block12;
                                }
                                case 1: {
                                    int k = j;
                                    this.clientRandom = new byte[32];
                                    System.arraycopy(data, k += 2, this.clientRandom, 0, 32);
                                    continue block12;
                                }
                                case 2: {
                                    int k = j;
                                    this.serverRandom = new byte[32];
                                    System.arraycopy(data, k += 2, this.serverRandom, 0, 32);
                                    continue block12;
                                }
                            }
                        }
                        break;
                    }
                }
                lastConType = m_contentType;
                i = nextI;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean handshake2() throws IOException {
        if (this.initialHSComplete) {
            return this.initialHSComplete;
        }
        switch (this.initialHSStatus) {
            case FINISHED: {
                this.initialHSComplete = true;
            }
        }
        block3 : switch (this.initialHSStatus) {
            case NEED_UNWRAP: {
                SSLEngineResult result;
                if (this.packetInBuffer.remaining() < 0) {
                    System.err.println("CLOSE INBOUND");
                    this.sslEngine.closeInbound();
                    return this.initialHSComplete;
                }
                block19: while (this.initialHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.packetInBuffer.flip();
                    result = this.sslEngine.unwrap(this.packetInBuffer, this.appInBuffer);
                    this.packetInBuffer.compact();
                    this.initialHSStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.initialHSStatus) {
                                case NOT_HANDSHAKING: {
                                    throw new IOException("Not handshaking during initial handshake");
                                }
                                case NEED_TASK: {
                                    this.initialHSStatus = this.doTasks();
                                    break;
                                }
                                case FINISHED: {
                                    this.initialHSComplete = true;
                                    break block19;
                                }
                            }
                            continue block19;
                        }
                        case BUFFER_UNDERFLOW: {
                            System.err.println("Need to go reread the Channel for more data");
                            break block19;
                        }
                        default: {
                            throw new IOException("Received" + result.getStatus() + "during initial handshaking");
                        }
                    }
                }
                if (this.initialHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.packetOutBuffer.clear();
                SSLEngineResult result = this.sslEngine.wrap(this.appOutBuffer, this.packetOutBuffer);
                this.packetOutBuffer.flip();
                if (this.packetOutBuffer.hasRemaining()) {
                    this.packetOutput.write(this.packetOutBuffer.array(), this.packetOutBuffer.arrayOffset(), this.packetOutBuffer.remaining());
                }
                this.packetOutBuffer.clear();
                this.initialHSStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        if (this.initialHSStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) break block3;
                        this.initialHSStatus = this.doTasks();
                        break block3;
                    }
                    default: {
                        throw new IOException("Received" + result.getStatus() + "during initial handshaking");
                    }
                }
            }
            default: {
                throw new RuntimeException("Invalid Handshaking State" + this.initialHSStatus);
            }
        }
        return this.initialHSComplete;
    }

    public static void main(String[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.SSLSessionImpl");
        clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
        boolean result = false;
        for (clazz = Class.forName("sun.security.pkcs11.P11Key$P11TlsMasterSecretKey"); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                clazz.getDeclaredMethod("getEncoded", new Class[0]);
                result = true;
                break;
            }
            catch (Exception ex) {
                continue;
            }
        }
        System.out.println(result);
    }

    public static class Context {
        private SSLContext sslContext;
        private final boolean needAuth;

        public Context(Preferences setup, TrustManager[] trustManagers, boolean needAuth) {
            this.needAuth = needAuth;
            KeyManager[] keyManagers = null;
            try {
                String filename = setup.get("auth.keystore.file", ".keystore");
                String pswd = setup.get("keystore.password", setup.get("auth.keystore.password", "bgbilling"));
                KeyStore ksKeys = KeyStore.getInstance("JKS");
                File file = new File(filename);
                if (file.exists() && file.isFile()) {
                    ksKeys.load(new FileInputStream(file), pswd.toCharArray());
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ksKeys, pswd.toCharArray());
                    keyManagers = kmf.getKeyManagers();
                    this.sslContext = SSLContext.getInstance("TLS");
                    this.sslContext.init(keyManagers, trustManagers, null);
                } else {
                    log.info("Eap not enabled (keystore file not loaded).");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public TLSTunnel createTunnel() {
            if (this.sslContext == null) {
                throw new IllegalStateException();
            }
            return new TLSTunnel(this.sslContext, this.needAuth);
        }
    }
}

