/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client.device;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGFilterPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.filter.FilterEntityAttr;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFilter;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceForm;
import ru.bitel.oss.systems.inventory.resource.client.device.DeviceFormMain;
import ru.bitel.oss.systems.inventory.resource.client.device.port.DeviceInterfacePanel;
import ru.bitel.oss.systems.inventory.resource.common.DeviceManagerMethodType;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.service.DeviceService;

public abstract class DevicePanel<D extends Device<D, T>, T extends DeviceType>
extends BGUPanel {
    public static final int MODE_EDIT = 1;
    public static final int MODE_SELECT = 2;
    public static final int MODE_FILTER = 3;
    public static final int MODE_FILTER_SOURCE = 4;
    public static final String ACTION_DEVICE_SELECT = "device.select";
    public static final String ACTION_DEVICE_SELECTED = "device.selected";
    protected final Icon iconRoot = ClientUtils.getIcon("fugue/globe-network");
    protected final Icon iconNode = ClientUtils.getIcon("fugue/server-network");
    protected final Icon iconLeaf = ClientUtils.getIcon("fugue/network-ethernet");
    protected final Icon iconFolder = ClientUtils.getIcon("fugue/folder-network");
    private BGEditor editor;
    private BGUTreeTable deviceTable;
    private Supplier<Map<Integer, T>> deviceTypeMap;
    private ActionListener actionListener;
    private int oldMenuDeviceTypeId = Integer.MIN_VALUE;
    private JSeparator menuSeparator = new JSeparator();
    private List<JMenuItem> oldMenuItemList = new ArrayList<JMenuItem>();
    protected int mode;
    protected String rootTitle = "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430";
    protected String rootTitleSuffix = "";
    protected D selectedDevice;
    protected Calendar currentDay = new GregorianCalendar();
    protected DeviceFilter<D, T> filter;
    protected Set<Integer> defaultDeviceTypeIds;
    public BGTreeTableModel<D> model;
    Action refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        @Override
        public void actionPerformedImpl(ActionEvent e) throws Exception {
            SwingWorker worker;
            Device selected;
            int _selectedId = Utils.parseInt(e.getActionCommand(), -1);
            if (_selectedId <= 0 && (selected = (Device)DevicePanel.this.model.getSelectedRow()) != null) {
                _selectedId = selected.getId();
            }
            final int selectedId = _selectedId;
            DevicePanel.this.deviceTypeMap = Async.of(() -> Id.newMap(((ClientContext)DevicePanel.this.getContext()).getDirectory(DevicePanel.this.getDeviceTypeClass()).list()));
            if (DevicePanel.this.mode == 4) {
                worker = new SwingWorker<D, Void>(){

                    @Override
                    protected D doInBackground() throws Exception {
                        return DevicePanel.this.deviceSourceRoot();
                    }

                    @Override
                    protected void done() {
                        try {
                            DevicePanel.this.setData((Device)this.get(), selectedId);
                        }
                        catch (Exception e) {
                            ((ClientContext)DevicePanel.this.getContext()).processException(e);
                        }
                    }
                };
            } else {
                Date intersectDateTo;
                Date dateTo;
                Date dateFrom;
                final String identifier = DevicePanel.this.filter.mainFilter.identifier.getText();
                final String host = DevicePanel.this.filter.mainFilter.host.getText();
                IdTitle deviceType = (IdTitle)DevicePanel.this.filter.mainFilter.deviceType.getSelectedItem();
                Set<Integer> deviceGroups = DevicePanel.this.filter.mainFilter.deviceGroup.getChecked();
                IdTitle idTitle = (IdTitle)DevicePanel.this.filter.mainFilter.deviceActive.getSelectedItem();
                int deviceActiveId = idTitle == null ? 0 : idTitle.getId();
                Date intersectDateFrom = switch (deviceActiveId) {
                    case 1 -> {
                        dateFrom = null;
                        dateTo = null;
                        yield intersectDateTo = new Date();
                    }
                    case 2 -> {
                        dateFrom = null;
                        dateTo = TimeUtils.nowPlusPeriod(5, -1);
                        intersectDateTo = null;
                        yield null;
                    }
                    default -> {
                        dateTo = null;
                        dateFrom = null;
                        intersectDateTo = null;
                        yield null;
                    }
                };
                Object deviceTypeIds = deviceType == null ? null : (deviceType.getId() == -2 ? DevicePanel.this.defaultDeviceTypeIds : (deviceType.getId() < 0 ? null : Collections.singleton(deviceType.getId())));
                List<FilterEntityAttr> filters = DevicePanel.this.filter.getFilters();
                worker = new SwingWorker<D, Void>((Set)deviceTypeIds, deviceGroups, dateFrom, dateTo, intersectDateFrom, intersectDateTo, filters, selectedId){
                    final /* synthetic */ Set val$deviceTypeIds;
                    final /* synthetic */ Set val$deviceGroups;
                    final /* synthetic */ Date val$dateFrom;
                    final /* synthetic */ Date val$dateTo;
                    final /* synthetic */ Date val$intersectDateFrom;
                    final /* synthetic */ Date val$intersectDateTo;
                    final /* synthetic */ List val$filters;
                    final /* synthetic */ int val$selectedId;
                    {
                        this.val$deviceTypeIds = set;
                        this.val$deviceGroups = set2;
                        this.val$dateFrom = date;
                        this.val$dateTo = date2;
                        this.val$intersectDateFrom = date3;
                        this.val$intersectDateTo = date4;
                        this.val$filters = list;
                        this.val$selectedId = n;
                    }

                    @Override
                    protected D doInBackground() throws Exception {
                        return DevicePanel.this.deviceRoot(identifier, host, this.val$deviceTypeIds, this.val$deviceGroups, this.val$dateFrom, this.val$dateTo, this.val$intersectDateFrom, this.val$intersectDateTo, this.val$filters);
                    }

                    @Override
                    protected void done() {
                        DevicePanel.this.rootTitleSuffix = this.val$deviceTypeIds != null && this.val$deviceTypeIds.size() > 0 || Utils.notBlankString(identifier) || Utils.notBlankString(host) || this.val$deviceGroups != null && this.val$deviceGroups.size() > 0 || DevicePanel.this.filter.getFilters() != null && DevicePanel.this.filter.getFilters().size() > 0 ? " (\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0444\u0438\u043b\u044c\u0442\u0440)" : "";
                        try {
                            DevicePanel.this.setData((Device)this.get(), this.val$selectedId);
                        }
                        catch (Exception e) {
                            ((ClientContext)DevicePanel.this.getContext()).processException(e);
                        }
                    }
                };
            }
            if ((DevicePanel.this.mode == 3 || DevicePanel.this.mode == 4) && DevicePanel.this.model.getRoot() == null) {
                DevicePanel.this.model.setData(DevicePanel.this.getLoadingStateRoot());
                worker.execute();
            } else {
                worker.run();
            }
        }
    };

    protected abstract Class<D> getDeviceClass();

    protected abstract Class<T> getDeviceTypeClass();

    public abstract D newDevice();

    public abstract T newDeviceType(int var1, String var2);

    public abstract DeviceService<D, T> getWs();

    public DevicePanel(ClientContext ctx, int mode, ActionListener actionListener) {
        super((LayoutManager)new BorderLayout(), ctx);
        this.mode = mode;
        this.actionListener = actionListener;
        this.model = this.newModel();
        if (mode == 2) {
            new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DevicePanel.this.selectedDevice = (Device)DevicePanel.this.model.getSelectedRow();
                    if (DevicePanel.this.selectedDevice == null) {
                        ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                        return;
                    }
                    DevicePanel.this.performDeviceSelected();
                    DevicePanel.this.performActionClose();
                }
            };
            new AbstractBGUPanel.DefaultAction(ACTION_DEVICE_SELECT, "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DevicePanel.this.performAction("refresh", e.getActionCommand());
                    DevicePanel.this.performActionOpen();
                }
            };
        }
    }

    @Override
    protected void jbInit() {
        this.deviceTable = new BGUTreeTable(this.model);
        this.filter = new DeviceFilter(this, (ClientContext)this.getContext());
        JPanel rightPanel = new JPanel(new BorderLayout());
        BGFilterPane splitPane = new BGFilterPane(this.mode != 1);
        if (this.mode == 1) {
            this.editor = new BGEditor("table");
            JPanel tablePanel = new JPanel(new BorderLayout());
            tablePanel.setName("table");
            tablePanel.add((Component)new JScrollPane(this.deviceTable), "Center");
            rightPanel.add((Component)this.editor, "Center");
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(tablePanel);
            this.editor.addForm(this.treeWrap(splitPane), "table");
            if (this.needInterfacePanel()) {
                this.editor.addForm(new DeviceInterfacePanel<D>(this, this.model, (ClientContext)this.getContext()));
            }
            this.initEditor(this.editor);
            this.add((Component)this.editor, "Center");
            BGSwingUtilites.handleEdit(this.deviceTable, this);
        } else if (this.mode == 3 || this.mode == 4) {
            this.deviceTable.setSelectionMode(this.mode == 3 ? 2 : 0);
            this.deviceTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DevicePanel.this.performDeviceSelected();
                }
            });
            JButton buttonClearSelect = new JButton();
            buttonClearSelect.setActionCommand("clear");
            buttonClearSelect.setMargin(new Insets(2, 2, 2, 2));
            buttonClearSelect.setText("\u0421\u0431\u0440\u043e\u0441");
            buttonClearSelect.addActionListener(e -> {
                this.model.setSelectedRows(Collections.emptyList());
                this.performDeviceSelected();
            });
            JPanel controlPanel = new JPanel(new GridBagLayout());
            controlPanel.add((Component)buttonClearSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 0), 0, 0));
            rightPanel.add((Component)new JScrollPane(this.deviceTable), "Center");
            rightPanel.add((Component)controlPanel, "South");
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(rightPanel);
            this.add((Component)splitPane, "Center");
        } else {
            this.deviceTable.setSelectionMode(2);
            rightPanel.add((Component)new JScrollPane(this.deviceTable), "Center");
            splitPane.setFilterComponent(this.filter);
            splitPane.setDataComponent(rightPanel);
            this.add((Component)splitPane, "Center");
        }
        if (this.mode == 1) {
            final JPopupMenu popupMenu = this.deviceTable.getComponentPopupMenu();
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    DevicePanel.this.updateDeviceManagerMethodList(popupMenu);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
    }

    public Icon getIcon(D value) {
        if (value == null) {
            return this.iconRoot;
        }
        if (value.getDeviceTypeId() == 0) {
            return this.iconFolder;
        }
        if (this.model.isLeaf(value)) {
            return this.iconLeaf;
        }
        return this.iconNode;
    }

    protected String getTitle(D val, Calendar calendar) {
        Object result = val.getTitle();
        if (val.getDateTo() != null) {
            calendar.setTime(val.getDateTo());
            if (TimeUtils.dateBefore(calendar, this.currentDay)) {
                result = "<html><font color='#666666'>" + (String)result + "</font></html>";
            }
        }
        return result;
    }

    protected boolean needInterfacePanel() {
        return true;
    }

    protected BGTreeTableModel<D> newModel() {
        return new DeviceTableModel();
    }

    public boolean isLibrary() {
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void updateDeviceManagerMethodList(JPopupMenu popupMenu) {
        Device d = (Device)this.model.getSelectedRow();
        if (d != null && d.getDeviceTypeId() == this.oldMenuDeviceTypeId) {
            return;
        }
        for (JMenuItem m : this.oldMenuItemList) {
            popupMenu.remove(m);
        }
        popupMenu.remove(this.menuSeparator);
        this.oldMenuItemList.clear();
        if (d == null) {
            this.oldMenuDeviceTypeId = Integer.MIN_VALUE;
            return;
        }
        this.oldMenuDeviceTypeId = d.getDeviceTypeId();
        try {
            List methodList = this.getWs().deviceManagerMethodList(d.getDeviceTypeId());
            boolean separatorAdded = popupMenu.getComponentCount() == 0;
            for (final DeviceManagerMethod m : methodList) {
                if (!m.getTypes().contains(DeviceManagerMethodType.DEVICE)) continue;
                if (!separatorAdded) {
                    popupMenu.add(this.menuSeparator);
                    separatorAdded = true;
                }
                AbstractBGUPanel.DefaultAction action = new AbstractBGUPanel.DefaultAction("command." + m.getMethod(), m.getTitle(), (Icon)ClientUtils.getIcon("fugue/terminal-network")){

                    @Override
                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        try {
                            Device d = (Device)DevicePanel.this.model.getSelectedRow();
                            DevicePanel.this.executeCommand(d, m.getMethod());
                        }
                        catch (BGException ex) {
                            ((ClientContext)DevicePanel.this.getContext()).processException(ex);
                        }
                    }
                };
                JMenuItem menu = new JMenuItem(action);
                popupMenu.add(menu);
                this.oldMenuItemList.add(menu);
            }
        }
        catch (BGException ex) {
            ((ClientContext)this.getContext()).processException(ex);
        }
    }

    protected JComponent treeWrap(BGFilterPane splitPane) {
        return splitPane;
    }

    public D getSelectedDevice() {
        return this.selectedDevice;
    }

    public List<D> getSelectedDevices() {
        return this.model.getSelectedRows();
    }

    public Set<Integer> getSelectedDeviceIds() {
        return Utils.getIdSet(this.model.getSelectedRows());
    }

    protected void initEditor(BGEditor editor) {
        editor.addForm(new DeviceForm(this, (ClientContext)this.getContext()));
    }

    @Override
    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this);
    }

    protected abstract D getLoadingStateRoot();

    private int count(D root, int max) {
        int count = 0;
        List children = root.getChildren();
        if (children != null) {
            int size = children.size();
            if ((count += size) >= max) {
                return count;
            }
            for (int i = 0; i < size; ++i) {
                count += this.count((Device)children.get(i), max);
            }
        }
        return count;
    }

    private void setData(D root, int selectedId) {
        boolean isNeedExpand;
        this.model.setData(root);
        int count = this.count(root, 25);
        if (count <= 25) {
            this.deviceTable.expand();
        } else if (this.mode == 2 && (isNeedExpand = ClientSetup.getInstance().getModuleParameterPreferences(((ClientContext)this.getContext()).getModuleId()).getBoolean("client.gui.expand.device.tree", false))) {
            int depth = ClientSetup.getInstance().getModuleParameterPreferences(((ClientContext)this.getContext()).getModuleId()).getInt("client.gui.expand.device.tree.depth", 2);
            this.deviceTable.expand(depth);
        }
        Object[] findCodePath = null;
        if (selectedId > 0) {
            findCodePath = ((Device)this.model.getRoot()).findCodePath(selectedId);
        }
        if (findCodePath != null && findCodePath.length != 0) {
            TreePath path = new TreePath(findCodePath);
            this.deviceTable.expandPath(path);
            this.deviceTable.setSelectionPath(path);
            this.deviceTable.scrollPathToVisible(path);
        }
        if (this.editor != null) {
            this.editor.performAction(null, "refresh", "refresh");
        }
    }

    @Override
    protected void initActions() {
        if (this.mode == 2) {
            new AbstractBGUPanel.DefaultAction(ACTION_DEVICE_SELECT, "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DevicePanel.this.performAction("refresh", e.getActionCommand());
                    DevicePanel.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("ok", "Ok"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    DevicePanel.this.ok();
                }
            };
        }
    }

    protected void ok() {
        this.selectedDevice = (Device)this.model.getSelectedRow();
        if (this.selectedDevice == null) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            return;
        }
        this.performDeviceSelected();
        this.performActionClose();
    }

    protected void performDeviceSelected() {
        if (this.mode == 4) {
            DeviceType type;
            this.selectedDevice = (Device)this.model.getSelectedRow();
            if (!(this.selectedDevice == null || (type = (DeviceType)this.deviceTypeMap.get().get(this.selectedDevice.getDeviceTypeId())) != null && type.isSource())) {
                this.selectedDevice = null;
            }
        }
        this.actionListener.actionPerformed(new ActionEvent(this, 0, ACTION_DEVICE_SELECTED));
    }

    public D deviceGet(int id) throws BGException {
        return (D)this.getWs().deviceGet(id);
    }

    public void deviceDelete(int id) throws BGException {
        this.getWs().deviceDelete(id);
    }

    public int deviceUpdate(D device) throws BGException {
        return this.getWs().deviceUpdate(device);
    }

    public void deviceMove(int id, Set<Integer> cutSet) throws BGException {
        this.getWs().deviceMove(id, cutSet);
    }

    public abstract D deviceSourceRoot() throws BGException;

    public D deviceRoot(String identifier, String host, Set<Integer> deviceTypeIds, Set<Integer> deviceGroupIds, Date dateFrom, Date dateTo, Date intersectDateFrom, Date intersectDateTo, List<FilterEntityAttr> entityFilter) throws BGException {
        return (D)this.getWs().deviceRoot(identifier, host, deviceTypeIds, deviceGroupIds, dateFrom, dateTo, intersectDateFrom, intersectDateTo, entityFilter, false);
    }

    public int getInvDeviceId(D device) {
        return device.getId();
    }

    protected BGUPanel newMainForm(AtomicReference<D> currentRef) {
        return new DeviceFormMain(this, currentRef);
    }

    protected void executeCommand(D device, String operation) throws BGException {
    }

    protected class DeviceTableModel
    extends BGTreeTableModel<D> {
        private final Calendar calendar;
        protected int invDeviceIdCol;

        public DeviceTableModel() {
            super("device", DevicePanel.this.getDeviceClass());
            this.calendar = new GregorianCalendar();
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", Device.class, -1, 300, -1, "title", false);
            if (DevicePanel.this.mode != 3) {
                this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", "comment", false);
                if (!DevicePanel.this.isLibrary() && DevicePanel.this.mode == 1) {
                    this.addColumn("InvDeviceID", -1, 60, 80, "invDeviceId", false).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
                    this.invDeviceIdCol = 2;
                }
                this.addColumnId(false);
            }
        }

        @Override
        public Object getValue(D val, int column) throws BGException {
            DeviceType type;
            Object value = null;
            switch (column) {
                case 0: {
                    if (val == this.root) {
                        if (val.getId() == -1) {
                            value = "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0434\u0435\u0440\u0435\u0432\u0430...";
                            break;
                        }
                        value = DevicePanel.this.rootTitle + DevicePanel.this.rootTitleSuffix;
                        break;
                    }
                    value = DevicePanel.this.getTitle(val, this.calendar);
                    break;
                }
                default: {
                    value = super.getValue(val, column);
                }
            }
            if (column == this.invDeviceIdCol && !DevicePanel.this.isLibrary() && DevicePanel.this.mode == 1) {
                value = "<html><font color='#666666'>" + value + "</font></html>";
            }
            if (DevicePanel.this.mode == 4 && value != null && (type = (DeviceType)DevicePanel.this.deviceTypeMap.get().get(val.getDeviceTypeId())) != null && !type.isSource()) {
                value = "<html><span style=\"color: #CCCCCC; text-decoration: line-through;\">" + value + "</span></html>";
            }
            return value;
        }

        @Override
        public Icon getIcon(D value) {
            if (value == this.root) {
                return DevicePanel.this.getIcon(null);
            }
            return DevicePanel.this.getIcon(value);
        }
    }
}

