/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractNoteDao
extends AbstractIdDao<ContractNote> {
    public ContractNoteDao(Connection con) {
        super(con, 0, "contract_comment");
    }

    @Override
    protected ContractNote getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractNote result = new ContractNote();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setDateTime(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("dt")));
        result.setUserId(rs.getInt("uid"));
        result.setTitle(rs.getString("subject"));
        result.setComment(rs.getString("comment"));
        result.setVisible(rs.getBoolean("visibled"));
        return result;
    }

    @Override
    protected void updateImpl(ContractNote note) throws BGException, SQLException {
        boolean update = note.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET subject=?, comment=?, uid=?, visibled=?, dt=NOW(), cid=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, note.getTitle());
            ps.setString(index++, note.getComment());
            ps.setInt(index++, note.getUserId());
            ps.setBoolean(index++, note.isVisible());
            ps.setInt(index++, note.getContractId());
            if (update) {
                ps.setInt(index++, note.getId());
            }
            ps.executeUpdate();
            if (!update) {
                note.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<ContractNote> list(int contractId, boolean onlyForCustomer) throws BGException {
        return this.list("cid=? " + (onlyForCustomer ? " AND visibled=true" : ""), "dt DESC", contractId);
    }
}

