/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.MenuItem;
import ru.bitel.common.dao.AbstractIdDao;

public class UserMenuDao
extends AbstractIdDao<MenuItem> {
    public UserMenuDao(Connection con) {
        super(con, 0, "bgs_menu");
    }

    public List<MenuItem> list() throws BGException {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery("SELECT " + "*" + " FROM " + this.tableName + " ORDER BY " + "title");
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
            rs.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return list;
    }

    public String getData(int webMenuItemId) throws BGException {
        String data = null;
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery("SELECT " + "data" + " FROM " + this.tableName + " WHERE " + "id=" + webMenuItemId);
            while (rs.next()) {
                data = rs.getString(1);
            }
            rs.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return data;
    }

    public void updateData(int webMenuItemId, String data) throws BGException {
        if (webMenuItemId < 1) {
            return;
        }
        String query = "UPDATE " + this.tableName + " SET " + "data=?" + " WHERE " + "id=" + webMenuItemId;
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, data);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    @Override
    protected MenuItem getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.ormFromResultSet(rs, MenuItem.class);
    }

    @Override
    protected void updateImpl(MenuItem menuItem) throws BGException, SQLException {
        this.ormUpdateImpl(menuItem);
        if (menuItem.isDefault()) {
            try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET `default`=0 WHERE id<>? ");){
                ps.setInt(1, menuItem.getId());
                ps.executeUpdate();
            }
        }
    }

    public void setUserCount(List<MenuItem> list) throws BGException {
        if (list != null && !list.isEmpty()) {
            try (Statement statement = this.con.createStatement();
                 ResultSet rs = statement.executeQuery("SELECT `menu_id`, count(*) FROM `user` GROUP BY `menu_id`");){
                block12: while (rs.next()) {
                    int menuId = rs.getInt(1);
                    for (MenuItem menuItem : list) {
                        if (menuItem.getId() != menuId) continue;
                        menuItem.setUserCount(rs.getInt(2));
                        continue block12;
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
    }
}

