/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.util;

import bitel.billing.module.common.MaskInputTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class TimeLimits
extends JPanel {
    private long _b_minute;
    private long _b_hour;
    private long _b_dayOfMonth;
    private long _b_dayOfWeek;
    private long _b_month;
    private MaskInputTextField _minute = new MaskInputTextField(0, 60, 20);
    private MaskInputTextField _hour = new MaskInputTextField(0, 24, 20);
    private MaskInputTextField _dayOfMonth = new MaskInputTextField(1, 31, 20);
    private MaskInputTextField _dayOfWeek = new MaskInputTextField(1, 7, 20);
    private MaskInputTextField _month = new MaskInputTextField(1, 12, 20);

    public TimeLimits() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this._minute, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0427\u0430\u0441\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this._hour, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446\u044b:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this._month, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this._dayOfMonth, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this._dayOfWeek, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        BGButtonPanelOkCancel yesNoPane = new BGButtonPanelOkCancel();
        this.add((Component)yesNoPane, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        yesNoPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command != null) {
                    if (command.equals("ok")) {
                        TimeLimits.this.setVisible(false);
                    } else if (command.equals("cancel")) {
                        TimeLimits.this.restoreValues();
                        TimeLimits.this.setVisible(false);
                    }
                }
            }
        });
    }

    public void setData(String data) {
        if (Utils.isEmptyString(data)) {
            this._minute.setLong(0L);
            this._hour.setLong(0L);
            this._month.setLong(0L);
            this._dayOfMonth.setLong(0L);
            this._dayOfWeek.setLong(0L);
        } else {
            StringTokenizer st = new StringTokenizer(data, "_");
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                String value = st.nextToken();
                if (key.equals("minute")) {
                    this._minute.setLong(Utils.parseLong(value, 0L));
                    continue;
                }
                if (key.equals("hour")) {
                    this._hour.setLong(Utils.parseLong(value, 0L));
                    continue;
                }
                if (key.equals("month")) {
                    this._month.setLong(Utils.parseLong(value, 0L));
                    continue;
                }
                if (key.equals("dayOfMonth")) {
                    this._dayOfMonth.setLong(Utils.parseLong(value, 0L));
                    continue;
                }
                if (!key.equals("dayOfWeek")) continue;
                this._dayOfWeek.setLong(Utils.parseLong(value, 0L));
            }
        }
    }

    public String getData() {
        StringBuffer result = new StringBuffer();
        result.append("minute");
        result.append("_");
        result.append(String.valueOf(this._minute.getLong()));
        result.append("_");
        result.append("hour");
        result.append("_");
        result.append(String.valueOf(this._hour.getLong()));
        result.append("_");
        result.append("month");
        result.append("_");
        result.append(String.valueOf(this._month.getLong()));
        result.append("_");
        result.append("dayOfMonth");
        result.append("_");
        result.append(String.valueOf(this._dayOfMonth.getLong()));
        result.append("_");
        result.append("dayOfWeek");
        result.append("_");
        result.append(String.valueOf(this._dayOfWeek.getLong()));
        return result.toString();
    }

    @Override
    public String toString() {
        String result = "\u041f\u0443\u0441\u0442\u043e\u0439 \u043d\u0430\u0431\u043e\u0440!";
        StringBuffer sb = new StringBuffer();
        if (this._minute.getLong() != 0L) {
            sb.append("\u041c\u0438\u043d\u0443\u0442\u044b => " + this._minute.getText() + "; ");
        }
        if (this._hour.getLong() != 0L) {
            sb.append("\u0427\u0430\u0441\u044b => " + this._hour.getText() + "; ");
        }
        if (this._month.getLong() != 0L) {
            sb.append("\u041c\u0435\u0441\u044f\u0446\u044b => " + this._month.getText() + "; ");
        }
        if (this._dayOfMonth.getLong() != 0L) {
            sb.append("\u0427\u0438\u0441\u043b\u0430 \u043c\u0435\u0441\u044f\u0446\u0430 => " + this._dayOfMonth.getText() + "; ");
        }
        if (this._dayOfWeek.getLong() != 0L) {
            sb.append("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438 => " + this._dayOfWeek.getText() + "; ");
        }
        if (sb.length() != 0) {
            result = sb.toString().endsWith("; ") ? sb.substring(0, sb.length() - 2) : sb.toString();
        }
        return result.toString();
    }

    public void startEdit() {
        this._b_minute = this._minute.getLong();
        this._b_hour = this._hour.getLong();
        this._b_dayOfMonth = this._dayOfMonth.getLong();
        this._b_dayOfWeek = this._dayOfWeek.getLong();
        this._b_month = this._month.getLong();
    }

    private void restoreValues() {
        this._minute.setLong(this._b_minute);
        this._hour.setLong(this._b_hour);
        this._dayOfMonth.setLong(this._b_dayOfMonth);
        this._dayOfWeek.setLong(this._b_dayOfWeek);
        this._month.setLong(this._b_month);
    }
}

