/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.util;

import bitel.billing.module.tariff.util.TimeLimits;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class TimeLimitPeriods
extends JPanel {
    private CardLayout editorLayout = new CardLayout();
    private JPanel editor = new JPanel(this.editorLayout);
    private DefaultListModel<TimeLimitsValue> limitsListModel = new DefaultListModel();
    private JList<TimeLimitsValue> limitsList = new JList<TimeLimitsValue>(this.limitsListModel);
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private TimeLimits limitsEditor = new TimeLimits();
    private TimeLimitsValue currentTimelLimitValue = null;
    private String b_value = "";
    private String b_date1 = null;
    private String b_date2 = null;

    public TimeLimitPeriods() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane limitsScroll = new JScrollPane(this.limitsList);
        JPanel editorListPanel = new JPanel(new GridBagLayout());
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeLimitPeriods.this.toolBarAction(e);
            }
        });
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.setToolBar(new String[]{"newItem", "deleteItem", "editItem"});
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        editorListPanel.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        editorListPanel.add((Component)toolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        editorListPanel.add((Component)limitsScroll, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        editorListPanel.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.editor.add((Component)editorListPanel, "list");
        this.editor.add((Component)this.limitsEditor, "edit");
        this.limitsEditor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TimeLimitPeriods.this.saveValues();
                TimeLimitPeriods.this.editorLayout.show(TimeLimitPeriods.this.editor, "list");
            }
        });
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command != null) {
                    if (command.equals("ok")) {
                        TimeLimitPeriods.this.setVisible(false);
                    } else if (command.equals("cancel")) {
                        TimeLimitPeriods.this.restoreValues();
                        TimeLimitPeriods.this.setVisible(false);
                    }
                }
            }
        });
        this.limitsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TimeLimitPeriods.this.editSelectedTl();
                }
            }
        });
    }

    public void setData(String data) {
        StringTokenizer st = new StringTokenizer(data, ">");
        if (st.countTokens() > 1) {
            String period = st.nextToken();
            String[] s = period.split("-");
            if (s.length > 1) {
                if (Utils.isEmptyString(s[0]) || s[0].equals("any")) {
                    s[0] = null;
                }
                if (Utils.isEmptyString(s[1]) || s[1].equals("any")) {
                    s[1] = null;
                }
                this.periodPanel.setDateString1(s[0]);
                this.periodPanel.setDateString2(s[1]);
            } else {
                this.periodPanel.setDateString1("");
                this.periodPanel.setDateString2("");
            }
        }
        this.loadData(st.nextToken());
    }

    private void loadData(String data) {
        this.limitsListModel.clear();
        StringTokenizer st = new StringTokenizer(data, "%");
        TimeLimits tl = new TimeLimits();
        while (st.hasMoreTokens()) {
            TimeLimitsValue limit = new TimeLimitsValue();
            tl.setData(st.nextToken());
            limit.setData(tl);
            this.limitsListModel.addElement(limit);
        }
    }

    private void toolBarAction(ActionEvent e) {
        String command = e.getActionCommand();
        if (command != null) {
            int pos;
            if (command.equals("newItem")) {
                TimeLimitsValue tl = new TimeLimitsValue();
                this.limitsListModel.addElement(tl);
                this.editTimeLimits(tl);
            } else if (command.equals("editItem")) {
                this.editSelectedTl();
            } else if (command.equals("deleteItem") && (pos = this.limitsList.getSelectedIndex()) >= 0) {
                this.limitsListModel.remove(pos);
            }
        }
    }

    private void editSelectedTl() {
        TimeLimitsValue timeLimitsValue = this.limitsList.getSelectedValue();
        if (timeLimitsValue != null) {
            this.editTimeLimits(timeLimitsValue);
        }
    }

    private void saveValues() {
        this.currentTimelLimitValue.setData(this.limitsEditor);
        this.limitsList.repaint();
    }

    private void editTimeLimits(TimeLimitsValue timeLimitsValue) {
        this.currentTimelLimitValue = timeLimitsValue;
        this.limitsEditor.setData(timeLimitsValue.getData());
        this.limitsEditor.startEdit();
        this.editorLayout.show(this.editor, "edit");
    }

    public String getData() {
        StringBuilder data = new StringBuilder(200);
        String date1 = this.periodPanel.getDateString1();
        String date2 = this.periodPanel.getDateString2();
        data.append(Utils.isEmptyString(date1) ? "any" : date1);
        data.append("-");
        data.append(Utils.isEmptyString(date2) ? "any" : date2);
        data.append(">");
        boolean first = true;
        int size = this.limitsListModel.getSize();
        for (int i = 0; i < size; ++i) {
            TimeLimitsValue limits = this.limitsListModel.get(i);
            if (!first) {
                data.append("%");
            } else {
                first = false;
            }
            data.append(limits.getData());
        }
        if (size == 0) {
            TimeLimits limits = new TimeLimits();
            data.append(limits.getData());
        }
        return data.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String date1 = this.periodPanel.getDateString1();
        String date2 = this.periodPanel.getDateString2();
        sb.append(Utils.isEmptyString(date1) ? " " : date1);
        sb.append(" - ");
        sb.append(Utils.isEmptyString(date2) ? " " : date2);
        return sb.toString();
    }

    public void startEdit() {
        this.b_date1 = this.periodPanel.getDateString1();
        this.b_date2 = this.periodPanel.getDateString2();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int size = this.limitsListModel.getSize();
        for (int i = 0; i < size; ++i) {
            TimeLimitsValue limits = this.limitsListModel.get(i);
            if (!first) {
                sb.append("%");
            } else {
                first = false;
            }
            sb.append(limits.getData());
        }
        this.b_value = sb.toString();
    }

    private void restoreValues() {
        this.periodPanel.setDateString1(this.b_date1);
        this.periodPanel.setDateString2(this.b_date2);
        this.loadData(this.b_value);
    }

    private class TimeLimitsValue {
        private String data = "";
        private String text = " ";

        private TimeLimitsValue() {
        }

        public String toString() {
            return this.text;
        }

        public void setData(TimeLimits tl) {
            this.data = tl.getData();
            this.text = tl.toString();
        }

        public String getData() {
            return this.data;
        }
    }
}

