/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractPatternService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class NumberPatternEditor
extends BGPanel {
    private ContractPatternNamedNumber namedNumber = null;
    private ContractPatternService contractPatternService = null;
    private BGTableModel<ContractPatternNamedNumber> model;
    private BGUTable table = new BGUTable(this.model);
    private BGPanel editPanel = new BGPanel();
    private BGTextField fieldName = new BGTextField();
    private BGTextField fieldComment = new BGTextField();
    private IntTextField fieldIndex = new IntTextField(0);
    private IntTextField fieldCount = new IntTextField(0);
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    public NumberPatternEditor() {
        try {
            this.fieldIndex.setMaxValue(Integer.MAX_VALUE);
            this.fieldCount.setMaxValue(10L);
            this.model = new BGTableModel<ContractPatternNamedNumber>(""){

                @Override
                protected void initColumns() {
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 150, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
                    this.addColumn("\u0418\u043d\u0434\u0435\u043a\u0441", -1, 150, -1, "index", true, DecimalTableCellRenderer.INTEGER());
                    this.addColumn("\u041a\u043e\u043b-\u0432\u043e \u0446\u0438\u0444\u0440", -1, 150, -1, "countNumber", true, DecimalTableCellRenderer.INTEGER());
                }
            };
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() == 2) {
                        NumberPatternEditor.this.editItem();
                    }
                }
            });
            this.okCancel.addActionListener(e -> {
                String command = e.getActionCommand();
                if (command != null) {
                    try {
                        if (command.equals("ok")) {
                            this.namedNumber.setTitle(this.fieldName.getText());
                            this.namedNumber.setComment(this.fieldComment.getText());
                            this.namedNumber.setIndex(Utils.parseInt(this.fieldIndex.getText()));
                            this.namedNumber.setCountNumber(Utils.parseInt(this.fieldCount.getText()));
                            this.getContractPatternService().updateNamedNumber(this.namedNumber);
                            this.setData();
                            this.editPanel.setVisible(false);
                            this.table.setEnabled(true);
                        } else {
                            this.table.setEnabled(true);
                            this.editPanel.setVisible(false);
                            this.fieldIndex.setEnabled(true);
                            this.fieldCount.setEnabled(true);
                        }
                    }
                    catch (BGException e1) {
                        this.getContext().processException(e1);
                    }
                }
            });
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.packEditPanel();
        this.table.setModel(this.model);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.editPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.05, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void packEditPanel() {
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.fieldName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.fieldComment, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("\u0418\u043d\u0434\u0435\u043a\u0441:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.fieldIndex, new GridBagConstraints(5, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 15), 0, 0));
        this.editPanel.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e \u0446\u0438\u0444\u0440:"), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.fieldCount, new GridBagConstraints(7, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 15), 0, 0));
        this.editPanel.add((Component)this.okCancel, new GridBagConstraints(0, 2, 8, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.editPanel.setVisible(false);
    }

    @Override
    public void setData() {
        try {
            this.model.setData(this.getContractPatternService().numedNumberPatternList());
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    public void newItem() {
        this.editPanel.setVisible(true);
        this.namedNumber = new ContractPatternNamedNumber();
        this.fieldName.setText("");
        this.fieldComment.setText("");
        this.fieldIndex.setValue(0L);
        this.fieldCount.setValue(5L);
        this.table.setEnabled(false);
        this.fieldName.requestFocus();
    }

    @Override
    public void editItem() {
        this.namedNumber = this.model.getSelectedRow();
        if (this.namedNumber != null) {
            this.table.setEnabled(false);
            this.fieldName.setText(this.model.getSelectedRow().getTitle());
            this.fieldComment.setText(this.model.getSelectedRow().getComment());
            this.fieldIndex.setValue(this.model.getSelectedRow().getIndex());
            this.fieldIndex.setEnabled(false);
            this.fieldCount.setValue(this.model.getSelectedRow().getCountNumber());
            this.fieldCount.setEnabled(false);
            this.editPanel.setVisible(true);
        }
    }

    @Override
    public void deleteItem() {
        this.namedNumber = this.model.getSelectedRow();
        if (this.namedNumber != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432?", "", 0, 3) == 0) {
            try {
                this.getContractPatternService().deleteNamedNumber(this.namedNumber.getId());
                this.setData();
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }
    }

    private ContractPatternService getContractPatternService() {
        if (this.contractPatternService == null) {
            this.contractPatternService = this.getContext().getPort(ContractPatternService.class);
        }
        return this.contractPatternService;
    }
}

