/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.contract.ContractSubPanel;
import bitel.billing.module.contract.ContractSubPanel_Mode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class ContractSubPanelModeFaceBase
extends ContractSubPanel {
    protected JPanel parentPanel;
    protected int selectedIndex = 0;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JComboBox<ComboBoxItem> comboBox = new JComboBox();
    private BGButton aplButton = new BGButton();
    private TableModel tableModel = new TableModel(TableModel.class.getName());
    private BGUTable table = new BGUTable(this.tableModel);

    public ContractSubPanelModeFaceBase() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pagePanel.setKey(ContractSubPanel_Mode.class.getName());
    }

    private void jbInit() throws Exception {
        this.aplButton.setText("OK");
        this.aplButton.setActionCommand("ok");
        this.aplButton.addActionListener(e -> this.aplButton_actionPerformed(e));
        this.pagePanel.setBorder(new BGTitleBorder(" \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "));
        this.pagePanel.init();
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setData();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getStatePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getModeFacePanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getModeFacePanel() {
        this.comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.aplButton.setEnabled(this.comboBox.getSelectedIndex() > 0 && this.comboBox.getSelectedIndex() != this.selectedIndex);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(this.getBorderName()));
        panel.add(this.comboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.aplButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    protected String getBorderName() {
        return null;
    }

    protected String getTypePanel() {
        return null;
    }

    protected DefaultComboBoxModel<ComboBoxItem> getModel() {
        return null;
    }

    protected String getLoadAction() {
        return "ContractModeFaceBase";
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.getLoadAction());
        request.setContractId(this.getContractId());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        request.setAttribute("view", "0");
        request.setAttribute("type", this.getTypePanel());
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element tableNode = XMLUtils.selectElement(doc, "//table");
            ArrayList datas = new ArrayList();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            XMLUtils.selectElements(doc, "//table/data/row").forEach(e -> {
                RowData rowData = new RowData();
                rowData.date = TimeUtils.parseDate(e.getAttribute("date"), dateFormat);
                rowData.user = e.getAttribute("user");
                rowData.value = e.getAttribute("value");
                datas.add(rowData);
            });
            this.tableModel.setData(datas);
            if (this.getTypePanel().equals("face")) {
                this.comboBox.setModel(this.getModel());
                if ("0".equals(XMLUtils.getAttribute(tableNode, "face", "0"))) {
                    this.comboBox.setSelectedIndex(1);
                } else {
                    this.comboBox.setSelectedIndex(2);
                }
            } else {
                this.comboBox.setModel(this.getModel());
                if ("0".equals(XMLUtils.getAttribute(tableNode, "mode", "0"))) {
                    this.comboBox.setSelectedIndex(2);
                } else {
                    this.comboBox.setSelectedIndex(1);
                }
            }
            this.selectedIndex = this.comboBox.getSelectedIndex();
            this.aplButton.setEnabled(false);
            this.pagePanel.setPageCount(tableNode);
        }
    }

    private void aplButton_actionPerformed(ActionEvent e) {
        ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
        String value = String.valueOf(item.getObject());
        if (this.getTypePanel().equals("face")) {
            if (value.equals("0")) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0438\u0446\u043e");
                return;
            }
            if (this.doButton()) {
                if (value.equals("1")) {
                    this.updateData("SetFcContract", "0");
                }
                if (value.equals("2")) {
                    this.updateData("SetFcContract", "1");
                }
            } else {
                this.comboBox.setSelectedIndex(this.selectedIndex);
            }
        } else {
            if (value.equals("0")) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0435\u0442\u0435 \u0440\u0435\u0436\u0438\u043c");
                return;
            }
            if (value.equals("1")) {
                this.updateData("UpdateContractMode", "debet");
            }
            if (value.equals("2")) {
                this.updateData("UpdateContractMode", "credit");
            }
        }
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    protected boolean doButton() {
        return true;
    }

    protected String getTableHeader() {
        return "";
    }

    public class TableModel
    extends BGTableModel<RowData> {
        public TableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "date", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 250, 250, 250, "user", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn(ContractSubPanelModeFaceBase.this.getTableHeader(), 150, -1, -1, "value", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class RowData {
        Date date;
        String user;
        String value;

        public Date getDate() {
            return this.date;
        }

        public String getUser() {
            return this.user;
        }

        public String getValue() {
            return this.value;
        }
    }
}

