/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGPeriodModeButton;
import bitel.billing.module.common.ModelPeriod;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;

class BGNavButton
extends JButton {
    protected Calendar dateFrom;
    protected Calendar dateTo;
    protected final ModelPeriod model;
    protected boolean forward;
    protected String propertyName;
    protected BGPeriodModeButton modeButton;

    public BGNavButton(ModelPeriod model, BGPeriodModeButton modeButton) {
        this.model = model;
        this.modeButton = modeButton;
        this.setMargin(new Insets(0, 5, 0, 5));
        this.dateFrom = Calendar.getInstance();
        this.dateTo = Calendar.getInstance();
        this.jbInit();
    }

    public void setDateFrom(Calendar dateFrom) {
        this.dateFrom = dateFrom;
    }

    public void setDateTo(Calendar dateTo) {
        this.dateTo = dateTo;
    }

    public Calendar getDateFrom() {
        return this.dateFrom;
    }

    public Calendar getDateTo() {
        return this.dateTo;
    }

    protected void jbInit() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    switch (BGNavButton.this.modeButton.getMode()) {
                        case 0: {
                            int delta = TimeUtils.daysDelta(BGNavButton.this.dateFrom, BGNavButton.this.dateTo) + 1;
                            BGNavButton.this.dateFrom = BGNavButton.this.model.daysOperation(BGNavButton.this.dateFrom, BGNavButton.this.forward, delta);
                            BGNavButton.this.dateTo = BGNavButton.this.model.daysOperation(BGNavButton.this.dateTo, BGNavButton.this.forward, delta);
                            break;
                        }
                        case 1: {
                            BGNavButton.this.dateFrom = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateFrom, BGNavButton.this.forward, true);
                            BGNavButton.this.dateTo = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateTo, BGNavButton.this.forward, false);
                            break;
                        }
                        case 2: {
                            BGNavButton.this.dateFrom = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateFrom, BGNavButton.this.forward, true);
                            BGNavButton.this.dateTo = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateTo, BGNavButton.this.forward, false);
                            break;
                        }
                        case 3: {
                            BGNavButton.this.dateFrom = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateFrom, BGNavButton.this.forward, true);
                            BGNavButton.this.dateTo = BGNavButton.this.model.getDateToMode(BGNavButton.this.dateTo, BGNavButton.this.forward, false);
                        }
                    }
                    BGNavButton.this.firePropertyChange(BGNavButton.this.propertyName, true, false);
                }
                catch (BGException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }
}

