/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGControlPanelMonth;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class PeriodicErrorViewerPanel
extends BGPanel {
    private ErrorLogTableModel errorLogTableModel = new ErrorLogTableModel();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private BGControlPanelMonth monthPanel = new BGControlPanelMonth();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JLabel totalCount = new JLabel();
    private BGTextField subject = new BGTextField();
    private BGTextArea text = new BGTextArea();
    private BGTextField contains = new BGTextField();

    public PeriodicErrorViewerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.subject.setEditable(false);
        this.text.setEditable(false);
        this.pagePanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.setData();
            }
        });
        BGUTable table = new BGUTable(this.errorLogTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    PeriodicErrorViewerPanel.this.openRow();
                }
            }
        });
        JPanel pages = new JPanel(new GridBagLayout());
        pages.add((Component)this.totalCount, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        pages.add((Component)this.pagePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 5, 5), 0, 0));
        JPanel months = new JPanel(new GridBagLayout());
        months.setBorder(new BGTitleBorder("\u041c\u0435\u0441\u044f\u0446 \u043e\u0431\u0441\u0447\u0435\u0442\u0430"));
        months.add((Component)this.monthPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel period = new JPanel(new GridBagLayout());
        period.add((Component)this.periodPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        period.setBorder(new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434 \u0432\u043e\u0437\u043d\u0438\u043a\u043d\u043e\u0432\u0435\u043d\u0438\u044f \u043e\u0448\u0438\u0431\u043a\u0438"));
        JButton find = new JButton("\u041d\u0430\u0439\u0442\u0438");
        find.addActionListener(e -> this.setData());
        JPanel contPanel = new JPanel(new GridBagLayout());
        contPanel.add((Component)this.contains, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        contPanel.setBorder(new BGTitleBorder("\u0417\u0430\u043f\u0438\u0441\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442"));
        JPanel periods = new JPanel(new GridBagLayout());
        periods.add((Component)months, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        periods.add((Component)contPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        periods.add((Component)period, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        periods.add((Component)find, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        periods.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)periods, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        topPanel.add((Component)pages, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        topPanel.add((Component)new JScrollPane(table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)new JLabel("\u0422\u0435\u043c\u0430:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)this.subject, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)new JLabel("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)new JScrollPane(this.text), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        BGSplitPaneNoBorder split = new BGSplitPaneNoBorder(0, topPanel, (Component)bottomPanel, 500L);
        this.setLayout(new GridBagLayout());
        this.add((Component)split, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void openRow() {
        RowData rowData = (RowData)this.errorLogTableModel.getSelectedRow();
        if (rowData != null) {
            this.subject.setText(rowData.getJson().optString("subject"));
            this.text.setText(rowData.getJson().optString("comment"));
        }
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("admin.errorlog");
        request.setAction("GetPeriodicErrors");
        request.setAttribute("month", this.monthPanel.getDateString());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        request.setAttribute("contains", this.contains.getText().trim());
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.setDocument(doc);
        }
    }

    @Override
    public void setDocument(Document doc) {
        ArrayList<RowData> list = new ArrayList<RowData>();
        for (Element element : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            JSONObject json = new JSONObject();
            json.put("id", Utils.parseInt(element.getAttribute("id")));
            json.put("regdate", (Object)element.getAttribute("regdate"));
            json.put("calcdate", (Object)element.getAttribute("calcdate"));
            json.put("subject", (Object)element.getAttribute("subject"));
            json.put("comment", (Object)element.getAttribute("comment"));
            list.add(new RowData(json));
        }
        this.errorLogTableModel.setData(list);
        Element tableElement = XMLUtils.selectElement(doc, "/data/table");
        this.totalCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger(Utils.parseInt(tableElement.getAttribute("recordCount"))));
        this.pagePanel.setPageInfo(tableElement);
    }

    @Override
    public void deleteItem() {
        this.deleteRecords();
    }

    private void deleteRecords() {
        if (this.errorLogTableModel.getSelectedRows().isEmpty()) {
            ClientUtils.showMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u044c \u0436\u0443\u0440\u043d\u0430\u043b\u0430");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0431\u0435\u0437\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438 \u0438\u0437 \u0436\u0443\u0440\u043d\u0430\u043b\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
            Object ids = "";
            for (RowData rowData : this.errorLogTableModel.getSelectedRows()) {
                if (!((String)ids).isEmpty()) {
                    ids = (String)ids + ",";
                }
                ids = (String)ids + rowData.getJson().optString("id");
            }
            Request request = new Request();
            request.setModule("admin.errorlog");
            request.setAction("DeletePeriodicError");
            request.setAttribute("id", (String)ids);
            ClientUtils.checkStatus(TransferManager.getDocument(request));
            this.subject.setText("");
            this.text.setText("");
            this.setData();
        }
    }

    class ErrorLogTableModel
    extends BGTableModel<RowData> {
        static final String KEY_ID = "id";
        static final String KEY_REGDATE = "regdate";
        static final String KEY_CALCDATE = "calcdate";
        static final String KEY_SUBJECT = "subject";
        static final String KEY_COMMENT = "comment";

        public ErrorLogTableModel() {
            super(ErrorLogTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u0430\u0442\u0430 \u043e\u0448\u0438\u0431\u043a\u0438", 130, 130, 130, KEY_REGDATE, true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY());
            this.addColumn("\u041c\u0435\u0441\u044f\u0446 \u043e\u0431\u0441\u0447\u0435\u0442\u0430", 130, 130, 130, KEY_CALCDATE, true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0435\u043c\u0430", -1, -1, -1, KEY_SUBJECT, true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            switch (identifier) {
                case "id": {
                    return json.optInt(KEY_ID);
                }
            }
            return json.optString(identifier);
        }
    }
}

