<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<form method='get' action=''>

<input type="hidden" name="action" value="GateControl">
<input type="hidden" name="module" value="${dataMap['module'] }"/>
<input type="hidden" name="mid" value="${dataMap['mid'] }"/>

<%@include file="../include/error.jsp" %>
	
<c:if test="${dataMap['status'] == 2}">
	<div class="errorMessage">
		<br/>Сумму долга смотрите в разделе "Просмотр баланса"<br/>
	</div>
</c:if>

<table border='0' cellspacing='0' class="filter">
	<tr>
		<th nowrap='1'>Текущее состояние шлюза:</th>
		<td>
			<select name='status'>
				<c:choose>
					<c:when test="${dataMap['status'] == 0}">
						<option value="0" selected="selected">открыт</option>
					</c:when>
					<c:otherwise>
						<option value="0">открыт</option>
					</c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${dataMap['status'] == 1}">
						<option value="1" selected="selected">закрыт</option>
					</c:when>
					<c:otherwise>
						<option value="1">закрыт</option>
					</c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${dataMap['status'] == 2}">
						<option value="2" selected="selected">заблокирован</option>
					</c:when>
					<c:otherwise>
						<option value="2">заблокирован</option>
					</c:otherwise>
				</c:choose>
			</select>
		</td>
		<td>
			<input type="submit" value="применить">
		</td>
	</tr>
</table>
	
<div class="report">
<table cellspacing='1' class="table800">
	<thead>
		<tr>
			<td nowrap='1'>Дата и время</td>
			<td>Действие</td>
			<td>Исполнитель</td>
			<td>Комментарий</td>
		</tr>
	</thead>
	<tbody>
	<c:forEach var="item" items="${dataMap['gate']}" varStatus="status">
		<c:set var="p" value="${status.count}" ></c:set>
		<c:if test="${ p lt 11 }">
		<tr>
			<td>${item.date }===${p }</td>
			<td>
			<c:choose>
				<c:when test="${item.statusId == 0}">открыт</c:when>
				<c:when test="${item.statusId == 1}">закрыт</c:when>
				<c:when test="${item.statusId == 2}">заблокирован</c:when>
				<c:when test="${item.statusId == 3}">удален</c:when>
				<c:when test="${item.statusId == 4}">жестко блокирован</c:when>
				<c:otherwise>???</c:otherwise>
			</c:choose>
			</td>
			<td>
				<c:choose>
					<c:when test="${item.userId==1}">клиент</c:when>
					<c:when test="${item.userId==0}">сервер</c:when>
					<c:when test="${item.userId gt 0}">админ.</c:when>
					<c:otherwise>???</c:otherwise>
				</c:choose>
			</td>
			<td>${item.comment}</td>
		</tr>
		</c:if>
	</c:forEach>
	</tbody>
</table>
</div>
</form>
