/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRangeManager;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRangeUse;
import bitel.billing.server.util.Iter;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.modules.ipn.common.bean.AddressRange;
import ru.bitel.common.TimeUtils;

public class IPNResourceManager
extends IPResourceRangeManager {
    public IPNResourceManager(Connection con, int mid) {
        super(con, mid);
    }

    public List<IPResourceRangeUse> getResourceUse(int resourceId, int itemId, long ip1, long ip2) {
        ArrayList<IPResourceRangeUse> result = new ArrayList<IPResourceRangeUse>();
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT ruse.addr1 as ip1, ruse.addr2 as ip2, ruse.date1, ruse.date2, ruse.id as item_id, ").append(" ruse.resource_id, contract.id, contract.title, contract.comment FROM ipn_user_range_").append(this.mid);
            sb.append(" AS ruse LEFT JOIN contract ON ruse.cid=contract.id WHERE 1=1");
            if (resourceId > 0) {
                sb.append(" AND resource_id=").append(resourceId);
            }
            if (itemId > 0) {
                sb.append(" AND ruse.id=").append(itemId);
            }
            if (ip1 > 0L && ip2 > 0L) {
                sb.append(" AND (ruse.addr2>=").append(ip1);
                sb.append(" AND ruse.addr1<=").append(ip2).append(")");
            }
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IPResourceRangeUse res = this.getResourceUseFromRs(rs);
                res.setIp1(rs.getLong("ip1"));
                res.setIp2(rs.getLong("ip2"));
                result.add(res);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Iterable<IPResourceRange> getBusyResourceIterator(int categoryId, Calendar date, long ip1, long ip2, boolean mask) {
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT res.id, res.date1, res.date2, res.category_id, ruse.addr1 as ip1, ruse.addr2 as ip2, ruse.id as item_id FROM ipn_user_range_" + this.mid + " as ruse LEFT JOIN ");
            query.append(this.tableName);
            query.append(" as res ON res.id=ruse.resource_id WHERE ruse.resource_id>0 ");
            this.addFilters(categoryId, ip1, ip2, query, mask);
            query.append(" AND ( ruse.date1 IS NULL OR ruse.date1<=? ) AND ( ruse.date2 IS NULL OR ruse.date2>=?) ");
            query.append(" ORDER BY ip1");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            return new Iter.ResultSetIterator(rs, (Iter.LoadFromRS)new Iter.LoadFromRS<IPResourceRange>(){

                public IPResourceRange getFromRS(ResultSet rs) throws SQLException {
                    IPResourceRange result = IPNResourceManager.this.getResourceFromRs(rs);
                    result.setItemId(rs.getInt("item_id"));
                    return result;
                }
            }, (Statement)ps);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public Iterable<IPResourceRange> getFreeResourceIterator(int categoryId, Calendar onDate) throws BGException {
        ArrayList<IPResourceRange> result = new ArrayList<IPResourceRange>();
        try {
            StringBuilder sb = new StringBuilder(100);
            sb.append("SELECT * FROM " + this.tableName + " WHERE (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date1>=?)");
            if (categoryId > 0) {
                sb.append(" AND category_id=").append(categoryId);
            }
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)onDate));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)onDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IPResourceRange range = this.getResourceFromRs(rs);
                ArrayList<IPResourceRangeUse> useList = new ArrayList<IPResourceRangeUse>();
                PreparedStatement usedPS = this.con.prepareStatement("SELECT * FROM ipn_user_range_" + this.mid + " WHERE resource_id=?  AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) ORDER BY addr1");
                usedPS.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)onDate));
                usedPS.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)onDate));
                usedPS.setInt(1, range.getId());
                ResultSet usedRS = usedPS.executeQuery();
                while (usedRS.next()) {
                    IPResourceRangeUse ruse = new IPResourceRangeUse();
                    ruse.setResourceId(usedRS.getInt("resource_id"));
                    ruse.setDateFrom((java.util.Date)usedRS.getDate("date1"));
                    ruse.setDateTo((java.util.Date)usedRS.getDate("date2"));
                    ruse.setContractId(usedRS.getInt("cid"));
                    ruse.setItemId(usedRS.getInt("id"));
                    ruse.setIp1(usedRS.getLong("addr1"));
                    ruse.setIp2(usedRS.getLong("addr2"));
                    useList.add(ruse);
                }
                usedRS.close();
                usedPS.close();
                result.addAll(range.split(useList));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public boolean checkResourceOutRange(int resourceId, Calendar date1, Calendar date2) {
        boolean result = false;
        try {
            Date sqlDate1 = TimeUtils.convertCalendarToSqlDate((Calendar)date1);
            Date sqlDate2 = TimeUtils.convertCalendarToSqlDate((Calendar)date2);
            String query = "SELECT COUNT(*) FROM ipn_user_range_" + this.mid + " WHERE resource_id=? AND (date1 IS NOT NULL AND (? IS NULL OR ?<date1)) AND(date2 IS NOT NULL AND (? IS NULL OR ?>date2))";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, resourceId);
            ps.setDate(2, sqlDate1);
            ps.setDate(3, sqlDate1);
            ps.setDate(4, sqlDate2);
            ps.setDate(5, sqlDate2);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean wasResourceUsed(String resourceId) {
        boolean result = false;
        try {
            String query = "SELECT COUNT(*) FROM ipn_user_range_" + this.mid + " WHERE resource_id IN (" + resourceId + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            result = rs.next() && rs.getInt(1) > 0;
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public int resourceAnalize(AddressRange addressOld, AddressRange address, Map<String, NumberChange> numberMap) throws BGException, BGException {
        return this.resourceAnalize(addressOld, address);
    }

    public int resourceAnalize(AddressRange addressOld, AddressRange address) throws BGException, BGException {
        NumberChange numberChange;
        int resourceId = 0;
        HashMap<CallSite, NumberChange> numberMap = new HashMap<CallSite, NumberChange>();
        if (addressOld != null) {
            numberChange = new NumberChange();
            numberChange.changeType = 1;
            numberChange.ip1 = addressOld.getAddr1();
            numberChange.ip2 = addressOld.getAddr2();
            numberChange.oldDate1 = addressOld.getDate1();
            numberChange.oldDate2 = addressOld.getDate2();
            numberMap.put((CallSite)((Object)(numberChange.ip1 + "_" + numberChange.ip2)), numberChange);
        }
        if (address != null) {
            numberChange = (NumberChange)numberMap.get(address.getAddr1() + "_" + address.getAddr2());
            if (numberChange == null) {
                numberChange = new NumberChange();
                numberChange.changeType = 3;
                numberChange.ip1 = address.getAddr1();
                numberChange.ip2 = address.getAddr2();
                numberChange.newDate1 = address.getDate1();
                numberChange.newDate2 = address.getDate2();
                numberMap.put((CallSite)((Object)(numberChange.ip1 + "_" + numberChange.ip2)), numberChange);
            } else if (!TimeUtils.dateEqual((Calendar)numberChange.oldDate1, (Calendar)address.getDate1()) || !TimeUtils.dateEqual((Calendar)numberChange.oldDate2, (Calendar)address.getDate2())) {
                numberChange.changeType = 2;
                numberChange.newDate1 = address.getDate1();
                numberChange.newDate2 = address.getDate2();
            } else {
                numberChange.changeType = 4;
            }
        }
        for (NumberChange numberChange2 : numberMap.values()) {
            List resourceList = this.getResourceList(0, numberChange2.ip1, numberChange2.ip2, false);
            if (resourceList.size() <= 0) continue;
            IPResourceRange usedResource = null;
            if (numberChange2.changeType == 3) {
                for (IPResourceRange res : resourceList) {
                    if (!TimeUtils.periodInRange((Calendar)numberChange2.newDate1, (Calendar)numberChange2.newDate2, (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo()))) continue;
                    usedResource = res;
                    break;
                }
                if (usedResource == null) {
                    throw new BGException("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d " + IPUtils.convertLongIpToString((long)numberChange2.ip1) + "-" + IPUtils.convertLongIpToString((long)numberChange2.ip2) + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
            } else if (numberChange2.changeType == 2) {
                for (IPResourceRange res : resourceList) {
                    if (!TimeUtils.periodInRange((Calendar)numberChange2.newDate1, (Calendar)numberChange2.newDate2, (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo())) || !TimeUtils.periodInRange((Calendar)numberChange2.oldDate1, (Calendar)numberChange2.oldDate2, (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo()))) continue;
                    usedResource = res;
                    break;
                }
                if (usedResource == null) {
                    throw new BGException("\u0421\u0442\u0430\u0440\u044b\u0439 \u043b\u0438\u0431\u043e \u043d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 " + IPUtils.convertLongIpToString((long)numberChange2.ip1) + "-" + IPUtils.convertLongIpToString((long)numberChange2.ip2) + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
            } else if (numberChange2.changeType == 1) {
                for (IPResourceRange res : resourceList) {
                    if (!TimeUtils.periodInRange((Calendar)numberChange2.oldDate1, (Calendar)numberChange2.oldDate2, (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo()))) continue;
                    usedResource = res;
                    break;
                }
                if (usedResource == null) {
                    throw new BGException("\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d " + IPUtils.convertLongIpToString((long)numberChange2.ip1) + "-" + IPUtils.convertLongIpToString((long)numberChange2.ip2) + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
            } else if (numberChange2.changeType == 4) {
                for (IPResourceRange res : resourceList) {
                    if (!TimeUtils.periodInRange((Calendar)numberChange2.oldDate1, (Calendar)numberChange2.oldDate2, (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateFrom()), (Calendar)TimeUtils.convertDateToCalendar((java.util.Date)res.getDateTo()))) continue;
                    usedResource = res;
                    break;
                }
                if (usedResource == null) {
                    throw new BGException("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d " + IPUtils.convertLongIpToString((long)numberChange2.ip1) + "-" + IPUtils.convertLongIpToString((long)numberChange2.ip2) + " \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430!");
                }
            }
            if (usedResource == null) continue;
            numberChange2.resource = usedResource;
            resourceId = usedResource.getId();
        }
        return resourceId;
    }

    public void freeResources(int cid) {
    }

    public void closeResourceUse(int cid, java.util.Date date) {
    }

    public void syncResourceUse() throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE ipn_user_range_" + this.mid + " as rang LEFT JOIN ipn_user_source_" + this.mid + " as source ON rang.id=source.aid LEFT JOIN ipn_iface_" + this.mid + " as iface ON iface.source_id=source.source_id AND iface.number=source.iface AND zone_id=-3 LEFT JOIN ip_resource_range_" + this.mid + " as res ON (res.date1 IS NULL OR (rang.date1 IS NOT NULL AND res.date1<=rang.date1)) AND (res.date2 IS NULL OR (rang.date2 IS NOT NULL AND res.date2>=rang.date2)) AND (res.ip1<=rang.addr2 AND res.ip2>=rang.addr1) AND iface.id IS NOT NULL SET rang.resource_id=IFNULL(res.id, 0)");
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public static class NumberChange {
        public static final int REMOVED = 1;
        public static final int DATE_CHANGED = 2;
        public static final int ADDED = 3;
        public static final int ANOTHER_CHANGE = 4;
        public long ip1;
        public long ip2;
        public int changeType;
        public IPResourceRange resource;
        public Calendar oldDate1;
        public Calendar oldDate2;
        public Calendar newDate1;
        public Calendar newDate2;
    }
}

