/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.PPPoEUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class PPPoEGateWorker
extends GateWorker {
    @Override
    protected void doSync() {
        String host = this.gate.getGateType().getConfigOption("radius.host");
        int port = Utils.parseInt((String)this.gate.getGateType().getConfigOption("radius.port"), (int)-1);
        int gid = this.gate.getId();
        if (Utils.isEmptyString((String)host) || port <= 0) {
            this.log.error("Can't get IP/port for BGRadiusIPN for this gate type! ");
            this.gateErrors.append("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0430\u0434\u0440\u0435\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0440\u0430\u0434\u0438\u0443\u0441\u0430 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0448\u043b\u044e\u0437\u0430!");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port);
        }
        try {
            Socket socket = new Socket(host, port);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            InputStreamReader isr = new InputStreamReader(socket.getInputStream());
            BufferedReader in = new BufferedReader(isr);
            String nasId = String.valueOf(this.gate.getId());
            HashMap<Integer, String[]> ruleTypes = PPPoEUtils.getRuleTypes(this.ruleTypeMap);
            Preferences gateConfig = new Preferences(this.gate.getConfig(), "\n");
            ParameterMap nasInspectorConf = gateConfig.sub("");
            out.println(".keepalive");
            out.print("nas ");
            out.print(nasId);
            out.print('\t');
            out.print(this.gate.getHost());
            out.print('\t');
            out.print(this.gate.getKeyword());
            out.print('\t');
            String inspClass = nasInspectorConf.get("nas.inspector.class", null);
            out.print(inspClass != null ? inspClass : "");
            for (Map.Entry e : nasInspectorConf.entrySet()) {
                out.print('\t');
                out.print((String)e.getKey());
                out.print('=');
                out.print((String)e.getValue());
            }
            out.println();
            out.print("list ");
            out.println(nasId);
            HashSet<String> logins = new HashSet<String>(5, 5.0f);
            String line = in.readLine();
            while (line != null && !".".equals(line)) {
                int pos = line.indexOf("\t\t");
                if (pos >= 0) {
                    logins.add(line.substring(0, pos));
                }
                line = in.readLine();
            }
            for (UserStatus status : this.statusList) {
                String data = status.rule.getRuleText();
                int pos = data.indexOf(9);
                String login = data.substring(0, pos);
                boolean flag = false;
                if (logins.contains(login)) {
                    if (status.status > 0) {
                        out.print("delete ");
                        out.print(nasId);
                        out.print('\t');
                        out.println(login);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(gid + " Delete\t" + login);
                        }
                    }
                    flag = true;
                    logins.remove(login);
                }
                if (flag || status.status != 0) continue;
                String command = PPPoEUtils.generateRule(nasId, this.gate.getGateType(), data, ruleTypes);
                out.println(command);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(gid + " " + command + " " + in.readLine());
            }
            out.println(".");
            in.close();
            out.close();
            socket.close();
        }
        catch (Exception e) {
            this.log.error("Gate unaccesible - " + host);
            this.log.error("-------------------------");
            this.log.error("error: " + e.getLocalizedMessage());
            this.gateErrors.append("\u0428\u043b\u044e\u0437 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d - ");
            this.gateErrors.append(host);
            this.gateErrors.append("\n");
        }
    }
}

