/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.ipn.server.LogCalculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class IPNRecalculator
extends RunTaskRecalculator<LogCalculator> {
    private String cids;
    private String comment = null;

    public IPNRecalculator(int mid, Calendar dt, String email, String cids, String comment) {
        super(mid, dt, email);
        this.cids = cids;
        this.comment = comment;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            LogCalculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041e\u0431\u0441\u0447\u0435\u0442 \u043b\u043e\u0433\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\n");
                report.append("\u0412\u0440\u0435\u043c\u044f: ");
                report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailMsg msg = new MailMsg((Preferences)this.setup);
                msg.sendMessage(this.email, "\u041e\u0431\u0441\u0447\u0435\u0442 IPN \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d", report.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected LogCalculator createTask() {
        LogCalculator calculator = new LogCalculator();
        calculator.setExecutingTime(this.dt);
        calculator.setCids(this.cids);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\ntariff_detail=1\ncomment=" + this.comment);
        return calculator;
    }
}

