/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.DetailJRDataSource;
import bitel.billing.server.netflow.ipn.detail.FlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.RowSelector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.sql.Connection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;

public class JRFlowDetailMaker
extends FlowDetailMaker {
    private SoftReference<JRVirtualizer> virtualizer = null;

    @Override
    public void init(ParameterMap setup) {
    }

    private JRVirtualizer getVirtualizer(ParameterMap setup) {
        JRVirtualizer result;
        JRVirtualizer jRVirtualizer = result = this.virtualizer != null ? this.virtualizer.get() : null;
        if (result == null) {
            File tempDir = this.getTempDirectory(setup, "jrvirtualizer");
            result = new JRSwapFileVirtualizer(2, new JRSwapFile(tempDir.toString(), 1024, 1024), true);
            this.virtualizer = new SoftReference<JRSwapFileVirtualizer>((JRSwapFileVirtualizer)result);
        }
        return result;
    }

    private void zip(ZipOutputStream zos, File dir, String folder) throws IOException {
        File[] files;
        for (File f : files = dir.listFiles()) {
            int len;
            if (f.isDirectory()) {
                this.zip(zos, f, folder + f.getName() + "/");
                continue;
            }
            zos.putNextEntry(new ZipEntry(folder + f.getName()));
            FileInputStream fis = new FileInputStream(f);
            byte[] buffer = new byte[8192];
            while ((len = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
    }

    protected JasperPrint fillReport(JasperReport report, Map<String, Object> properties, Iterable<IPHourlyDataLog> logs, RowSelector selector, ZipOutputStream zos) throws JRException, IOException {
        return JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new DetailJRDataSource(logs, selector));
    }

    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterable<IPHourlyDataLog> logs, StringBuilder messageBody, String subject) throws Exception {
        String type = setup.get("ipn.collector.detail.jr.type", "html");
        boolean pdf = type.equals("pdf");
        String jrxml = setup.get("ipn.collector.detail.jr.file", "ipn_detail.jrxml");
        JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)setup, (URI)new File(jrxml).toURI());
        JRVirtualizer virtualizer = this.getVirtualizer((ParameterMap)setup);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("REPORT_VIRTUALIZER", virtualizer);
        if (!pdf) {
            properties.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        }
        properties.put("task", task);
        if (task.getModule() == 1) {
            properties.put("login", task.getDialupLogin());
            properties.put("start", task.getSessionStart());
            properties.put("end", task.getSessionEnd());
        } else {
            properties.put("addr1", IPUtils.convertLongIpToString((long)task.getIpnFromAddr()));
            properties.put("addr2", IPUtils.convertLongIpToString((long)task.getIpnToAddr()));
            if (task.isMonthPeriod()) {
                properties.put("start", task.getSessionStart());
                properties.put("end", task.getSessionEnd());
            } else {
                Calendar date1 = task.getIpnHour();
                Calendar date2 = (Calendar)date1.clone();
                date2.add(11, 1);
                date2.add(14, -1);
                properties.put("start", date1);
                properties.put("end", date2);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(524288);
        String fileName = "detail.zip";
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.setLevel(setup.getInt("ipn.collector.detail.compression.level", -1));
        JasperPrint print = this.fillReport(report, properties, logs, selector, zos);
        if (pdf) {
            zos.putNextEntry(new ZipEntry("detail.pdf"));
            JasperExportManager.exportReportToPdfStream((JasperPrint)print, (OutputStream)zos);
            zos.closeEntry();
        } else {
            File tempDir = this.getTempDirectory((ParameterMap)setup, "jrdetail");
            if (tempDir != null) {
                File temp = new File(tempDir, "detail_html/");
                if (temp.exists()) {
                    temp.delete();
                }
                temp.mkdir();
                JasperExportManager.exportReportToHtmlFile((JasperPrint)print, (String)new File(temp, "detail.html").toString());
                this.zip(zos, temp, "");
            }
        }
        virtualizer.cleanup();
        virtualizer = null;
        zos.flush();
        zos.close();
        zos = null;
        print = null;
        report = null;
        final byte[] data = bos.toByteArray();
        bos = null;
        MimeMultipart m = new MimeMultipart();
        MimeBodyPart attach = new MimeBodyPart();
        m.addBodyPart((BodyPart)attach);
        DataSource ds = new DataSource(){

            public String getContentType() {
                return "application/zip";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(data);
            }

            public String getName() {
                return "detail.zip";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
        attach.setDataHandler(new DataHandler(ds));
        attach.setFileName("detail.zip");
        this.sendDetailMail(setup, task, subject, messageBody, attach);
    }
}

