/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.editor.vlan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.editor.ManadContractRuleEditor;
import ru.bitel.bgbilling.modules.ipn.client.editor.TreePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class CiscoSwitchCommonRuleEditor
extends ManadContractRuleEditor {
    protected JTextArea ruleCISCO;
    protected BGTextField vlan;
    protected int parentId = -1;
    protected int parentTypeId = -1;

    @Override
    protected void initControlPanel() {
        this.ruleCISCO = new JTextArea();
        this.vlan = new BGTextField();
        JPanel topPanel = this.createRulePanel();
        this.controlPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        JTabbedPane tabbedPane = new JTabbedPane();
        this.addCiscoTab(tabbedPane);
        this.addSwitchTabs(tabbedPane);
        this.treeScroll = new TreePanel(this);
        this.treeScroll.setMinimumSize(new Dimension(100, 100));
        this.treeScroll.setPreferredSize(new Dimension(300, 100));
        this.treeScroll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CiscoSwitchCommonRuleEditor.this.updateCommands();
            }
        });
        this.controlPanel.add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 0.8, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.controlPanel.add((Component)((Object)this.treeScroll), new GridBagConstraints(1, 1, 1, 1, 0.2, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void addSwitchTabs(JTabbedPane tabbedPane) {
    }

    protected void addCiscoTab(JTabbedPane tabbedPane) {
        JPanel panel = new JPanel();
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0430\u0432\u0438\u043b\u043e "));
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 vlan"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.vlan, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.vlan.setEditable(false);
        this.vlan.setEnabled(false);
        JScrollPane scroll = new JScrollPane(this.ruleCISCO);
        panel.add((Component)scroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.ruleCISCO.setEditable(false);
        this.ruleCISCO.setEnabled(false);
        tabbedPane.add((Component)panel, "CISCO");
    }

    @Override
    public void setData() {
        this.initParentGate();
        this.treeScroll.setData();
        super.setData();
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GetVlan");
        req.setModuleId(this.getModuleId());
        req.setAttribute("gateId", this.parentId);
        req.setAttribute("cid", this.getContractId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element vlan = XMLUtils.getElement((Document)doc, (String)"vlan");
            this.vlan.setText(vlan.getAttribute("vid"));
        }
        this.ruleType_CB.removeItemAt(0);
    }

    protected void initParentGate() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GetParentGate");
        req.setModuleId(this.getModuleId());
        req.setAttribute("gid", this.gateId);
        Document doc = this.getDocument(req);
        Element parent = null;
        if (ClientUtils.checkStatus((Document)doc)) {
            parent = XMLUtils.getElement((Document)doc, (String)"parent");
        }
        if (parent != null) {
            if (!Utils.isEmptyString((String)parent.getAttribute("gid"))) {
                this.parentId = Integer.valueOf(parent.getAttribute("gid"));
            }
            if (!Utils.isEmptyString((String)parent.getAttribute("gtid"))) {
                this.parentTypeId = Integer.valueOf(parent.getAttribute("gtid"));
            }
        }
    }

    @Override
    protected void updateCommands() {
        String ruleType = ClientUtils.getIdFromComboBox((JComboBox)this.ruleType_CB);
        if (ruleType != null && !ruleType.equals("0") && this.parentId != -1) {
            this.updateCommandText("CiscoVlanGenerateRule", this.ruleCISCO, ruleType, String.valueOf(this.parentTypeId), this.treeScroll.getRule());
        }
        this.updateUI();
    }

    @Override
    protected void stopEdit(boolean save) {
        this.contractGates.showGates();
    }

    protected String getIPs(String data) {
        return data;
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.treeScroll.init(module, mid);
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
        this.treeScroll.setContractId(id);
    }

    @Override
    protected void setDataToTreeView() {
        this.treeScroll.setRule(this.getIPs(this.ruleData));
    }
}

