/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client.contract;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.contract.ContractPortEditor;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.RowData;

public class ContractPortPanel
extends BGUPanel {
    private BGTableModel<RowData> model;
    private BGUTable table;
    private CardLayout cardLayout = new CardLayout();
    private ContractPortEditor portEditor = new ContractPortEditor();

    protected void jbInit() {
        this.setLayout(this.cardLayout);
        this.model = new BGTableModel<RowData>("accounts"){

            protected void initColumns() {
                this.addColumn("\u0428\u043b\u044e\u0437", -1, 150, -1, null, true);
                this.addColumn("\u041f\u043e\u0440\u0442\u044b", -1, 150, 200, null, false);
            }

            public Object getValue(RowData rowData, int column) {
                Object result = null;
                switch (column) {
                    case 0: {
                        result = rowData.getJson().opt("gateName");
                        break;
                    }
                    case 1: {
                        result = rowData.getJson().opt("ports");
                    }
                }
                return result;
            }
        };
        this.table = new BGUTable(this.model);
        this.table.setSelectionMode(0);
        JPanel vlanTablePanel = new JPanel(new GridBagLayout());
        this.portEditor.setMinimumSize(new Dimension(300, 500));
        vlanTablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        vlanTablePanel.add((Component)((Object)this.portEditor), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.portEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ok")) {
                    ContractPortPanel.this.stopEdit();
                } else {
                    ContractPortPanel.this.portEditor.setVisible(false);
                }
            }
        });
        this.portEditor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractPortPanel.this.editItem();
                }
            }
        });
        this.portEditor.setVisible(false);
        this.add(vlanTablePanel, "view");
        this.cardLayout.show((Container)((Object)this), "view");
    }

    private void stopEdit() {
        Request req = ((ClientContext)this.getContext()).newRequest("GatePort");
        req.setAttribute("operation", "updateGatePort");
        if (this.portEditor.isAuto()) {
            req.setAttribute("count", this.portEditor.getCount());
            if (this.portEditor.getCount() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u043e\u0440\u0442\u043e\u0432 \u043e\u0442 1 \u0438 \u0431\u043e\u043b\u0435\u0435");
                return;
            }
        } else {
            req.setAttribute("ports", this.portEditor.getPorts());
            String str = this.portEditor.getPorts();
            if (!str.matches("^(\\d+,*)+$")) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u043e\u0434\u0438\u0442\u0435 \u043f\u043e\u0440\u0442\u044b \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e");
                return;
            }
        }
        req.setAttribute("gateId", (Object)this.portEditor.getGateId());
        if (ClientUtils.checkStatus((Document)((ClientContext)this.getContext()).getDocument(req))) {
            this.portEditor.setVisible(false);
        }
        this.setData();
    }

    protected void setData() {
        Request req = ((ClientContext)this.getContext()).newRequest("GatePort");
        req.setAttribute("operation", "getGatePortMaps");
        Result result = ((ClientContext)this.getContext()).getResponseResult(req, String.class);
        if (result != null) {
            ArrayList<RowData> data = new ArrayList<RowData>();
            for (String json : result.getList()) {
                data.add(new RowData(json));
            }
            this.model.setData(data);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ContractPortPanel.this.setData();
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ContractPortPanel.this.portEditor.setCount(1);
                ContractPortPanel.this.portEditor.setAuto(true);
                ContractPortPanel.this.portEditor.setGateId(null);
                ContractPortPanel.this.portEditor.setData();
                ContractPortPanel.this.portEditor.setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                RowData gatePorts = (RowData)ContractPortPanel.this.model.getSelectedRow();
                if (gatePorts == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0438\u0441\u044c \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0441\u0432\u043e\u0431\u043e\u0434\u0438\u0442\u044c \u043f\u043e\u0440\u0442\u044b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430 ?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                    int gateId = gatePorts.getJson().optInt("gateId");
                    Request request = ((ClientContext)ContractPortPanel.this.getContext()).newRequest("GatePort");
                    request.setAttribute("operation", "deleteGatePort");
                    request.setAttribute("gateId", gateId);
                    if (ClientUtils.checkStatus((Document)((ClientContext)ContractPortPanel.this.getContext()).getDocument(request))) {
                        ContractPortPanel.this.setData();
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ContractPortPanel.this.editItem();
            }
        };
    }

    private void editItem() {
        RowData gatePorts = (RowData)this.model.getSelectedRow();
        if (gatePorts != null) {
            int gateId = gatePorts.getJson().optInt("gateId");
            this.portEditor.setCount(1);
            this.portEditor.setAuto(false);
            this.portEditor.setGateId(gateId);
            this.portEditor.setData();
            this.portEditor.setVisible(true);
        }
    }
}

