/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.monitor;

import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelDateAndHours;
import bitel.billing.module.common.BGToggleButton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.inet.client.InetDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.monitor.ErrorTableModel;
import ru.bitel.bgbilling.modules.inet.client.monitor.ServiceConnectionsForm;
import ru.bitel.bgbilling.modules.inet.client.monitor.SessionTableModel;
import ru.bitel.bgbilling.modules.inet.common.bean.InetAuthError;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.common.service.InetAuthErrorService;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.common.service.RequestLogService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Result;

public class InetMonitorPanel
extends BGUPanel {
    private CardLayout tableCardLayout = new CardLayout();
    private JPanel tablePanel = new JPanel(this.tableCardLayout);
    private static final int MODE_ERROR = 1;
    private static final int MODE_LOG = 2;
    private static final int MODE_CURRENT = 3;
    private int mode = 1;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel label = new JLabel("\u0418\u0442\u043e\u0433\u043e: 0");
    private BGToggleButton errorButton;
    private BGToggleButton logButton;
    private InetDevicePanel devicePanel = new InetDevicePanel((ClientContext)this.getContext(), 3, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("device.selected")) {
                InetMonitorPanel.this.show.perform();
            }
        }
    });
    private BGControlPanelDateAndHours period = new BGControlPanelDateAndHours();
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect();
    private BGTextField contractField = new BGTextField();
    private BGTextField loginField = new BGTextField();
    private BGTextField ipField = new BGTextField();
    private BGTextField callingStationField = new BGTextField();
    private InetSessionService wsSession = (InetSessionService)((ClientContext)this.getContext()).getPort(InetSessionService.class);
    private InetAuthErrorService wsAuthError = (InetAuthErrorService)((ClientContext)this.getContext()).getPort(InetAuthErrorService.class);
    private InetDeviceService wsDevice = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
    private InetServService wsServ = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
    BGTableModel<InetSessionLog> model = new SessionTableModel("inetSession", this.wsDevice, this.wsServ);
    private ErrorTableModel errorModel = new ErrorTableModel("inetError");
    private boolean inited = false;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (!InetMonitorPanel.this.inited) {
                InetMonitorPanel.this.devicePanel.performAction("refresh");
                InetMonitorPanel.this.inited = true;
            } else {
                InetMonitorPanel.this.show.perform();
            }
        }
    };
    AbstractBGUPanel.AsyncAction<Result<InetAuthError>> showErrors = new AbstractBGUPanel.AsyncAction<Result<InetAuthError>>("showErrors", "\u041e\u0448\u0438\u0431\u043a\u0438"){

        protected Result<InetAuthError> doInBackground() throws Exception {
            Date timeTo;
            Date timeFrom;
            Set deviceIds = InetMonitorPanel.this.devicePanel.getSelectedDeviceIds();
            if (InetMonitorPanel.this.period.getDate() != null) {
                timeFrom = InetMonitorPanel.this.period.getDate();
                timeTo = TimeUtils.getNextDay((Date)InetMonitorPanel.this.period.getDate());
            } else {
                timeFrom = TimeUtils.subtractHoursFromNow((int)InetMonitorPanel.this.period.getHourFrom());
                timeTo = TimeUtils.subtractHoursFromNow((int)InetMonitorPanel.this.period.getHourTo());
            }
            Result result = InetMonitorPanel.this.wsAuthError.authErrorDateList(timeFrom, timeTo, deviceIds, Utils.toIntegerSet((String)InetMonitorPanel.this.contractSelect.getContracts()), null, InetMonitorPanel.this.contractField.getText(), InetMonitorPanel.this.loginField.getText(), InetMonitorPanel.this.pagePanel.getPage());
            return result;
        }

        protected void done(Result<InetAuthError> result) throws Exception {
            InetMonitorPanel.this.pagePanel.setPage(result.getPage());
            InetMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
            InetMonitorPanel.this.errorModel.setData(result.getList());
        }
    };
    AbstractBGUPanel.DefaultAction show = new AbstractBGUPanel.DefaultAction("show", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            Set deviceIds = InetMonitorPanel.this.devicePanel.getSelectedDeviceIds();
            switch (InetMonitorPanel.this.mode) {
                case 1: {
                    InetMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: 0");
                    InetMonitorPanel.this.showErrors.perform(e.getSource(), "async");
                    break;
                }
                case 2: {
                    Date timeTo;
                    Date timeFrom;
                    if (InetMonitorPanel.this.period.getDate() != null) {
                        timeFrom = InetMonitorPanel.this.period.getDate();
                        timeTo = TimeUtils.getNextDay((Date)InetMonitorPanel.this.period.getDate());
                    } else {
                        timeFrom = TimeUtils.subtractHoursFromNow((int)InetMonitorPanel.this.period.getHourFrom());
                        timeTo = TimeUtils.subtractHoursFromNow((int)InetMonitorPanel.this.period.getHourTo());
                    }
                    Result result = InetMonitorPanel.this.wsSession.inetSessionLogList(deviceIds, Utils.toIntegerSet((String)InetMonitorPanel.this.contractSelect.getContracts()), InetMonitorPanel.this.contractField.getText(), InetMonitorPanel.this.loginField.getText(), InetMonitorPanel.this.ipField.getText(), InetMonitorPanel.this.callingStationField.getText(), timeFrom, timeTo, InetMonitorPanel.this.pagePanel.getPage());
                    InetMonitorPanel.this.pagePanel.setPage(result.getPage());
                    InetMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
                    InetMonitorPanel.this.model.setData(result.getList());
                    break;
                }
                case 3: {
                    Result result = InetMonitorPanel.this.wsSession.inetSessionAliveList(deviceIds, Utils.toIntegerSet((String)InetMonitorPanel.this.contractSelect.getContracts()), InetMonitorPanel.this.contractField.getText(), InetMonitorPanel.this.loginField.getText(), InetMonitorPanel.this.ipField.getText(), InetMonitorPanel.this.callingStationField.getText(), null, null, InetMonitorPanel.this.pagePanel.getPage());
                    InetMonitorPanel.this.pagePanel.setPage(result.getPage());
                    InetMonitorPanel.this.label.setText("\u0418\u0442\u043e\u0433\u043e: " + result.getPage().getRecordCount());
                    InetMonitorPanel.this.model.setData(result.getList());
                    break;
                }
            }
        }
    };
    AbstractBGUPanel.MenuAction openContract = new AbstractBGUPanel.MenuAction("inetSession.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            InetSessionLog session = (InetSessionLog)InetMonitorPanel.this.model.getSelectedRow();
            if (session == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0441\u0441\u0438\u044e.");
                return;
            }
            InetMonitorPanel.this.openContract(session.getContractId());
        }
    };

    public InetMonitorPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.devicePanel), (String)"\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
        this.devicePanel.setMinimumSize(new Dimension(200, 100));
        this.contractField.setAction((Action)this.show);
        this.loginField.setAction((Action)this.show);
        this.ipField.setAction((Action)this.show);
        this.callingStationField.setAction((Action)this.show);
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        paramsPanel.add((Component)this.contractSelect, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 0, 3), 0, 0));
        paramsPanel.add((Component)this.contractField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d:"), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.loginField, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 3, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("IP:"), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.ipField, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)new JLabel("C \u043d\u043e\u043c\u0435\u0440\u0430/\u043d\u0430 \u043d\u043e\u043c\u0435\u0440:"), new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        paramsPanel.add((Component)this.callingStationField, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.wrapBorder((JPanel)paramsPanel, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.period.addActionListener(e -> this.performAction("refresh"));
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.show.perform();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)paramsPanel, "North");
        panel.add((Component)((Object)this.devicePanel), "Center");
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)panel, (Component)this.getRightPanel(), 300L), "Center");
    }

    protected JPanel getRightPanel() {
        BGUTable tableLog = new BGUTable(this.model);
        BGUTable tableError = new BGUTable((TableModel)((Object)this.errorModel));
        this.tablePanel.add((Component)new JScrollPane((Component)tableError), "error");
        this.tablePanel.add((Component)new JScrollPane((Component)tableLog), "log");
        BGEditor editor = new BGEditor("table");
        editor.setVisible(true);
        editor.addForm((JComponent)this.tablePanel, (Object)"table");
        editor.addForm((JComponent)((Object)new ServiceConnectionsForm(this.model)));
        BGEditor editor1 = new BGEditor();
        editor1.setVisible(false);
        editor1.addForm((JComponent)((Object)new InetLogForm()));
        BGSwingUtilites.handleEdit(null, (JTable)tableError, (AbstractBGUPanel)editor, (boolean)false);
        BGSwingUtilites.handleEdit(null, (JTable)tableLog, (AbstractBGUPanel)this, (boolean)false);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        rightPanel.add((Component)editor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)editor1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return rightPanel;
    }

    protected JPanel getFilterPanel() {
        ButtonGroup group = new ButtonGroup();
        this.errorButton = new BGToggleButton("\u041e\u0448\u0438\u0431\u043a\u0438");
        this.logButton = new BGToggleButton("\u041b\u043e\u0433\u0438");
        BGToggleButton currentButton = new BGToggleButton("\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
        group.add((AbstractButton)this.errorButton);
        group.add((AbstractButton)this.logButton);
        group.add((AbstractButton)currentButton);
        ActionListener modeListener = e -> this.performAction("button.clicked");
        this.errorButton.addActionListener(modeListener);
        this.logButton.addActionListener(modeListener);
        currentButton.addActionListener(modeListener);
        JPanel modePanel = BGSwingUtilites.wrapBorder((JPanel)new JPanel(), (String)" \u0420\u0435\u0436\u0438\u043c ");
        modePanel.add((Component)this.errorButton);
        modePanel.add((Component)this.logButton);
        modePanel.add((Component)currentButton);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)modePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)" \u041f\u0435\u0440\u0438\u043e\u0434 "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.label, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 14, 0, new Insets(0, 0, 0, 10), 0, 0));
        filterPanel.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        return filterPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("button.clicked", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetMonitorPanel.this.pagePanel.init();
                if (InetMonitorPanel.this.errorButton.isSelected()) {
                    InetMonitorPanel.this.mode = 1;
                    InetMonitorPanel.this.tableCardLayout.show(InetMonitorPanel.this.tablePanel, "error");
                } else if (InetMonitorPanel.this.logButton.isSelected()) {
                    InetMonitorPanel.this.mode = 2;
                    InetMonitorPanel.this.tableCardLayout.show(InetMonitorPanel.this.tablePanel, "log");
                } else {
                    InetMonitorPanel.this.mode = 3;
                    InetMonitorPanel.this.tableCardLayout.show(InetMonitorPanel.this.tablePanel, "log");
                }
                InetMonitorPanel.this.show.perform();
            }
        };
        new AbstractBGUPanel.MenuAction("inetSession.close", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 (\u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c)", ClientUtils.getIcon((String)"fugue/plug-disconnect")){
            {
                this.putValue("LongDescription", "<html>\u041f\u043e\u0441\u043b\u0430\u0442\u044c PoD, \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u0447\u0435\u0440\u0435\u0437 CoA, \u0441\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u043f\u043e SNMP \u0438 \u0442.\u043f.,<br>\u0432 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0442 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetSessionLog session = (InetSessionLog)InetMonitorPanel.this.model.getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 (\u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c)", null)) {
                    InetMonitorPanel.this.wsSession.connectionClose(session.getConnectionId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("inetSession.finish", "\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0435\u0435) \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", ClientUtils.getIcon((String)"fugue/plug--minus")){
            {
                this.putValue("LongDescription", "<html>\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0432 \u0411\u0414, \u043a\u0430\u043a \u0435\u0441\u043b\u0438 \u0431\u044b \u0432\u044b\u0448\u0435\u043b \u043b\u0438\u043c\u0438\u0442 \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f<br>RADIUS- \u0438\u043b\u0438 Netflow-\u043f\u0430\u043a\u0435\u0442\u0430 (connection.close.timeout).</html>");
            }

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetSessionLog session = (InetSessionLog)InetMonitorPanel.this.model.getSelectedRow();
                if (session != null && BGSwingUtilites.confirm((String)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c (\u0437\u0430\u0432\u0438\u0441\u0448\u0435\u0435) \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435", null)) {
                    InetMonitorPanel.this.wsSession.connectionFinish(session.getContractId(), session.getConnectionId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("inetError.contract", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"fugue/folder-open-document-text")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetAuthError session = (InetAuthError)InetMonitorPanel.this.errorModel.getSelectedRow();
                if (session == null || session.getContractId() <= 0) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0435\u0442\u0435 \u043e\u0448\u0438\u0431\u043a\u0443, \u0441 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0441\u0432\u044f\u0437\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
                }
                InetMonitorPanel.this.openContract(session.getContractId());
            }
        };
    }

    class InetLogForm
    extends BGUPanel {
        private JTextArea log = new JTextArea();
        private RequestLogService wsRequestLog = (RequestLogService)((ClientContext)this.getContext()).getPort(RequestLogService.class);

        InetLogForm() {
        }

        protected void jbInit() {
            JButton exit = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
            exit.addActionListener(e -> this.performActionClose());
            this.log.setEditable(false);
            this.setLayout(new GridBagLayout());
            this.add(new JScrollPane(this.log), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.add(exit, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetLogForm.this.getLog(e);
                }

                public void setEnabled(boolean enable) {
                    super.setEnabled(true);
                }
            };
            new AbstractBGUPanel.MenuAction("inetSession.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS/DHCP \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetLogForm.this.getLog(e);
                }

                public void setEnabled(boolean enable) {
                    super.setEnabled(true);
                }
            };
            new AbstractBGUPanel.MenuAction("inetError.log", "\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c RADIUS/DHCP \u043b\u043e\u0433", ClientUtils.getIcon((String)"fugue/receipt-text")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    InetLogForm.this.getLog(e);
                }

                public void setEnabled(boolean enable) {
                    super.setEnabled(true);
                }
            };
        }

        private void getLog(ActionEvent e) throws Exception {
            if (InetMonitorPanel.this.mode == 1) {
                InetAuthError error = (InetAuthError)InetMonitorPanel.this.errorModel.getSelectedRow();
                if (error != null) {
                    this.log.setText(this.wsRequestLog.authErrorLog(error.getDeviceId(), error.getLastErrorTime(), error.getLogCoordinateRecordId()));
                }
                this.performActionOpen();
            } else {
                InetSessionLog session = (InetSessionLog)InetMonitorPanel.this.model.getSelectedRow();
                if (session != null) {
                    this.log.setText(this.wsRequestLog.inetConnectionLog(session.getDeviceId(), session.getConnectionId(), session.getConnectionStart()));
                }
                this.performActionOpen();
            }
        }
    }
}

