/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.task;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServDao;
import ru.bitel.bgbilling.modules.inet.server.bean.InetServOptionDao;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class InetServPeriodTask
extends TaskBase {
    private final Logger logger = LogManager.getLogger();

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Inet. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438/\u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u043f\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0443. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.executeTaskImpl(con);
        }
        catch (BGException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public void executeTaskImpl(Connection con) throws BGException {
        List<InetServ> childrenServs;
        InetDeviceMap.InetDeviceMapItem device;
        Date now = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(now);
        int yy = calendar.get(1);
        int mm = calendar.get(2) + 1;
        EventProcessor ep = EventProcessor.getInstance();
        InetServDao inetServDao = new InetServDao(con, this.moduleId);
        InetServOptionDao servOptionDao = new InetServOptionDao(con, this.moduleId);
        ContractManager contractManager = new ContractManager(con);
        BalanceDao balanceDao = new BalanceDao(con);
        InetDeviceMap deviceMap = InetDeviceMap.getInstance(this.moduleId);
        for (InetServ inetServ : inetServDao.listToCancel(now)) {
            device = deviceMap.get(inetServ.getDeviceId());
            if (device == null) {
                this.logger.error("Device with id " + inetServ.getDeviceId() + " not found for servId:" + inetServ.getId() + " and contractId:" + inetServ.getContractId());
                continue;
            }
            if (inetServ.getParentId() <= 0) {
                childrenServs = inetServDao.listChildren(inetServ.getId());
                inetServ.setChildren(childrenServs);
            }
            ep.publish((Event)new InetSaServModifyEvent(this.moduleId, 0, inetServ, null, -1, new ArrayList(4)));
        }
        for (InetServ inetServ : inetServDao.listToCreate(now)) {
            device = deviceMap.get(inetServ.getDeviceId());
            if (device == null) {
                this.logger.error("Device with id " + inetServ.getDeviceId() + " not found for servId:" + inetServ.getId() + " and contractId:" + inetServ.getContractId());
                continue;
            }
            if (inetServ.getParentId() <= 0) {
                childrenServs = inetServDao.listChildren(inetServ.getId());
                inetServ.setChildren(childrenServs);
            }
            Contract contract = contractManager.getContractById(inetServ.getContractId());
            short deviceState = 1;
            if (inetServ.getStatus() != 0) {
                deviceState = 0;
            } else if (!StatusCache.getInstance().isModuleActiveStatus(this.moduleId, contract.getStatus())) {
                deviceState = 0;
            } else {
                int contractId = contract.isDependSub() ? contract.getSuperId() : contract.getId();
                BigDecimal balance = balanceDao.getBalance(contractId, yy, mm);
                if (contract.getBalanceLimit().compareTo(balance) > 0) {
                    deviceState = 0;
                }
            }
            ep.publish((Event)new InetSaServModifyEvent(this.moduleId, 0, null, inetServ, deviceState, servOptionDao.getInetServRealtimeOptionList(inetServ.getId(), now)));
        }
        contractManager.close();
    }
}

