/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorEventType;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServOption;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServOptionList;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.SerialUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;

@EventType(autoAcknowledge=false, timeToLive=691200000L)
@XmlRootElement
public class InetSaServModifyEvent
extends PartitionedQueueEvent {
    private static final Logger logger = LogManager.getLogger();
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(InetSaServModifyEvent.class);
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int processDeviceId;
    private final InetServ oldInetServ;
    private final InetServ newInetServ;
    @XmlAttribute
    private final short newInetServState;
    @XmlElementWrapper
    private final List<InetServOption> newInetServOptionList;
    @XmlAttribute
    private final boolean initServ;
    public static final String PACKAGE_NAME = InetSaServModifyEvent.class.getPackage().getName();

    protected InetSaServModifyEvent() {
        super(-1, -1, -1);
        this.deviceId = -1;
        this.processDeviceId = -1;
        this.oldInetServ = null;
        this.newInetServ = null;
        this.newInetServOptionList = null;
        this.newInetServState = 0;
        this.initServ = false;
    }

    public InetSaServModifyEvent(int moduleId, int syncDeviceId, InetServ oldInetServ, InetServ newInetServ, short newInetServState, List<InetServOption> newInetServOptionList) {
        this(moduleId, syncDeviceId, oldInetServ, newInetServ, newInetServState, newInetServOptionList, false);
    }

    public InetSaServModifyEvent(int moduleId, int syncDeviceId, InetServ oldInetServ, InetServ newInetServ, short newInetServState, List<InetServOption> newInetServOptionList, boolean initServ) {
        super(moduleId, oldInetServ != null ? oldInetServ.getContractId() : newInetServ.getContractId(), -1);
        this.deviceId = newInetServ != null ? newInetServ.getDeviceId() : oldInetServ.getDeviceId();
        this.processDeviceId = syncDeviceId;
        this.oldInetServ = oldInetServ;
        this.newInetServ = newInetServ;
        this.newInetServState = newInetServState;
        this.newInetServOptionList = newInetServOptionList;
        this.initServ = initServ;
    }

    public InetSaServModifyEvent(int moduleId, int deviceId, int syncDeviceId, InetServ oldInetServ, InetServ newInetServ, short newInetServState, List<InetServOption> newInetServOptionList, boolean initServ) {
        super(moduleId, oldInetServ != null ? oldInetServ.getContractId() : newInetServ.getContractId(), -1);
        this.deviceId = deviceId;
        this.processDeviceId = syncDeviceId;
        this.oldInetServ = oldInetServ;
        this.newInetServ = newInetServ;
        this.newInetServState = newInetServState;
        this.newInetServOptionList = newInetServOptionList;
        this.initServ = initServ;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
        if (this.oldInetServ != null) {
            message.setIntProperty("servId", this.oldInetServ.getId());
        } else {
            message.setIntProperty("servId", this.newInetServ.getId());
        }
    }

    public InetServ getOldInetServ() {
        return this.oldInetServ;
    }

    public InetServ getNewInetServ() {
        return this.newInetServ;
    }

    public short getNewInetServState() {
        return this.newInetServState;
    }

    public List<InetServOption> getNewInetServOptionList() {
        return this.newInetServOptionList;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; oldInetServ: ");
        sb.append(this.oldInetServ);
        sb.append("; newInetServ: ");
        sb.append(this.newInetServ);
        sb.append("; newInetServState: ");
        sb.append(this.newInetServState);
        sb.append("; newInetServOptionList: ");
        sb.append(Utils.toString(this.newInetServOptionList));
    }

    public ServiceActivatorEvent toSaEvent(Access access, ConnectionSet connectionSet, Date now) throws BGException {
        Set<Integer> deviceOptionSet;
        InetServTypeRuntime inetServTypeRuntime;
        InetServRuntime inetServRuntime;
        short oldDeviceState;
        int eventType;
        int newDeviceId;
        int oldDeviceId;
        Integer inetServId;
        InetServ oldInetServ = this.getOldInetServ();
        InetServ newInetServ = this.getNewInetServ();
        if (oldInetServ != null && newInetServ != null) {
            inetServId = newInetServ.getId();
            oldDeviceId = oldInetServ.getDeviceId();
            newDeviceId = newInetServ.getDeviceId();
            eventType = ServiceActivatorEventType.SERVICE_MODIFY.getCode();
            oldDeviceState = oldInetServ.getDeviceState();
        } else if (newInetServ != null) {
            inetServId = newInetServ.getId();
            oldDeviceId = 0;
            newDeviceId = newInetServ.getDeviceId();
            eventType = ServiceActivatorEventType.SERVICE_CREATE.getCode();
            oldDeviceState = -1;
        } else {
            inetServId = oldInetServ.getId();
            oldDeviceId = oldInetServ.getDeviceId();
            newDeviceId = 0;
            eventType = ServiceActivatorEventType.SERVICE_CANCEL.getCode();
            oldDeviceState = oldInetServ.getDeviceState();
        }
        if (newDeviceId <= 0 || oldDeviceId > 0) {
            // empty if block
        }
        if ((inetServRuntime = access.inetServRuntimeMap.get(inetServId)) == null) {
            switch (ServiceActivatorEventType.getServiceActivatorEventTypeByCode((int)eventType)) {
                case SERVICE_CREATE: {
                    inetServRuntime = access.inetServRuntimeMap.addRuntime(connectionSet, newInetServ, this.newInetServOptionList);
                    inetServTypeRuntime = (InetServTypeRuntime)access.servTypeRuntimeMap.get(newInetServ.getTypeId());
                    break;
                }
                case SERVICE_CANCEL: {
                    inetServRuntime = access.inetServRuntimeMap.newRuntime(connectionSet, oldInetServ, false);
                    inetServTypeRuntime = (InetServTypeRuntime)access.servTypeRuntimeMap.get(oldInetServ.getTypeId());
                    break;
                }
                default: {
                    logger.error("InetServRuntime not found with inetServId=" + inetServId);
                    return null;
                }
            }
            oldDeviceState = -1;
            deviceOptionSet = Collections.emptySet();
        } else {
            inetServTypeRuntime = (InetServTypeRuntime)inetServRuntime.inetServTypeRef.get();
            deviceOptionSet = inetServRuntime.getInetServ().getDeviceOptions();
            inetServRuntime.inetServOptionsList = InetServOptionList.newInstance(this.getNewInetServOptionList(), (Calendar)new GregorianCalendar());
        }
        if (inetServRuntime.getInetServ().getParentId() > 0) {
            logger.error("InetServ is child " + inetServId);
            return null;
        }
        if (oldDeviceState == -1 && this.getNewInetServState() == -1) {
            logger.info("InetServ already in deleted deviceState");
            return null;
        }
        short newState = this.getNewInetServState();
        int accessCode = 0;
        try {
            if (newState == 0 && TimeUtils.dateInRange((Date)new Date(), (Date)newInetServ.getDateFrom(), (Date)newInetServ.getDateTo()) && newInetServ.getStatus() == 0) {
                AuthResult authResult = access.authorization(inetServRuntime, inetServRuntime, true, inetServRuntime.getInetServ().getDeviceId(), inetServRuntime.getInetServ().getDeviceId(), null, null, 0, null, 0, 0, false, null, null, false, BigDecimal.ZERO, false);
                newState = authResult.accessCode == 0 ? (short)1 : 0;
                accessCode = authResult.accessCode;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        Set newOptionSet = access.inetServOptionSet(connectionSet, now.getTime(), inetServRuntime, null);
        return new ServiceActivatorEvent(access, (Event)this, this.processDeviceId, inetServRuntime, eventType, inetServId.intValue(), inetServTypeRuntime.inetServType, oldInetServ, newInetServ, oldDeviceState, newState, deviceOptionSet, newOptionSet, accessCode);
    }

    public boolean isInitServ() {
        return this.initServ;
    }

    protected String getPackageName() {
        return PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }
}

