/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.FileInfo;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskTopicMessageService;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskTopicMessageService")
public class HelpdeskTopicMessageServiceImpl
extends AbstractService
implements HelpdeskTopicMessageService {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    public Topic getTopic(int contractId, int topicId) throws BGException {
        TopicManager topicManager = new TopicManager(this.getConnection(), this.plugin);
        Topic topic = topicManager.getTopic(topicId, false);
        if (topic.getContractId() != contractId) {
            topic = null;
        }
        return topic;
    }

    public Message getMessage(int contractId, int topicId, int messageId) throws BGException {
        Message message = null;
        if (topicId > 0 && messageId > 0) {
            TopicManager topicManager = new TopicManager(this.getConnection(), this.plugin);
            Topic topic = topicManager.getTopic(topicId, false);
            message = topicManager.getMessage(messageId);
            if (topic != null && message != null) {
                if (topic.getId() != message.getTopicId()) {
                    message = null;
                } else {
                    message.setFileList(new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(message.getId()));
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    public SearchResult<Message> searchTopicMessages(int contractId, int topicId, String[] sort, Page page) throws BGException {
        TopicManager topicManager = new TopicManager(this.getConnection(), this.plugin);
        Topic topic = topicManager.getTopic(topicId, false);
        if (topic.getContractId() != contractId) {
            topic = null;
        }
        SearchResult searchResult = null;
        if (topic != null) {
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            searchResult = new SearchResult(null, page, sort);
            topicManager.searchTopicMessages((SearchResult<Message>)searchResult, topicId);
        }
        return searchResult;
    }

    public List<FileInfo> getMessageFileList(int messageId) throws BGException {
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        List messageFileList = new HelpdeskFileStorage(this.getConnection()).getFilesListByOwner(messageId);
        for (BGServerFile messageFile : messageFileList) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setId(messageFile.getId());
            fileInfo.setTitle(messageFile.getTitle());
            fileInfo.setSize(new BigDecimal(messageFile.getSize()));
            list.add(fileInfo);
        }
        return list;
    }
}

