/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.model.DirectoryItem;

public class ParamManager {
    protected Connection con;
    protected BGPluginServer plugin = null;

    public ParamManager(Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public List<DirectoryItem> getModeList() {
        ArrayList<DirectoryItem> modeList = new ArrayList<DirectoryItem>();
        for (String item : this.plugin.getSetup().get("mode.list", "off:\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d;on:\u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043e\u0431\u044b\u0447\u043d\u044b\u0439;package:\u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u0430\u043a\u0435\u0442\u043d\u044b\u0439").split(";")) {
            String[] value = item.split(":");
            if (value.length != 2) continue;
            modeList.add(new DirectoryItem(value[0], value[1]));
        }
        return modeList;
    }

    public String getContractCurrentMode(int contractId) {
        return this.getProperties(contractId).getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "on"));
    }

    public Properties getProperties(int contractId) {
        Properties properties = new Properties();
        try {
            ResultSet rs = null;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append(this.getDBTableName("helpdesk_param"));
            query.append(" WHERE cid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            rs = ps.executeQuery();
            while (rs.next()) {
                properties.put(rs.getString("name"), rs.getString("value"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    public void setProperties(int contractId, Properties properties) {
        try {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ");
            query.append(this.getDBTableName("helpdesk_param"));
            query.append(" WHERE cid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractId);
            ps.executeUpdate();
            ps.close();
            if (properties != null && properties.size() > 0) {
                query = new StringBuilder();
                query.append("INSERT INTO ");
                query.append(this.getDBTableName("helpdesk_param"));
                query.append(" SET cid=?, name=?, value=?");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, contractId);
                for (Object key : properties.keySet()) {
                    ps.setString(2, (String)key);
                    ps.setString(3, properties.getProperty((String)key, null));
                    ps.executeUpdate();
                }
                ps.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

