/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.ChangeManager;
import ru.bitel.bgbilling.server.util.UserMap;

public class ManagerChangeManager {
    protected Connection con;
    protected BGPluginServer plugin = null;

    public ManagerChangeManager(Connection con, BGPluginServer plugin) {
        this.con = con;
        this.plugin = plugin;
    }

    protected String getDBTableName(String name) {
        return name + "_" + this.plugin.getPluginUID();
    }

    public List<ChangeManager> getListOfChange(int topicId) {
        ArrayList<ChangeManager> historyList = new ArrayList<ChangeManager>();
        try {
            String query = "SELECT * FROM " + this.getDBTableName("helpdesk_topic_manager_change") + " WHERE topic_id=? ORDER BY date DESC";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, topicId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ChangeManager cm = new ChangeManager();
                cm.setComment(rs.getString("comment"));
                cm.setTopicId(rs.getInt("topic_id"));
                cm.setUserId(rs.getInt("user_id"));
                cm.setUserName(UserMap.getUser((Integer)cm.getUserId()).getName());
                cm.setDate((Date)rs.getDate("date"));
                historyList.add(cm);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return historyList;
    }
}

