/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.wrapper.MultipartWrapper;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.WebActionBase;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.HelpDeskDirectoryManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.PackageManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.event.TopicWillBeCreated;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.EmailNotification;
import ru.bitel.bgbilling.plugins.helpdesk.server.notification.TelegramNotification;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ActionHelpDesk
extends AbstractAction {
    private final Logger logger = LogManager.getLogger();
    private final BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
    private final String[] modeTitles = new String[]{"\u041d\u0435 \u043e\u043f\u043e\u0432\u0435\u0449\u0430\u0442\u044c", "\u0422\u0435\u043b\u0435\u0444\u043e\u043d", "E-mail", "SMS", "Telegram"};
    private final String[] commValueKeys = new String[]{"", "comm.phone.value", "comm.email.value", "comm.sms.value", "comm.telegram.value"};

    public ActionHelpDesk() {
        super("helpdesk");
    }

    public void execute() throws BGException {
        TopicManager topicManager;
        Topic topic;
        super.execute();
        int topicId = this.req.getInt("topicId", 0);
        if (topicId > 0 && (topic = (topicManager = new TopicManager(this.con, this.plugin)).getTopic(topicId)) != null && topic.getContractId() == this.contractId) {
            this.setResultParam("topicId", topicId);
        }
    }

    public void topicActiveList() throws BGException {
        this.topicList("active");
        this.requestDispatcher(this.moduleName, "topic_list");
    }

    public void topicArchiveList() throws BGException {
        this.topicList("archive");
        this.requestDispatcher(this.moduleName, "topic_list");
    }

    public void topicAdd() throws BGException {
        String error = null;
        String helpdeskMode = this.getMode();
        if ("off".equals(helpdeskMode)) {
            error = "offMode";
        } else {
            PackageManager packageManager = new PackageManager(this.con, this.plugin);
            if ("package".equals(helpdeskMode) && !packageManager.hasActivePackage(this.contractId)) {
                error = "activePackageNotFound";
            }
        }
        if (error == null) {
            this.setResultParam("result", true);
            Properties properties = new ParamManager(this.con, this.plugin).getProperties(this.contractId);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.setResultParam((String)entry.getKey(), entry.getValue());
            }
            int currentCommMode = Utils.parseInt((String)((String)properties.get("comm.mode")), (int)0);
            this.setResultParam("commOptions", this.getCommOptions(properties, currentCommMode));
            this.setResultParam("currentCommValue", properties.getProperty(this.commValueKeys[currentCommMode]));
            this.setCategoryData();
            List addTextValues = Utils.toList((String)this.plugin.getSetup().get("topic.additionalTextToSubject.options"));
            if (addTextValues.size() > 0) {
                addTextValues.add(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
                this.setResultParam("addTextValues", addTextValues);
                this.setResultParam("addTextTitle", this.plugin.getSetup().get("topic.additionalTextToSubject.title"));
            }
            this.setResultParam("messageUUID", UUID.randomUUID().toString());
        } else {
            this.setResultParam("result", false);
            this.setResultParam("error", error);
        }
        this.requestDispatcher(this.moduleName, "topic_add");
    }

    public void topicUpdate() throws BGException {
        Object topicTitle = this.req.get("topicTitle");
        String messageText = this.req.get("messageText");
        int topicCommMode = this.req.getInt("topicCommMode", 0);
        String addTextToSubject = this.req.get("addTextToSubject");
        if (addTextToSubject != null && !addTextToSubject.equals("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e")) {
            topicTitle = "[" + addTextToSubject + "] " + (String)topicTitle;
        }
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Topic topic = new Topic();
        topic.setContractId(this.contractId);
        topic.setClosed(false);
        topic.setComm(topicCommMode);
        topic.setCommValue(this.req.get("topicCommValue", ""));
        topic.setDate(new Date());
        BigDecimal cost = this.plugin.getSetup().getBigDecimal("topic.default.cost." + this.contractId, null);
        if (cost == null) {
            cost = this.plugin.getSetup().getBigDecimal("topic.default.cost", new BigDecimal("0.00"));
        }
        topic.setCost(cost);
        topic.setTitle((String)topicTitle);
        topic.setAutoClose(this.plugin.getSetup().getBoolean("topic.avto.closed.default", false));
        topic.setCategoryId(this.req.getInt("topicCategoryId", 0));
        topic.setSubcategoryId(this.req.getInt("topicSubcategoryId", 0));
        TopicWillBeCreated event = new TopicWillBeCreated(topic, 2, this.plugin.getPluginUID(), messageText);
        if (!event.isAllowCreate()) {
            this.setResultParam("result", false);
            this.setResultParam("error", event.getErrorMessage() != null ? event.getErrorMessage() : "\u0421\u043a\u0440\u0438\u043f\u0442 \u043d\u0435 \u0434\u0430\u0435\u0442 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u0435\u043c\u0443");
            return;
        }
        topicManager.updateTopic(topic);
        ArrayList<String> errorList = new ArrayList<String>();
        this.messageAdd(topic, messageText, this.req.get("messageUUID"), topicManager, errorList);
        if (!errorList.isEmpty()) {
            this.setResultParam("errorList", errorList);
        }
        this.setResultParam("operation", "topicActiveList");
        this.setResultParam("contentType", ActionResultContentType.json);
    }

    public void topicClose() throws BGException {
        ArrayList<String> errorList = new ArrayList<String>();
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Topic topic = topicManager.getTopic(this.req.getInt("topicId", 0));
        String errorText = "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u043a\u0440\u044b\u0442\u044c  \u0442\u0435\u043c\u0443, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u044d\u0442\u043e\u043c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0443 [%d#%s]";
        if (topic == null) {
            errorList.add(String.format(errorText, 0, "topicNotFound"));
        } else if (topic.getContractId() != this.contractId) {
            errorList.add(String.format(errorText, topic.getId(), "badOwner"));
        } else if (topic.isClosed()) {
            errorList.add(String.format(errorText, topic.getId(), "topicClosed"));
        } else if (topic.getStatus() <= 0) {
            errorList.add(String.format(errorText, topic.getId(), "noStatusNoClose"));
        } else {
            ParamManager paramManager = new ParamManager(this.con, this.plugin);
            Properties properties = paramManager.getProperties(topic.getContractId());
            String currentId = properties.getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "off"));
            topicManager.setTopicClosed(topic.getId(), true, currentId.equals("package"), -1);
        }
        if (!errorList.isEmpty()) {
            this.setResultParam("errorList", errorList);
        }
        this.setResultParam("operation", "topicActiveList");
        this.setResultParam("contentType", ActionResultContentType.json);
    }

    public void topicSubcategory() throws BGException {
        HelpDeskDirectoryManager helpDeskDirectoryManager = new HelpDeskDirectoryManager(this.con, this.plugin);
        int groupId = helpDeskDirectoryManager.getContractGroupId(this.contractId);
        List<IdTitle> subcategoryList = helpDeskDirectoryManager.getSubCategory(groupId, this.req.getInt("categoryId", 0));
        if (!subcategoryList.isEmpty()) {
            subcategoryList.add(0, new IdTitle(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430"));
            this.setResultParam("subcategoryList", subcategoryList);
        }
        this.requestDispatcher(this.moduleName, "topic_subcategory");
    }

    public void topicMessages() throws BGException {
        int topicId = this.req.getInt("topicId", 0);
        Topic topic = null;
        String packageMode = this.getMode();
        if (!"off".equals(packageMode)) {
            TopicManager topicManager = new TopicManager(this.con, this.plugin);
            topic = topicManager.getTopic(topicId);
            if (topic != null) {
                if (topic.getContractId() != this.contractId) {
                    topic = null;
                } else {
                    topicManager.setTopicClientRead(topicId);
                }
            }
        } else {
            this.setResultParam("error", "Helpdesk mode = " + packageMode);
        }
        if (topic != null) {
            int filterCount = this.req.getInt("filterCount", -1);
            int messageStartIndex = 0;
            if (filterCount > 0) {
                messageStartIndex = Math.max(0, topic.getMessages().size() - filterCount);
            }
            this.setResultParam("filterCount", filterCount);
            this.setResultParam("messageStartIndex", messageStartIndex);
            this.setResultParam("topic", topic);
            HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
            HashMap<Integer, String> userNameMap = new HashMap<Integer, String>();
            userNameMap.put(topic.getUserId(), topic.getUserName());
            for (Message message : topic.getMessages()) {
                userNameMap.put(message.getUserIdFrom(), message.getUserNameFrom());
                userNameMap.put(message.getUserIdTo(), message.getUserNameTo());
                try {
                    message.setFileList(fileStorage.getFilesListByOwner(message.getId()));
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage());
                }
            }
            this.setResultParam("userNameMap", userNameMap);
            this.setResultParam("messageUUID", UUID.randomUUID().toString());
            this.setResultParam("topicModeList", topic.isClosed() ? "topicArchiveList" : "topicActiveList");
        }
        this.requestDispatcher(this.moduleName, "topic_messages");
    }

    public void messageAdd() throws BGException {
        ArrayList<String> errorList = new ArrayList<String>();
        int topicId = this.req.getInt("topicId", 0);
        String messageText = this.req.get("messageText");
        String messageUUID = this.req.get("messageUUID");
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Topic topic = topicManager.getTopic(topicId);
        this.messageAdd(topic, messageText, messageUUID, topicManager, errorList);
        if (!errorList.isEmpty()) {
            this.setResultParam("errorList", errorList);
        }
        this.setResultParam("filterCount", this.req.getInt("filterCount", -1));
        this.setResultParam("operation", "topicMessages");
        this.setResultParam("contentType", ActionResultContentType.json);
    }

    public void messageReply() throws BGException {
        ArrayList<CallSite> errorList = new ArrayList<CallSite>();
        int topicId = this.req.getInt("topicId", 0);
        int messageId = this.req.getInt("messageId", 0);
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Topic topic = topicManager.getTopic(topicId);
        if (topic == null) {
            errorList.add((CallSite)((Object)("topic not found #" + topicId)));
        } else {
            Message message = topic.getMessages().stream().filter(m -> m.getId() == messageId).findFirst().orElse(null);
            if (message == null) {
                errorList.add((CallSite)((Object)("message not found #" + messageId)));
            } else {
                this.setResultParam("messageText", message.getBody());
            }
        }
        if (!errorList.isEmpty()) {
            this.setResultParam("errorList", errorList);
        }
        this.requestDispatcher(this.moduleName, "topic_message_text");
    }

    private void topicList(String mode) throws BGException {
        String packageMode = this.getMode();
        if ("off".equals(packageMode)) {
            this.setResultParam("error", "Helpdesk mode = " + packageMode);
            return;
        }
        int topicId = this.req.getInt("tid", -1);
        String topicName = this.req.get("topic");
        String searchString = this.req.get("searchString");
        String date1 = this.req.get("date1");
        String date2 = this.req.get("date2");
        Period period = new Period(TimeUtils.parseDate((String)date1, (String)"dd.MM.yyyy"), TimeUtils.parseDate((String)date2, (String)"dd.MM.yyyy"));
        TopicListFilter topicListFilter = new TopicListFilter();
        topicListFilter.setContractId(this.contractId);
        topicListFilter.setClosed("archive".equals(mode));
        topicListFilter.setPage(new Page(1, 666));
        topicListFilter.setAllMessage(true);
        topicListFilter.setNewUserMessage(false);
        topicListFilter.setNewManagerMessage(true);
        topicListFilter.setTopicId(topicId);
        topicListFilter.setTitle(topicName);
        topicListFilter.setPeriod(period);
        topicListFilter.setSearchString(searchString);
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        if (topicId > 0) {
            this.setResultParam("topicId", String.valueOf(topicId));
        }
        this.setResultParam("topic", topicName);
        this.setResultParam("searchString", searchString);
        this.setResultParam("date1", date1);
        this.setResultParam("date2", date2);
        this.setResultParam("topicList", topicManager.getTopicList(topicListFilter));
        this.setResultParam("statusMap", topicManager.getStatusesMap());
    }

    public void parameter() throws BGException {
        Properties properties = new ParamManager(this.con, this.plugin).getProperties(this.contractId);
        this.initProperty("comm.mode", this.plugin.getSetup().get("default.comm.mode", String.valueOf(0)), properties);
        this.initProperty("comm.phone.value", "", properties);
        this.initProperty("comm.email.value", "", properties);
        this.initProperty("comm.sms.value", "", properties);
        this.initProperty("comm.telegram.value", "", properties);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("comm.")) {
                key = this.convertKey(key);
                System.out.println(key);
            }
            this.setResultParam(key, entry.getValue());
        }
        List addTextValues = Utils.toList((String)this.plugin.getSetup().get("topic.additionalTextToSubject.options"));
        if (addTextValues.size() > 0) {
            addTextValues.add(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
            this.setResultParam("addTextValues", addTextValues);
            this.setResultParam("addTextTitle", this.plugin.getSetup().get("topic.additionalTextToSubject.title"));
        }
        int currentCommMode = Utils.parseInt((String)((String)properties.get("comm.mode")), (int)0);
        this.setResultParam("options", this.getCommOptions(properties, currentCommMode));
        this.setResultParam("currentModeTitle", this.modeTitles[currentCommMode]);
        this.requestDispatcher(this.moduleName, "parameters");
    }

    public void uploadFile() throws BGException {
        String messageUUID = this.req.get("messageUUID");
        if (this.context.getRequest() instanceof MultipartWrapper) {
            HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
            MultipartWrapper multipartWrapper = (MultipartWrapper)this.context.getRequest();
            File file = multipartWrapper.getFile("file");
            messageUUID = multipartWrapper.getParameter("messageUUID");
            BGServerFile documentFile = new BGServerFile();
            documentFile.setUuid(messageUUID);
            documentFile.setOwnerId(-1);
            documentFile.setTitle(file.getName());
            documentFile.setSize(file.length());
            documentFile.setDate(new Date());
            documentFile.setComment("");
            documentFile.setUserId(0);
            fileStorage.updateFile(documentFile);
            try {
                fileStorage.saveStream(documentFile.getId(), new FileInputStream(file));
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
            }
            this.context.getRequest().setAttribute("files", (Object)fileStorage.getFilesListByOwner(-1, messageUUID));
        }
        this.context.getRequest().setAttribute("messageUUID", (Object)messageUUID);
        this.requestDispatcher(this.moduleName, "attach_file");
    }

    private void initProperty(String key, String defaultValue, Properties properties) {
        String value = properties.getProperty(key, null);
        if (value == null) {
            properties.setProperty(key, defaultValue);
        }
    }

    private List<WebActionBase.ListItem> getCommOptions(Properties properties, int currentCommMode) {
        ArrayList<WebActionBase.ListItem> options = new ArrayList<WebActionBase.ListItem>();
        options.add(new WebActionBase.ListItem(0, this.modeTitles[0], "", currentCommMode == 0));
        this.setCommMode("comm.phone.enable", options, currentCommMode, 1, this.modeTitles, properties);
        this.setCommMode("comm.email.enable", options, currentCommMode, 2, this.modeTitles, properties);
        this.setCommMode("comm.sms.enable", options, currentCommMode, 3, this.modeTitles, properties);
        this.setCommMode("comm.telegram.enable", options, currentCommMode, 4, this.modeTitles, properties);
        return options;
    }

    private void setCommMode(String key, List<WebActionBase.ListItem> options, int currentCommMode, int commMode, String[] modeTitles, Properties properties) {
        key = "default." + (String)key;
        boolean enable = this.plugin.getSetup().getBoolean((String)key, true);
        this.context.getRequest().setAttribute(this.convertKey((String)key), (Object)enable);
        if (enable) {
            options.add(new WebActionBase.ListItem(commMode, modeTitles[commMode], properties.getProperty(this.commValueKeys[commMode]), currentCommMode == commMode));
        }
    }

    private String convertKey(String key) {
        StringBuilder k = new StringBuilder();
        Stream.of(key.split("\\.")).map(a -> a.substring(0, 1).toUpperCase().concat(a.substring(1))).forEach(a -> k.append((String)a));
        return k.length() > 0 ? k.substring(0, 1).toLowerCase() + k.substring(1) : "";
    }

    private String getMode() {
        String key = "helpdesk.package.mode";
        HttpSession session = this.context.getRequest().getSession();
        String mode = (String)session.getAttribute(key);
        if (mode == null) {
            ParamManager paramManager = new ParamManager(this.con, this.plugin);
            Properties properties = paramManager.getProperties(this.contractId);
            mode = properties.getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "on"));
            session.setAttribute(key, (Object)mode);
        }
        return mode;
    }

    protected void setCategoryData() throws BGException {
        HelpDeskDirectoryManager helpDeskDirectoryManager = new HelpDeskDirectoryManager(this.con, this.plugin);
        int groupId = helpDeskDirectoryManager.getContractGroupId(this.contractId);
        if (groupId > 0) {
            ArrayList<IdTitle> catList = new ArrayList<IdTitle>();
            Map<Integer, List<Integer>> map = helpDeskDirectoryManager.getSubCategoryIds(groupId);
            HashMap<Integer, List<Object>> rMap = new HashMap<Integer, List<Object>>();
            for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
                int idCategory = entry.getKey();
                catList.add(new IdTitle(idCategory, helpDeskDirectoryManager.getCategoryTitle(idCategory)));
                List<IdTitle> subList = helpDeskDirectoryManager.getSubcategory((Collection<Integer>)entry.getValue());
                subList.add(0, new IdTitle(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                rMap.put(idCategory, subList);
            }
            if (catList.size() > 0) {
                catList.add(0, new IdTitle(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                ArrayList<IdTitle> subList = new ArrayList<IdTitle>();
                subList.add(new IdTitle(0, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"));
                rMap.put(-1, subList);
                this.context.getRequest().setAttribute("categoryList", catList);
                this.context.getRequest().setAttribute("subCategoryMap", rMap);
            }
            ArrayList<String[]> catAllList = new ArrayList<String[]>();
            catAllList.add(new String[]{"0", "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e"});
            for (Map.Entry<Integer, List<Integer>> entry : map.entrySet()) {
                int categoryId = entry.getKey();
                String categoryTitle = helpDeskDirectoryManager.getCategoryTitle(categoryId);
                helpDeskDirectoryManager.getSubcategory((Collection<Integer>)entry.getValue()).forEach(a -> catAllList.add(new String[]{categoryId + "_" + a.getId(), categoryTitle + " / " + a.getTitle()}));
            }
            this.context.getRequest().setAttribute("categorys", catAllList);
        }
    }

    protected List<BGServerFile> fileUploadRequest(Message message) throws BGException {
        ArrayList<BGServerFile> fileList = new ArrayList<BGServerFile>();
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
        if (!(this.context.getRequest() instanceof MultipartWrapper)) {
            return fileList;
        }
        MultipartWrapper multi = (MultipartWrapper)this.context.getRequest();
        Set files = multi.getFileNames();
        for (String name : files) {
            String filename = multi.getFilesystemName(name);
            File f = multi.getFile(name);
            if (f == null) continue;
            BGServerFile documentFile = new BGServerFile();
            documentFile.setOwnerId(message.getId());
            documentFile.setTitle(filename);
            documentFile.setSize(f.length());
            documentFile.setComment("message #" + message.getId());
            documentFile.setDate(new Date());
            documentFile.setUserId(0);
            fileStorage.updateFile(documentFile);
            if (documentFile.getId() > 0) {
                try {
                    fileStorage.saveStream(documentFile.getId(), new FileInputStream(f));
                }
                catch (Exception e) {
                    fileStorage.deleteFile(documentFile.getId());
                    throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n" + e.getLocalizedMessage());
                }
                fileList.add(documentFile);
                continue;
            }
            this.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
        }
        return fileList;
    }

    private List<BGServerFile> updateFileOwner(String messageUUID, int messageId) throws BGException {
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
        List fileList = fileStorage.getFilesListByOwner(-1, messageUUID);
        fileList.forEach(arg_0 -> this.lambda$updateFileOwner$4(messageId, (FileStorage)fileStorage, arg_0));
        return fileList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void messageAdd(Topic topic, String messageText, String messageUUID, TopicManager topicManager, List<String> errorList) throws BGException {
        String packageMode = this.getMode();
        if ("off".equals(packageMode)) {
            errorList.add("helpdeskModeOff");
            return;
        } else if (topic == null) {
            errorList.add("topicNotFound");
            return;
        } else if (topic.getContractId() != this.contractId) {
            errorList.add("badOwner");
            return;
        } else if (topic.isClosed()) {
            errorList.add("topicClosed");
            return;
        } else if (messageText == null || messageText.trim().isEmpty()) {
            errorList.add("bodyEmpty");
            return;
        } else {
            Message message = new Message();
            message.setTopicId(topic.getId());
            message.setBody(messageText);
            message.setDateFrom(new Date());
            message.setUserIdFrom(0);
            topicManager.updateTopicMessage(message);
            List<BGServerFile> fileList = this.updateFileOwner(messageUUID, message.getId());
            int userId = topic.getUserId();
            if (userId > 0) {
                try (UserManager userManager = new UserManager(this.con);){
                    User user = (User)userManager.get(userId);
                    if (user == null) return;
                    EmailNotification.sendMessage(user.getConfigSetup().get("helpdesk.mail", null), topic, messageText);
                    TelegramNotification.sendMessage(user.getConfigSetup().get("telegram.user.id", null), user.getId(), topic, message, TelegramNotification.getMessageText(topic, message, fileList, true));
                    return;
                }
            } else {
                TelegramNotification.sendMessage(topic, message, TelegramNotification.getMessageText(topic, message, fileList, false));
            }
        }
    }

    private /* synthetic */ void lambda$updateFileOwner$4(int messageId, FileStorage fileStorage, BGServerFile a) {
        try {
            a.setOwnerId(messageId);
            fileStorage.updateFile(a);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }
}

