/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.hd.common.bean.EventConst;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.CPEvent;
import ru.bitel.bgbilling.modules.hd.server.bean.CPEventManager;
import ru.bitel.bgbilling.modules.hd.server.bean.Period;
import ru.bitel.bgbilling.modules.hd.server.bean.PeriodManager;
import ru.bitel.common.TimeUtils;

public class ActionEventTable
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        int cpid = this.getIntParameter("cpid", -1);
        if (this.mid <= 0 || cpid <= 0) {
            throw new BGIllegalArgumentException();
        }
        PeriodManager pm = new PeriodManager(this.con, this.mid);
        Map<Integer, Period> periodMap = pm.getPeriodMap();
        for (CPEvent event : new CPEventManager(this.con, this.mid).getEventList(cpid)) {
            Element row = this.createElement(data, "row");
            row.setAttribute("date", TimeUtils.format((Calendar)event.getTime(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("type", EventConst.typeToString((int)event.getType()));
            if (event.getPeriodId() <= 0) continue;
            Period period = periodMap.get(event.getPeriodId());
            if (period != null) {
                row.setAttribute("period", period.getTitle());
                continue;
            }
            row.setAttribute("period", "???");
        }
    }
}

