/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;

public class ForwardManager {
    private Connection con;
    private int mid;

    public ForwardManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public int getForwardCount(int accountID) {
        int result = 0;
        try {
            String query = "SELECT COUNT(*) FROM email_forward_" + this.mid + " WHERE aid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Forward> getForwardList(int accountID) {
        ArrayList<Forward> result = new ArrayList<Forward>();
        try {
            Forward forward = null;
            String query = "SELECT * FROM email_forward_" + this.mid + " WHERE aid=? ORDER BY email";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                forward = new Forward();
                this.loadForwardFromRS(forward, rs);
                result.add(forward);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateForwardList(int accountID, List<Forward> forwardList) {
        try {
            String query = "DELETE FROM email_forward_" + this.mid + " WHERE aid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO email_forward_" + this.mid + " ( aid, email ) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, accountID);
            for (Forward forward : forwardList) {
                ps.setString(2, forward.getEmail());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadForwardFromRS(Forward forward, ResultSet rs) throws SQLException {
        forward.setAccountId(rs.getInt("aid"));
        forward.setEmail(rs.getString("email"));
    }
}

