/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionUpdatePassword
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        int accountId = this.getIntParameter("lid", -1);
        String value = this.getParameter("value");
        if (accountId < 0 || this.mid < 0 || value == null) {
            throw new BGIllegalArgumentException();
        }
        if (Utils.notBlankString((String)this.getParameter("set_pswd"))) {
            value = PswdGen.generatePassword((ParameterMap)this.moduleSetup);
        } else {
            String error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)value, (String)value);
            if (error != null) {
                throw new BGException(error);
            }
        }
        AccountManager am = new AccountManager(this.con, this.mid);
        Account account = am.getAccountById(accountId);
        account.setPassword(value);
        account.setForwardList(new ForwardManager(this.con, this.mid).getForwardList(account.getId()));
        account.setAttributes(new AttributeValueManager(this.con, this.mid).getValueList(account.getId()));
        DomainManager dm = new DomainManager(this.con, this.mid);
        Domain domain = dm.get(account.getDomainId());
        if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
            dm.getServiceActivator(domain).modify(account);
        }
        am.updateAccount(account);
        this.updatePasswordLog(this.userId, accountId);
    }

    protected void updatePasswordLog(int userId, int accountId) throws SQLException {
        PreparedStatement ps = this.con.prepareStatement("INSERT INTO VALUES ( NOW(), ?, ?, ? )");
        ps.setInt(1, userId);
        ps.setInt(2, this.mid);
        ps.setInt(3, accountId);
        ps.executeUpdate();
        ps.close();
    }
}

