/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatusLogItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class DocumentStatusDao
extends AbstractDao<DocumentStatus>
implements Directory<DocumentStatus> {
    private static final String LOG_TABLE = "documents_status_log";

    public DocumentStatusDao(Connection con) {
        super(con, -1, "documents_status");
    }

    protected void updateImpl(DocumentStatus b) throws BGException, SQLException {
        String query = b.getId() <= 0 ? "INSERT INTO " + this.tableName + "(title) VALUES (?)" : "UPDATE " + this.tableName + " SET title=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public DocumentStatus get(int id) throws BGException {
        DocumentStatus result = null;
        try {
            result = (DocumentStatus)this.getById(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public List<DocumentStatus> list() throws BGException {
        return this.list("", "id", new Object[0]);
    }

    public List<DocumentStatusLogItem> getStatusHistory(int documentId) throws BGException {
        ArrayList<DocumentStatusLogItem> result = new ArrayList<DocumentStatusLogItem>();
        String query = "SELECT * FROM documents_status_log WHERE id_document=" + documentId;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(new DocumentStatusLogItem(rs.getInt("id"), rs.getInt("id_document"), rs.getInt("status"), TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("date")), rs.getString("comment"), rs.getInt("user")));
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public int delete(int id) throws BGException {
        int result = 0;
        try {
            result = this.deleteImpl(id);
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public void addStatusLog(DocumentStatusLogItem item) throws BGException {
        String query = "INSERT INTO documents_status_log(id_document, date, status, comment, user) VALUES ( ?,?,?,?,? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, item.getDocumentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)item.getStatusDate()));
            ps.setInt(index++, item.getStatusId());
            ps.setString(index++, item.getComment());
            ps.setInt(index++, item.getUserId());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public DocumentStatus get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    protected DocumentStatus getFromRS(ResultSet rs) throws SQLException, BGException {
        return new DocumentStatus(rs.getInt("id"), rs.getString("title"));
    }
}

