/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.client.directory.DirectoryTableModel;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;

public class StatusEditor
extends BGUPanel {
    private BGUTable statusTable;
    private StatusTableModel statusTableModel;
    private JButton addButton = new JButton(ClientUtils.getIcon((String)"add.png"));
    private JButton deleteButton = new JButton(ClientUtils.getIcon((String)"delete.png"));
    private Directory<DocumentStatus> statusDirectory;
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refreshStatus", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            StatusEditor.this.statusTableModel.setData(StatusEditor.this.statusDirectory.list());
        }
    };
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("newStatus", "\u041d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            List list = StatusEditor.this.statusTableModel.getRows();
            if (list.size() == 0 || ((DocumentStatus)list.get(list.size() - 1)).getId() > 0) {
                StatusEditor.this.statusTableModel.addRow(new DocumentStatus());
                StatusEditor.this.statusTable.repaint();
                StatusEditor.this.statusTable.updateUI();
            }
        }
    };
    AbstractBGUPanel.DefaultAction deleteAction = new AbstractBGUPanel.DefaultAction("deleteStatus", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            DocumentStatus selectedRow = (DocumentStatus)StatusEditor.this.statusTableModel.getSelectedRow();
            if (selectedRow.getId() > 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", 0) == 0) {
                    StatusEditor.this.statusDirectory.delete(selectedRow.getId());
                }
            } else if (selectedRow.getId() == 0) {
                StatusEditor.this.statusTableModel.deleteSelectedRows();
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            StatusEditor.this.performAction("refreshStatus");
        }
    };

    public StatusEditor() {
        this.statusTableModel = new StatusTableModel(StatusEditor.class.getName());
    }

    protected void jbInit() throws Exception {
        this.statusDirectory = ((ClientContext)this.getContext()).getDirectory(DocumentStatus.class);
        this.statusTable = new BGUTable((TableModel)((Object)this.statusTableModel));
        this.statusTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    StatusEditor.this.performAction("delete");
                }
            }
        });
        this.addButton.setToolTipText("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusEditor.this.performAction("newStatus");
            }
        });
        this.deleteButton.setToolTipText("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatusEditor.this.performAction("deleteStatus");
            }
        });
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttonPanel.add((Component)this.deleteButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.statusTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    class StatusTableModel
    extends DirectoryTableModel<DocumentStatus> {
        public StatusTableModel(String name) {
            super(name);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DocumentStatus val = (DocumentStatus)this.getSelectedRow();
            String oldValue = val.getTitle();
            String newValue = (String)value;
            if (Utils.notBlankString((String)newValue)) {
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                val.setTitle(newValue);
                try {
                    StatusEditor.this.statusDirectory.update((Id)val);
                }
                catch (BGException e) {
                    ((ClientContext)StatusEditor.this.getContext()).processException((Throwable)e);
                }
            } else if (val.getId() <= 0) {
                StatusEditor.this.performAction("refresh");
            }
            StatusEditor.this.performAction("refreshStatus");
        }
    }
}

