/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContactTypeDao
extends AbstractIdDao<ContactType> {
    private static ConcurrentHashMap<Integer, ContactType> cache = null;

    public ContactTypeDao(Connection con) {
        super(con, 0, "dispatch_contact_type");
    }

    protected void updateImpl(ContactType b) throws BGException, SQLException {
        if (b.getId() > 0) {
            StringBuilder query = new StringBuilder();
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET title=?, pattern=?, description=?, pid=? WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getPattern());
            ps.setString(index++, b.getDescription());
            ps.setInt(index++, b.getPid());
            ps.setInt(index++, b.getId());
            ps.executeUpdate();
            ps.close();
        } else {
            StringBuilder query = new StringBuilder();
            query.append("INSERT INTO ");
            query.append(this.tableName);
            query.append("(title, pattern, description, pid) VALUES(?,?,?,?)");
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getPattern());
            ps.setString(index++, b.getDescription());
            ps.setInt(index++, b.getPid());
            ps.executeUpdate();
            b.setId(ServerUtils.lastInsertId((Connection)this.con));
            ps.close();
        }
        if (cache != null) {
            cache.put(b.getId(), b);
        }
    }

    protected ContactType getFromRS(ResultSet rs) throws SQLException, BGException {
        ContactType ct = new ContactType();
        ct.setId(rs.getInt(this.tableName + ".id"));
        ct.setTitle(rs.getString(this.tableName + ".title"));
        ct.setPattern(rs.getString(this.tableName + ".pattern"));
        ct.setDescription(rs.getString(this.tableName + ".description"));
        ct.setPid(rs.getInt(this.tableName + ".pid"));
        return ct;
    }

    public ContactType get(int id) throws BGException {
        return cache == null ? (ContactType)super.get(id) : cache.get(id);
    }

    public List<ContactType> getList() throws BGException {
        List result = this.list("", "title", new Object[0]);
        if (cache == null) {
            cache = new ConcurrentHashMap();
            for (ContactType ct : result) {
                cache.put(ct.getId(), ct);
            }
        }
        return result;
    }
}

