/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class DialUpSessionUtils {
    private Connection con;
    private int mid = -1;

    public DialUpSessionUtils(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public void setSessionAccount(Calendar date, int sessionId, int serviceId, float sum, int cid) {
        String sessionAccountTableName = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)date.getTime(), (int)this.mid);
        try {
            String query = "UPDATE " + sessionAccountTableName + " SET summa=? WHERE sid=? AND session_id=? ";
            PreparedStatement psUpdateSessionAccount = this.con.prepareStatement(query);
            psUpdateSessionAccount.setFloat(1, sum);
            psUpdateSessionAccount.setInt(2, serviceId);
            psUpdateSessionAccount.setInt(3, sessionId);
            if (psUpdateSessionAccount.executeUpdate() == 0) {
                query = "INSERT INTO " + sessionAccountTableName + " ( sid, summa, cid, session_id )  VALUES(?, ?, ?, ?)";
                PreparedStatement psInsertSessionAccount = this.con.prepareStatement(query);
                psInsertSessionAccount.setInt(1, serviceId);
                psInsertSessionAccount.setFloat(2, sum);
                psInsertSessionAccount.setInt(3, cid);
                psInsertSessionAccount.setInt(4, sessionId);
                psInsertSessionAccount.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setContractAccountFromSessionAccount(Calendar time, int cid) {
        String sessionAccountTableName = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)time.getTime(), (int)this.mid);
        if (!ServerUtils.tableExists((Connection)this.con, (String)sessionAccountTableName)) {
            return;
        }
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            String query = "SELECT sid, SUM(summa) FROM " + sessionAccountTableName + " WHERE cid=? GROUP BY sid";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int sid = rs.getInt(1);
                float sum = rs.getFloat(2);
                bu.setContractAccount(cid, time.getTime(), sid, sum);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Map<Integer, List<ServiceRange>> getServiceRangeMap(int cid, String sids) {
        HashMap<Integer, List<ServiceRange>> result = new HashMap<Integer, List<ServiceRange>>();
        try {
            String query = "SELECT sid, date1, date2 FROM contract_service WHERE cid=? AND sid IN ( " + sids + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ServiceRange range = new ServiceRange();
                int sid = rs.getInt(1);
                range.fromDate = TimeUtils.convertDateToCalendar((Date)rs.getDate(2));
                range.toDate = TimeUtils.convertDateToCalendar((Date)rs.getDate(3));
                ArrayList<ServiceRange> rangeList = (ArrayList<ServiceRange>)result.get(sid);
                if (rangeList == null) {
                    rangeList = new ArrayList<ServiceRange>();
                    result.put(sid, rangeList);
                }
                rangeList.add(range);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static float getPart(Calendar periodFrom, Calendar periodTo, int sid, Map<Integer, List<ServiceRange>> ranges) {
        float result = 0.0f;
        List<ServiceRange> rangeList = ranges.get(sid);
        if (rangeList != null) {
            for (ServiceRange range : rangeList) {
                if (range.fromDate != null && !TimeUtils.dateBeforeOrEq((Calendar)range.fromDate, (Calendar)periodTo) || range.toDate != null && !TimeUtils.dateBeforeOrEq((Calendar)periodFrom, (Calendar)range.toDate)) continue;
                result += TimeUtils.getPart((Calendar)range.fromDate, (Calendar)range.toDate, (Calendar)periodFrom, (Calendar)periodTo);
            }
        }
        if (result == 0.0f || result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    public void deleteSessionAccountAndDetailById(int sessionId, Date month) throws BGException {
        PreparedStatement ps;
        String query;
        String tableName = ServerUtils.getModuleMonthTableName((String)"session_account", (Date)month, (int)this.mid);
        if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            try {
                query = "DELETE FROM " + tableName + " WHERE session_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, sessionId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        if (ServerUtils.tableExists((Connection)this.con, (String)(tableName = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)month, (int)this.mid)))) {
            try {
                query = "DELETE FROM " + tableName + " WHERE session_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, sessionId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        if (ServerUtils.tableExists((Connection)this.con, (String)(tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)month, (int)this.mid)))) {
            try {
                query = "UPDATE " + tableName + " SET session_cost=0 WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, sessionId);
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public static class ServiceRange {
        public Calendar fromDate;
        public Calendar toDate;
    }
}

